/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.EnumProperty;
import org.structr.schema.Schema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;

public class EnumPropertyParser
extends PropertySourceGenerator {
    private String enumTypeName = "";
    private String enumType = "";

    public EnumPropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return EnumProperty.class.getSimpleName();
    }

    @Override
    public String getValueType() {
        return this.enumTypeName;
    }

    @Override
    public String getUnqualifiedValueType() {
        return this.enumTypeName;
    }

    @Override
    public String getPropertyParameters() {
        return this.enumType;
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.Enum;
    }

    @Override
    public void parseFormatString(Schema entity, String expression) throws FrameworkException {
        String[] enumTypes = expression.split("[, ]+");
        if (StringUtils.isNotBlank((CharSequence)expression) && enumTypes.length > 0) {
            this.enumTypeName = StringUtils.capitalize((String)this.getSourcePropertyName());
            this.enumType = ", " + this.enumTypeName + ".class";
            StringBuilder buf = new StringBuilder();
            buf.append("\n\tpublic enum ").append(this.enumTypeName).append(" {\n\t\t");
            for (int i = 0; i < enumTypes.length; ++i) {
                String element = enumTypes[i];
                if (element.matches("[a-zA-Z_]{1}[a-zA-Z0-9_]*")) {
                    buf.append(element);
                    if (i >= enumTypes.length - 1) continue;
                    buf.append(", ");
                    continue;
                }
                this.reportError(new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), expression, "invalid_property_definition", "Invalid enum type name, must match [a-zA-Z_]{1}[a-zA-Z0-9_]*."));
            }
            buf.append("\n\t};");
            this.addEnumDefinition(buf.toString());
        } else {
            this.reportError(new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), expression, "invalid_property_definition", "No enum types found, please specify a list of types, e.g. (red, green, blue)"));
        }
    }

    @Override
    public String getDefaultValue() {
        return this.enumTypeName.concat(".").concat(this.getSourceDefaultValue());
    }
}

