/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.property.StringProperty;
import org.structr.schema.Schema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.Validator;

public abstract class PropertySourceGenerator {
    private final Set<String> compoundIndexKeys = new LinkedHashSet<String>();
    private final Set<Validator> globalValidators = new LinkedHashSet<Validator>();
    private final Set<String> enumDefinitions = new LinkedHashSet<String>();
    protected PropertyDefinition source = null;
    protected ErrorBuffer errorBuffer = null;
    protected String className = "";

    public abstract SchemaHelper.Type getKey();

    public abstract String getPropertyType();

    public abstract String getValueType();

    public abstract String getUnqualifiedValueType();

    public abstract String getPropertyParameters();

    public abstract void parseFormatString(Schema var1, String var2) throws FrameworkException;

    public PropertySourceGenerator(ErrorBuffer errorBuffer, String className, PropertyDefinition propertyDefinition) {
        this.errorBuffer = errorBuffer;
        this.className = className;
        this.source = propertyDefinition;
    }

    public void getPropertySource(StringBuilder buf, Schema entity) throws FrameworkException {
        if (this.source.isNotNull()) {
            this.globalValidators.add(new Validator("isValidPropertyNotNull", this.className, this.source.getPropertyName()));
        }
        if (this.source.isUnique()) {
            this.globalValidators.add(new Validator("isValidUniqueProperty", this.className, this.source.getPropertyName()));
        }
        if (this.source.isCompound()) {
            this.compoundIndexKeys.add(SchemaHelper.cleanPropertyName(this.source.getPropertyName()) + "Property");
        }
        this.parseFormatString(entity, this.source.getFormat());
        this.getPropertySource(buf);
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getCompoundIndexKeys() {
        return this.compoundIndexKeys;
    }

    public Set<Validator> getGlobalValidators() {
        return this.globalValidators;
    }

    public void addGlobalValidator(Validator validator) {
        this.globalValidators.add(validator);
    }

    public Set<String> getEnumDefinitions() {
        return this.enumDefinitions;
    }

    public String getSourcePropertyName() {
        return this.source.getPropertyName();
    }

    public void reportError(ErrorToken error) {
        this.errorBuffer.add(error);
    }

    public ErrorBuffer getErrorBuffer() {
        return this.errorBuffer;
    }

    public void addEnumDefinition(String item) {
        this.enumDefinitions.add(item);
    }

    public String getSourceDefaultValue() {
        return this.source.getDefaultValue();
    }

    public String getDefaultValue() {
        return this.getSourceDefaultValue();
    }

    public void createSchemaPropertyNode(AbstractSchemaNode schemaNode, String underscorePropertyName) throws FrameworkException {
        App app = StructrApp.getInstance();
        String propertyName = this.getSourcePropertyName();
        if (app.nodeQuery(SchemaProperty.class).and(SchemaProperty.schemaNode, schemaNode).and(AbstractNode.name, propertyName).getFirst() == null) {
            app.create(SchemaProperty.class, new NodeAttribute<String>(AbstractNode.name, propertyName), new NodeAttribute<AbstractSchemaNode>(SchemaProperty.schemaNode, schemaNode), new NodeAttribute<String>(SchemaProperty.propertyType, this.getKey().name()), new NodeAttribute<String>(SchemaProperty.contentType, this.source.getContentType()), new NodeAttribute<String>(SchemaProperty.dbName, this.source.getDbName()), new NodeAttribute<String>(SchemaProperty.defaultValue, this.source.getDefaultValue()), new NodeAttribute<String>(SchemaProperty.format, this.source.getFormat()), new NodeAttribute<Boolean>(SchemaProperty.compound, this.source.isCompound()), new NodeAttribute<Boolean>(SchemaProperty.unique, this.source.isUnique()), new NodeAttribute<Boolean>(SchemaProperty.indexed, this.source.isIndexed()), new NodeAttribute<Boolean>(SchemaProperty.notNull, this.source.isNotNull()), new NodeAttribute<String>(SchemaProperty.readFunction, this.source.getReadFunction()), new NodeAttribute<String>(SchemaProperty.writeFunction, this.source.getWriteFunction()));
            schemaNode.removeProperty(new StringProperty(underscorePropertyName));
        }
    }

    protected void getPropertySource(StringBuilder buf) {
        buf.append("\tpublic static final Property<").append(this.getValueType()).append("> ").append(SchemaHelper.cleanPropertyName(this.source.getPropertyName())).append("Property");
        buf.append(" = new ").append(this.getPropertyType()).append("(\"").append(this.source.getPropertyName()).append("\"");
        if (StringUtils.isNotBlank((CharSequence)this.source.getDbName())) {
            buf.append(", \"").append(this.source.getDbName()).append("\"");
        }
        buf.append(this.getPropertyParameters());
        buf.append(")");
        if (StringUtils.isNotBlank((CharSequence)this.source.getContentType())) {
            buf.append(".contentType(\"").append(this.source.getContentType()).append("\")");
        }
        if (StringUtils.isNotBlank((CharSequence)this.source.getDefaultValue())) {
            buf.append(".defaultValue(").append(this.getDefaultValue()).append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)this.source.getFormat())) {
            buf.append(".format(\"").append(StringEscapeUtils.escapeJava((String)this.source.getFormat())).append("\")");
        }
        if (StringUtils.isNotBlank((CharSequence)this.source.getReadFunction())) {
            buf.append(".readFunction(\"").append(StringEscapeUtils.escapeJava((String)this.source.getReadFunction())).append("\")");
        }
        if (StringUtils.isNotBlank((CharSequence)this.source.getWriteFunction())) {
            buf.append(".writeFunction(\"").append(StringEscapeUtils.escapeJava((String)this.source.getWriteFunction())).append("\")");
        }
        if (this.source.isUnique()) {
            buf.append(".unique()");
        }
        if (this.source.isCompound()) {
            buf.append(".compound()");
        }
        if (this.source.isNotNull()) {
            buf.append(".notNull()");
        }
        if (this.source.isIndexed()) {
            if (StringUtils.isNotBlank((CharSequence)this.source.getDefaultValue())) {
                buf.append(".indexedWhenEmpty()");
            } else {
                buf.append(".indexed()");
            }
        }
        buf.append(".dynamic()");
        buf.append(";\n");
    }
}

