/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.apache.commons.lang3.StringUtils;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;

public class StringBasedPropertyDefinition
implements PropertyDefinition {
    private String propertyName = null;
    private SchemaHelper.Type propertyType = null;
    private String rawSource = null;
    private String source = null;
    private String dbName = null;
    private String format = null;
    private String defaultValue = null;
    private String contentType = null;
    private boolean notNull = false;
    private boolean compound = false;
    private boolean unique = false;
    private boolean indexed = true;
    private String readFunction = null;
    private String writeFunction = null;

    public StringBasedPropertyDefinition(String propertyName, String rawSource) {
        this.propertyName = propertyName;
        this.rawSource = rawSource;
        this.source = rawSource;
        if (this.propertyName.startsWith("_")) {
            this.propertyName = this.propertyName.substring(1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.source)) {
            this.format = StringBasedPropertyDefinition.substringBetween(this.source, "(", ")");
            this.source = this.source.replaceFirst("\\(.*\\)", "");
        }
        if (this.source.contains("|")) {
            this.dbName = this.source.substring(0, this.source.indexOf("|"));
            this.source = this.source.substring(this.source.indexOf("|") + 1);
        }
        if (this.source.startsWith("+")) {
            this.source = this.source.substring(1);
            this.notNull = true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.source)) {
            this.contentType = StringBasedPropertyDefinition.substringBetween(this.source, "[", "]");
            this.source = this.source.replaceFirst("\\[.*\\]", "");
        }
        if (this.source.contains(":")) {
            int firstIndex = this.source.indexOf(":");
            this.defaultValue = this.source.substring(firstIndex + 1);
            this.source = this.source.substring(0, firstIndex);
        }
        if (this.source.endsWith("!!")) {
            this.compound = true;
            this.source = this.source.substring(0, this.source.length() - 2);
        } else if (this.source.endsWith("!")) {
            this.unique = true;
            this.source = this.source.substring(0, this.source.length() - 1);
        }
        this.propertyType = SchemaHelper.Type.valueOf(this.source);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public SchemaHelper.Type getPropertyType() {
        return this.propertyType;
    }

    @Override
    public String getRawSource() {
        return this.rawSource;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public boolean isCompound() {
        return this.compound;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getReadFunction() {
        return this.readFunction;
    }

    @Override
    public String getWriteFunction() {
        return this.writeFunction;
    }

    public static String substringBetween(String source, String prefix, String suffix) {
        int pos2;
        int pos1 = source.indexOf(prefix);
        if (pos1 < (pos2 = source.lastIndexOf(suffix)) && pos2 > 0) {
            return source.substring(pos1 + 1, pos2);
        }
        return null;
    }
}

