/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.StringProperty;
import org.structr.schema.Schema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;
import org.structr.schema.parser.Validator;

public class StringPropertySourceGenerator
extends PropertySourceGenerator {
    public StringPropertySourceGenerator(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return StringProperty.class.getSimpleName();
    }

    @Override
    public String getValueType() {
        return String.class.getName();
    }

    @Override
    public String getUnqualifiedValueType() {
        return "String";
    }

    @Override
    public String getPropertyParameters() {
        return "";
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.String;
    }

    @Override
    public void parseFormatString(Schema entity, String expression) throws FrameworkException {
        if ("[]".equals(expression)) {
            this.reportError(new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), expression, "invalid_validation_expression", "Empty validation expression."));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)expression) && !"multi-line".equals(expression)) {
            this.addGlobalValidator(new Validator("isValidStringMatchingRegex", this.className, this.source.getPropertyName(), expression));
        }
    }

    @Override
    public String getDefaultValue() {
        return "\"".concat(this.getSourceDefaultValue()).concat("\"");
    }
}

