/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rdfs;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.ISO8601DateProperty;
import org.structr.core.property.PropertyKey;
import org.structr.rdfs.Name;
import org.structr.rdfs.OWLClass;
import org.structr.rdfs.OWLParserv2;
import org.structr.rdfs.OWLProperty;
import org.structr.rdfs.RDFDescription;
import org.structr.rdfs.RDFItem;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.json.JsonSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OWLInstance
extends RDFItem<OWLInstance> {
    private static final Map<URI, NodeInterface> instances = new LinkedHashMap<URI, NodeInterface>();
    private final SimpleDateFormat isoFormat = new SimpleDateFormat(ISO8601DateProperty.getDefaultFormat());
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    protected OWLClass type = null;
    protected Class nodeType = null;
    protected PropertyKey originIdKey = null;
    protected NodeInterface instance = null;

    public OWLInstance(Element element) {
        super(element);
    }

    public void setType(OWLClass oWLClass) {
        this.type = oWLClass;
    }

    public OWLClass getType() {
        return this.type;
    }

    public void createDatabaseNode(App app) throws FrameworkException {
        ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
        String string = this.type.getStructrName(true);
        this.nodeType = configurationProvider.getNodeEntityClass(string);
        if (this.nodeType != null) {
            this.originIdKey = configurationProvider.getPropertyKeyForJSONName(this.nodeType, "originId", false);
            if (this.originIdKey != null) {
                this.instance = app.create(this.nodeType, new NodeAttribute[]{new NodeAttribute(this.originIdKey, (Object)this.getId().toString())});
                if (this.instance != null) {
                    instances.put(this.getId(), this.instance);
                }
            } else {
                OWLParserv2.logger.println("NOT creating instance for " + this.getId() + ", no originId property key found.");
            }
        } else {
            OWLParserv2.logger.println("NOT creating instance for " + this.getId() + ", no node type found.");
        }
    }

    public void resolveExtensions(App app, Map<String, OWLClass> map, Map<URI, OWLInstance> map2, List<OWLInstance> list) throws FrameworkException {
        NodeList nodeList = this.getElements(this.getElement(), "krdf:KExtendedByRelation");
        ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
        Class clazz = configurationProvider.getNodeEntityClass("BaseNode");
        PropertyKey propertyKey = configurationProvider.getPropertyKeyForJSONName(clazz, "extendedBy", false);
        if (nodeList != null && propertyKey != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getChildNodes();
                if (nodeList2 == null) continue;
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    OWLClass oWLClass;
                    String string;
                    Element element2;
                    OWLInstance oWLInstance;
                    URI uRI;
                    Node node = nodeList2.item(j);
                    if (!(node instanceof Element) || (uRI = (oWLInstance = new OWLInstance(element2 = (Element)node)).getId()) == null || (string = oWLInstance.getTypeName()) == null || (oWLClass = map.get(string)) == null) continue;
                    oWLInstance.setType(oWLClass);
                    list.add(oWLInstance);
                    oWLInstance.createDatabaseNode(app);
                    if (this.instance == null) continue;
                    HashSet<NodeInterface> hashSet = new HashSet<NodeInterface>((List)this.instance.getProperty(propertyKey));
                    hashSet.add(oWLInstance.instance);
                    this.instance.setProperty(propertyKey, new LinkedList(hashSet));
                }
            }
        }
    }

    public void resolveProperties() throws FrameworkException {
        if (this.instance != null && this.type != null) {
            OWLParserv2.logger.println("#################################################################################################");
            OWLParserv2.logger.println("Resolving properties of " + this.type.getStructrName(true) + ": " + this.getId());
            App app = StructrApp.getInstance();
            ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
            Class clazz = configurationProvider.getNodeEntityClass("BaseNode");
            Class clazz2 = configurationProvider.getNodeEntityClass("LocalizedName");
            PropertyKey propertyKey = configurationProvider.getPropertyKeyForJSONName(clazz, "names");
            PropertyKey propertyKey2 = configurationProvider.getPropertyKeyForJSONName(clazz2, "locale");
            if (clazz2 != null && propertyKey != null) {
                LinkedList linkedList = new LinkedList();
                for (Object object2 : this.names) {
                    linkedList.add(app.create(clazz2, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.name, (Object)((Name)object2).name), new NodeAttribute(propertyKey2, (Object)((Name)object2).lang)}));
                }
                this.instance.setProperty(propertyKey, (Object)linkedList);
            }
            try {
                this.setProperty(this.nodeType, (GraphObject)this.instance, "createdAt", this.isoFormat.format(this.dateFormat.parse(this.createdAt)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.setProperty(this.nodeType, (GraphObject)this.instance, "modifiedAt", this.isoFormat.format(this.dateFormat.parse(this.modifiedAt)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (OWLProperty oWLProperty : this.type.getAllProperties()) {
                Object object;
                Object object2;
                object2 = oWLProperty.getId().getFragment();
                String string = oWLProperty.getFragmentName(false);
                if (oWLProperty.multipleOccurrences()) {
                    object = this.getElements(this.getElement(), (String)object2);
                    int n = object.getLength();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < n; ++i) {
                        String string2 = this.getValue(object.item(i));
                        if (string2 == null) continue;
                        arrayList.add(string2.toString());
                    }
                    String[] stringArray = arrayList.toArray(new String[0]);
                    OWLParserv2.logger.println(string + " = " + stringArray);
                    this.setProperty(this.nodeType, (GraphObject)this.instance, string, stringArray);
                    continue;
                }
                object = this.getValue(this.getFirstElement(this.getElement(), (String)object2));
                OWLParserv2.logger.println(string + " = " + object);
                this.setProperty(this.nodeType, (GraphObject)this.instance, string, oWLProperty.convertValue(object));
            }
        }
    }

    public void resolveRelationships(JsonSchema jsonSchema, Map<String, OWLClass> map, Map<URI, OWLInstance> map2, Map<String, RDFDescription> map3, Map<String, OWLProperty> map4) throws FrameworkException {
        if (this.instance != null && this.type != null) {
            OWLParserv2.logger.println("#################################################################################################");
            OWLParserv2.logger.println("Resolving relationships of " + this.type.getStructrName(true) + ": " + this.getId());
            ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
            NodeList nodeList = this.getElement().getChildNodes();
            if (nodeList != null) {
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element)) continue;
                    Element element = (Element)node;
                    String string = RDFItem.cleanName(element.getTagName());
                    String string2 = this.getAttribute(element, "rdf:resource");
                    if (string2 == null) continue;
                    OWLInstance oWLInstance = map2.get(URI.create(string2));
                    if (oWLInstance != null) {
                        OWLClass oWLClass = map.get(string);
                        if (oWLClass != null) {
                            List<OWLClass> list = oWLClass.getActualSourceTypes();
                            List<OWLClass> list2 = oWLClass.getActualTargetTypes();
                            Class clazz = configurationProvider.getNodeEntityClass(string);
                            if (clazz != null) {
                                if (list.size() == 1 && list2.size() == 1) {
                                    OWLClass oWLClass2 = list.get(0);
                                    OWLClass oWLClass3 = list2.get(0);
                                    String string3 = oWLClass2.getStructrName(false);
                                    String string4 = oWLClass3.getStructrName(false);
                                    PropertyKey propertyKey = configurationProvider.getPropertyKeyForJSONName(clazz, string3, false);
                                    PropertyKey propertyKey2 = configurationProvider.getPropertyKeyForJSONName(clazz, string4, false);
                                    if (propertyKey != null && propertyKey2 != null) {
                                        if (this.instance != null && oWLInstance.instance != null) {
                                            RDFDescription rDFDescription;
                                            NodeInterface nodeInterface = StructrApp.getInstance().create(clazz, new NodeAttribute[]{new NodeAttribute(propertyKey, (Object)this.instance), new NodeAttribute(propertyKey2, (Object)oWLInstance.instance)});
                                            String string5 = this.getAttribute(element, "rdf:ID");
                                            if (string5 == null || nodeInterface == null || (rDFDescription = map3.get(string5)) == null) continue;
                                            rDFDescription.resolveProperties(nodeInterface, map, map4);
                                            continue;
                                        }
                                        System.out.println("!!!!!!!! No instance found to set on " + this.getId());
                                        continue;
                                    }
                                    System.out.println("        No property keys found for " + string3 + ", " + string4);
                                    continue;
                                }
                                System.out.println("        Ambiguous source or target types: " + list + ", " + list2);
                                continue;
                            }
                            System.out.println("        Relationship type " + string + " not found for " + this.getId());
                            continue;
                        }
                        System.out.println("No type found for " + string);
                        continue;
                    }
                    System.out.println("        No instance found for " + string2);
                }
            }
        }
    }

    @Override
    protected Set<String> getInheritanceIdentifiers() {
        return Collections.emptySet();
    }
}

