/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rdfs;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Localization;
import org.structr.core.entity.Relation;
import org.structr.core.entity.SchemaNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rdfs.Name;
import org.structr.rdfs.OWLClass;
import org.structr.rdfs.OWLInstance;
import org.structr.rdfs.OWLProperty;
import org.structr.rdfs.RDFDescription;
import org.structr.rdfs.RDFItem;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.export.StructrSchema;
import org.structr.schema.json.JsonDateProperty;
import org.structr.schema.json.JsonEnumProperty;
import org.structr.schema.json.JsonObjectType;
import org.structr.schema.json.JsonReferenceType;
import org.structr.schema.json.JsonSchema;
import org.structr.schema.json.JsonType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OWLParserv2 {
    private static final Set<String> unwantedPrefixes = new LinkedHashSet<String>();
    public static final Map<String, String> xmlSchemaPropertyMapping = new TreeMap<String, String>();
    public static final Map<String, String> customKTypeMapping = new TreeMap<String, String>();
    public static final Set<String> blacklistedProperties = new LinkedHashSet<String>();
    public static final String XML_SCHEMA_TYPE_URI = "http://www.w3.org/2001/XMLSchema#anyURI";
    public static final String XML_SCHEMA_TYPE_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    public static final String XML_SCHEMA_TYPE_DATE = "http://www.w3.org/2001/XMLSchema#date";
    public static final String XML_SCHEMA_TYPE_DATE_TIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    public static final String XML_SCHEMA_TYPE_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    public static final String XML_SCHEMA_TYPE_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    public static final String XML_SCHEMA_TYPE_STRING = "http://www.w3.org/2001/XMLSchema#string";
    public static PrintWriter logger = null;
    private final Map<String, OWLProperty> owlPropertiesByName = new TreeMap<String, OWLProperty>();
    private final Map<URI, OWLProperty> owlPropertiesByURI = new TreeMap<URI, OWLProperty>();
    private final Map<String, RDFDescription> rdfDescriptions = new TreeMap<String, RDFDescription>();
    private final Map<String, OWLClass> owlClassesByFragment = new TreeMap<String, OWLClass>();
    private final Map<URI, OWLInstance> owlInstances = new TreeMap<URI, OWLInstance>();
    private final Map<URI, OWLClass> owlClassesByURI = new TreeMap<URI, OWLClass>();
    private final boolean importSchema = true;
    private final boolean importData = true;
    private final boolean importFiles = false;
    private final boolean createFileRelationships = false;

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
            System.out.println("Using file " + string + ", data directory " + string2);
        } else {
            System.out.println("Please supply an import file name.");
            System.out.println("Usage: java -jar OWLParser.jar [fileName] [data dir]");
            System.exit(1);
        }
        OWLParserv2 oWLParserv2 = new OWLParserv2();
        oWLParserv2.parse(string, string2);
    }

    public void parse(String string, String string2) {
        boolean bl = true;
        try (App app = StructrApp.getInstance();){
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            Object object5;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(string));
            System.out.println("Parsing XML document..");
            logger.println("Parsing XML document..");
            this.parseDocument(document.getDocumentElement(), 0);
            System.out.println("Filtering unwanted classes..");
            logger.println("Filtering unwanted classes..");
            this.filter(this.owlClassesByURI.values());
            this.filter(this.owlPropertiesByURI.values());
            System.out.println("Resolving " + this.owlClassesByURI.size() + " OWL superclasses..");
            logger.println("Resolving " + this.owlClassesByURI.size() + " OWL superclasses..");
            for (OWLClass rDFItem2 : this.owlClassesByURI.values()) {
                rDFItem2.resolveSuperclasses(this.owlClassesByURI);
            }
            for (OWLClass oWLClass : this.owlClassesByURI.values()) {
                oWLClass.resolveRelatedTypes(this.owlClassesByURI);
            }
            for (OWLClass oWLClass : this.owlClassesByURI.values()) {
                oWLClass.resolveRelationshipTypes(this.owlClassesByURI);
            }
            System.out.println("Resolving " + this.owlPropertiesByURI.size() + " datatype properties..");
            logger.println("Resolving " + this.owlPropertiesByURI.size() + " datatype properties..");
            for (OWLProperty oWLProperty : this.owlPropertiesByURI.values()) {
                oWLProperty.resolveSuperclasses(this.owlPropertiesByURI);
                oWLProperty.resolveClassProperties(this.owlClassesByURI);
            }
            Object object7 = StructrSchema.newInstance((URI)URI.create("http://localhost/test/#"));
            JsonObjectType jsonObjectType = object7.addType("BaseNode");
            Object object6 = object7.addType("LocalizedName");
            object6.addStringProperty("locale", new String[0]).setIndexed(true);
            object6.addStringProperty("name", new String[0]).setIndexed(true);
            jsonObjectType.addStringProperty("originId", new String[0]).setIndexed(true);
            jsonObjectType.addDateProperty("createdAt", new String[0]).setIndexed(true);
            jsonObjectType.addDateProperty("modifiedAt", new String[0]).setIndexed(true);
            jsonObjectType.addFunctionProperty("isFallbackLang", new String[]{"ui"}).setContentType("application/x-structr-script").setReadFunction("(empty(get_or_null(first(filter(this.names, equal(data.locale, substring(locale, 0, 2)))), 'name')))").setIndexed(true);
            jsonObjectType.addFunctionProperty("localizedName", new String[]{"ui"}).setContentType("application/x-structr-script").setReadFunction("(if (equal('zh', substring(locale, 0, 2)),(if (empty(first(filter(this.names, equal(data.locale, 'zh')))),if (empty(first(filter(this.names, equal(data.locale, 'en')))),get_or_null(first(filter(this.names, equal(data.locale, 'de'))), 'name'),get(first(filter(this.names, equal(data.locale, 'en'))), 'name')),get(first(filter(this.names, equal(data.locale, 'zh'))), 'name'))),if (equal('de', substring(locale, 0, 2)),(if (empty(first(filter(this.names, equal(data.locale, 'de')))),if (empty(first(filter(this.names, equal(data.locale, 'en')))),get_or_null(first(filter(this.names, equal(data.locale, 'zh'))), 'name'),get(first(filter(this.names, equal(data.locale, 'en'))), 'name')),get(first(filter(this.names, equal(data.locale, 'de'))), 'name'))),(if (empty(first(filter(this.names, equal(data.locale, 'en')))),if (empty(first(filter(this.names, equal(data.locale, 'de')))),get_or_null(first(filter(this.names, equal(data.locale, 'zh'))), 'name'),get(first(filter(this.names, equal(data.locale, 'de'))), 'name')),get(first(filter(this.names, equal(data.locale, 'en'))), 'name'))))))").setIndexed(true);
            jsonObjectType.addFunctionProperty("nameDE", new String[]{"ui"}).setContentType("application/x-structr-script").setReadFunction("get_or_null(first(filter(this.names, equal(data.locale, 'de'))), 'name')").setWriteFunction("(store('node', first(filter(this.names, equal(data.locale, 'de')))),if (empty(retrieve('node')),set(this, 'names', merge(this.names, create('LocalizedName', 'locale', 'de', 'name', value))),(if (empty(value),delete(retrieve('node')),set(retrieve('node'), 'name', value)))))").setIndexed(true);
            jsonObjectType.addFunctionProperty("nameEN", new String[]{"ui"}).setContentType("application/x-structr-script").setReadFunction("get_or_null(first(filter(this.names, equal(data.locale, 'en'))), 'name')").setWriteFunction("(store('node', first(filter(this.names, equal(data.locale, 'en')))),if (empty(retrieve('node')),set(this, 'names', merge(this.names, create('LocalizedName', 'locale', 'en', 'name', value))),(if (empty(value),delete(retrieve('node')),set(retrieve('node'), 'name', value)))))").setIndexed(true);
            jsonObjectType.addFunctionProperty("nameZH", new String[]{"ui"}).setContentType("application/x-structr-script").setReadFunction("get_or_null(first(filter(this.names, equal(data.locale, 'zh'))), 'name')").setWriteFunction("(store('node', first(filter(this.names, equal(data.locale, 'zh')))),if (empty(retrieve('node')),set(this, 'names', merge(this.names, create('LocalizedName', 'locale', 'zh', 'name', value))),(if (empty(value),delete(retrieve('node')),set(retrieve('node'), 'name', value)))))").setIndexed(true);
            Object object8 = jsonObjectType.relate(object6, "HasName", Relation.Cardinality.OneToMany);
            object8.setSourcePropertyName("isNameOf");
            object8.setTargetPropertyName("names");
            JsonReferenceType jsonReferenceType = jsonObjectType.relate(jsonObjectType, "ExtendedBy", Relation.Cardinality.ManyToMany);
            jsonReferenceType.setSourcePropertyName("extends");
            jsonReferenceType.setTargetPropertyName("extendedBy");
            jsonObjectType.addStringProperty("name", new String[0]).setIndexed(true);
            System.out.println("Creating schema..");
            logger.println("Creating schema..");
            try {
                object5 = StructrApp.getInstance().tx();
                serializable = null;
                try {
                    for (OWLClass oWLClass : this.owlClassesByURI.values()) {
                        object4 = oWLClass.getStructrName(true);
                        if (object4 == null || object7.getType((String)object4) != null || !oWLClass.isPrimary()) continue;
                        logger.println("Creating type " + (String)object4 + "..");
                        object7.addType((String)object4);
                    }
                    StructrSchema.replaceDatabaseSchema((App)app, object7);
                    object5.success();
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object5 != null) {
                        if (serializable != null) {
                            try {
                                object5.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            object5.close();
                        }
                    }
                }
            }
            catch (FrameworkException frameworkException) {
                System.out.println(frameworkException.getErrorBuffer().getErrorTokens());
            }
            System.out.println("Resolving class inheritance..");
            logger.println("Resolving class inheritance..");
            try {
                object5 = StructrApp.getInstance().tx();
                serializable = null;
                try {
                    for (OWLClass oWLClass : this.owlClassesByURI.values()) {
                        object4 = oWLClass.getStructrName(true);
                        object3 = object7.getType((String)object4);
                        object2 = (OWLClass)oWLClass.getSuperclass();
                        if (object3 == null) continue;
                        if (object2 != null) {
                            object = object7.getType(((RDFItem)object2).getStructrName(true));
                            if (object != null) {
                                object3.setExtends((JsonType)object);
                            } else {
                                object3.setExtends((JsonType)jsonObjectType);
                            }
                        } else {
                            object3.setExtends((JsonType)jsonObjectType);
                        }
                        for (Name name : oWLClass.getNames()) {
                            app.create(Localization.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)Localization.name, object4), new NodeAttribute((PropertyKey)Localization.localizedName, (Object)name.name), new NodeAttribute((PropertyKey)Localization.locale, (Object)name.lang)});
                        }
                    }
                    StructrSchema.replaceDatabaseSchema((App)app, object7);
                    object5.success();
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object5 != null) {
                        if (serializable != null) {
                            try {
                                object5.close();
                            }
                            catch (Throwable n) {
                                ((Throwable)serializable).addSuppressed(n);
                            }
                        } else {
                            object5.close();
                        }
                    }
                }
            }
            catch (FrameworkException frameworkException) {
                System.out.println(frameworkException.getErrorBuffer().getErrorTokens());
            }
            System.out.println("Resolving relationship types..");
            logger.println("Resolving relationship types..");
            try {
                object5 = StructrApp.getInstance().tx();
                serializable = null;
                try {
                    for (OWLClass oWLClass : this.owlClassesByURI.values()) {
                        object4 = oWLClass.getInverse();
                        if (!oWLClass.isPrimary() || object4 == null) continue;
                        object3 = oWLClass.getActualSourceTypes();
                        object2 = oWLClass.getActualTargetTypes();
                        object = object3.iterator();
                        while (object.hasNext()) {
                            OWLClass oWLClass2 = (OWLClass)object.next();
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                OWLClass oWLClass3 = (OWLClass)iterator.next();
                                String string3 = oWLClass.getStructrName(false);
                                String string4 = ((RDFItem)object4).getStructrName(false);
                                String string5 = oWLClass2.getStructrName(true);
                                String string6 = oWLClass3.getStructrName(true);
                                JsonType jsonType = object7.getType(string5);
                                JsonType jsonType2 = object7.getType(string6);
                                if (jsonType == null || jsonType2 == null) continue;
                                String string7 = oWLClass.getStructrName(true);
                                JsonObjectType jsonObjectType2 = object7.addType(string7);
                                JsonObjectType jsonObjectType3 = (JsonObjectType)jsonType;
                                JsonObjectType jsonObjectType4 = (JsonObjectType)jsonType2;
                                jsonObjectType3.relate(jsonObjectType2, string3, Relation.Cardinality.OneToMany, oWLClass2.getStructrName(false), string3);
                                jsonObjectType2.relate(jsonObjectType4, string4, Relation.Cardinality.ManyToOne, string4, oWLClass3.getStructrName(false));
                                oWLClass.setIsRelationship(true);
                            }
                        }
                    }
                    StructrSchema.replaceDatabaseSchema((App)app, object7);
                    object5.success();
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object5 != null) {
                        if (serializable != null) {
                            try {
                                object5.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            object5.close();
                        }
                    }
                }
            }
            catch (FrameworkException frameworkException) {
                System.out.println(frameworkException.getErrorBuffer().getErrorTokens());
            }
            System.out.println("Adding properties to types");
            logger.println("Adding properties to types");
            object5 = StructrApp.getInstance().tx();
            serializable = null;
            try {
                for (OWLClass oWLClass : this.owlClassesByURI.values()) {
                    object4 = oWLClass.getStructrName(true);
                    object3 = object7.getType((String)object4);
                    if (object3 == null && (object2 = oWLClass.getInverse()) != null) {
                        object3 = object7.getType(((RDFItem)object2).getStructrName(true));
                    }
                    if (object3 != null) {
                        object2 = oWLClass.getAllProperties().iterator();
                        while (object2.hasNext()) {
                            object = object2.next();
                            this.addProperty((JsonType)object3, (OWLProperty)object, ((RDFItem)object).getStructrName(false));
                        }
                        continue;
                    }
                    System.out.println("Class: no type found for " + oWLClass.getId());
                }
                StructrSchema.replaceDatabaseSchema((App)app, object7);
                object5.success();
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object5 != null) {
                    if (serializable != null) {
                        try {
                            object5.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        object5.close();
                    }
                }
            }
            System.out.println("Adding metdata to node types");
            logger.println("Adding metdata to node types");
            try {
                object5 = StructrApp.getInstance().tx();
                serializable = null;
                try {
                    for (OWLClass oWLClass : this.owlClassesByURI.values()) {
                        int n;
                        object4 = oWLClass.getStructrName(true);
                        object3 = (SchemaNode)app.nodeQuery(SchemaNode.class).andName((String)object4).getFirst();
                        object2 = oWLClass.getIcon();
                        if (object3 == null) continue;
                        if (object2 != null && ((String)object2).contains("-") && (n = ((String)object2).indexOf("-", 7)) > -1) {
                            object2 = ((String)object2).substring(n + 1);
                        }
                        object3.setProperty((PropertyKey)SchemaNode.icon, object2);
                    }
                    object5.success();
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object5 != null) {
                        if (serializable != null) {
                            try {
                                object5.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            object5.close();
                        }
                    }
                }
            }
            catch (FrameworkException frameworkException) {
                System.out.println(frameworkException.getErrorBuffer().getErrorTokens());
            }
            System.out.println("Resolving instances..");
            logger.println("Resolving instances..");
            object5 = this.owlInstances.values().iterator();
            serializable = new LinkedList();
            int n = 0;
            while (object5.hasNext()) {
                Tx tx = StructrApp.getInstance().tx();
                object4 = null;
                try {
                    while (object5.hasNext()) {
                        object3 = (OWLInstance)object5.next();
                        object2 = ((OWLInstance)object3).getType();
                        if (object2 != null) {
                            ((OWLInstance)object3).createDatabaseNode(app);
                            ((OWLInstance)object3).resolveProperties();
                            ((OWLInstance)object3).resolveExtensions(app, this.owlClassesByFragment, this.owlInstances, (List<OWLInstance>)((Object)serializable));
                        }
                        if (++n != 100) continue;
                        n = 0;
                        break;
                    }
                    tx.success();
                }
                catch (Throwable throwable) {
                    object4 = throwable;
                    throw throwable;
                }
                finally {
                    if (tx == null) continue;
                    if (object4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                object4 = (OWLInstance)iterator.next();
                this.owlInstances.put(((RDFItem)object4).getId(), (OWLInstance)object4);
            }
            System.out.println("Resolving instance relationships..");
            logger.println("Resolving instance relationships..");
            Iterator<OWLInstance> iterator2 = this.owlInstances.values().iterator();
            n = 0;
            while (iterator2.hasNext()) {
                object4 = StructrApp.getInstance().tx();
                object3 = null;
                try {
                    while (iterator2.hasNext()) {
                        object2 = iterator2.next();
                        OWLClass oWLClass = ((OWLInstance)object2).getType();
                        if (oWLClass != null) {
                            ((OWLInstance)object2).resolveRelationships((JsonSchema)object7, this.owlClassesByFragment, this.owlInstances, this.rdfDescriptions, this.owlPropertiesByName);
                        }
                        if (++n != 100) continue;
                        n = 0;
                        break;
                    }
                    object4.success();
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object4 == null) continue;
                    if (object3 != null) {
                        try {
                            object4.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                        continue;
                    }
                    object4.close();
                }
            }
            object7 = new File(string2);
            if (((File)object7).exists()) {
                ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
                object6 = this.createPropertyKeyMapping(configurationProvider);
                object8 = new LinkedHashSet();
                boolean bl2 = false;
                Files.walkFileTree(((File)object7).toPath(), new Visitor((Set<Path>)object8));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = false;
        }
        if (bl) {
            System.out.println("Import successful");
            logger.println("Import successful");
        }
        logger.flush();
        logger.close();
    }

    private void addProperty(JsonType jsonType, OWLProperty oWLProperty, String string) throws URISyntaxException, FrameworkException {
        String string2;
        String string3 = oWLProperty.getId().toString();
        if (blacklistedProperties.contains(string3)) {
            System.out.println("DatatypeProperty " + oWLProperty.getId().toString() + " is blacklisted, igoring!");
            logger.println("DatatypeProperty " + oWLProperty.getId().toString() + " is blacklisted, igoring!");
            return;
        }
        String string4 = oWLProperty.getStructrType();
        if (string4 != null && (string2 = oWLProperty.getStructrName(false)) != null) {
            switch (string4) {
                case "String": {
                    if (oWLProperty.multipleOccurrences()) {
                        jsonType.addStringArrayProperty(string2, new String[0]);
                        break;
                    }
                    jsonType.addStringProperty(string2, new String[0]).setIndexed(true);
                    break;
                }
                case "Boolean": {
                    jsonType.addBooleanProperty(string2, new String[0]).setIndexed(true);
                    break;
                }
                case "Integer": {
                    jsonType.addIntegerProperty(string2, new String[0]).setIndexed(true);
                    break;
                }
                case "Double": {
                    jsonType.addNumberProperty(string2, new String[0]).setIndexed(true);
                    break;
                }
                case "Date": {
                    JsonDateProperty jsonDateProperty = jsonType.addDateProperty(string2, new String[0]);
                    String string5 = oWLProperty.getAdditionalFormat();
                    if (string5 != null) {
                        jsonDateProperty.setDatePattern(string5);
                    }
                    jsonDateProperty.setIndexed(true);
                    break;
                }
                case "Enum": {
                    if (oWLProperty.multipleOccurrences()) {
                        jsonType.addStringArrayProperty(string2, new String[0]);
                        break;
                    }
                    JsonEnumProperty jsonEnumProperty = jsonType.addEnumProperty(string2, new String[0]);
                    jsonEnumProperty.setEnums(oWLProperty.getEnums(string));
                    jsonEnumProperty.setIndexed(true);
                    break;
                }
            }
        }
    }

    private void parseDocument(Element element, int n) {
        String string = element.getTagName();
        switch (string) {
            case "owl:Class": 
            case "owl:ObjectProperty": {
                OWLClass oWLClass = new OWLClass(element);
                this.owlClassesByURI.put(oWLClass.getId(), oWLClass);
                String string2 = oWLClass.getFragmentName(true);
                if (string2 != null) {
                    this.owlClassesByFragment.put(string2, oWLClass);
                }
                return;
            }
            case "rdf:Property": {
                break;
            }
            case "rdf:Description": {
                RDFDescription rDFDescription = new RDFDescription(element);
                this.rdfDescriptions.put(rDFDescription.getReferenceId(), rDFDescription);
                return;
            }
            case "owl:DatatypeProperty": {
                OWLProperty oWLProperty = new OWLProperty(element);
                this.owlPropertiesByURI.put(oWLProperty.getId(), oWLProperty);
                String string3 = oWLProperty.getRawFragmentName();
                if (string3 != null) {
                    this.owlPropertiesByName.put(string3, oWLProperty);
                }
                return;
            }
            default: {
                OWLClass oWLClass;
                OWLInstance oWLInstance = new OWLInstance(element);
                URI uRI = oWLInstance.getId();
                if (uRI == null) break;
                String string4 = oWLInstance.getTypeName();
                if (string4 != null && (oWLClass = this.owlClassesByFragment.get(string4)) != null) {
                    oWLInstance.setType(oWLClass);
                }
                this.owlInstances.put(oWLInstance.getId(), oWLInstance);
            }
        }
        if (n >= 1) {
            return;
        }
        for (Object object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (!(object instanceof Element)) continue;
            this.parseDocument((Element)object, n + 1);
        }
    }

    private <T extends RDFItem> void filter(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDFItem rDFItem = (RDFItem)iterator.next();
            URI uRI = rDFItem.getId();
            String string = uRI.toString();
            String string2 = uRI.getFragment();
            for (String string3 : unwantedPrefixes) {
                if (!string.startsWith(string3) && !string2.startsWith(string3)) continue;
                iterator.remove();
            }
        }
    }

    private List<Tuple<Class, PropertyKey>> createPropertyKeyMapping(ConfigurationProvider configurationProvider) {
        String[][] stringArrayArray;
        LinkedList<Tuple<Class, PropertyKey>> linkedList = new LinkedList<Tuple<Class, PropertyKey>>();
        for (String[] stringArray : stringArrayArray = new String[][]{{"UploadedDocument", "dok"}, {"Pruefung", "pruefbericht"}, {"Pruefauftrag", "pruefbericht"}, {"Article", "bild"}, {"ProductVersion", "bild"}, {"Pers", "bild"}, {"Product", "bildKlein"}, {"Component", "bildKlein"}, {"Product", "bildGross"}, {"Component", "bos"}, {"ProductVersion", "erpLink"}, {"FckFile", "fckBlob"}, {"UserAccount", "nnState"}, {"Regulation", "anhang"}, {"HistoryVersions", "dokumentDateiVersion"}}) {
            PropertyKey propertyKey;
            String string = stringArray[0];
            String string2 = stringArray[1];
            Class clazz = configurationProvider.getNodeEntityClass(string);
            if (clazz == null || (propertyKey = configurationProvider.getPropertyKeyForJSONName(clazz, string2, false)) == null) continue;
            linkedList.add(new Tuple<Class, PropertyKey>(clazz, propertyKey));
        }
        return linkedList;
    }

    static {
        unwantedPrefixes.add("http://www.intelligent-views.de");
        unwantedPrefixes.add("box");
        unwantedPrefixes.add("Box");
        unwantedPrefixes.add("collect");
        unwantedPrefixes.add("context");
        unwantedPrefixes.add("eventLog");
        unwantedPrefixes.add("expertSearch");
        unwantedPrefixes.add("History");
        unwantedPrefixes.add("icons");
        unwantedPrefixes.add("intern");
        unwantedPrefixes.add("kp");
        unwantedPrefixes.add("kScript");
        unwantedPrefixes.add("kservice");
        unwantedPrefixes.add("onlineHelp");
        unwantedPrefixes.add("print");
        unwantedPrefixes.add("quick");
        unwantedPrefixes.add("render");
        unwantedPrefixes.add("rest");
        unwantedPrefixes.add("P-inverse");
        unwantedPrefixes.add("PfadSuche");
        unwantedPrefixes.add("viewConfig");
        unwantedPrefixes.add("viewconfig");
        unwantedPrefixes.add("welcome");
        xmlSchemaPropertyMapping.put(XML_SCHEMA_TYPE_URI, "String");
        xmlSchemaPropertyMapping.put(XML_SCHEMA_TYPE_BOOLEAN, "Boolean");
        xmlSchemaPropertyMapping.put(XML_SCHEMA_TYPE_DATE, "Date");
        xmlSchemaPropertyMapping.put(XML_SCHEMA_TYPE_DATE_TIME, "Date");
        xmlSchemaPropertyMapping.put(XML_SCHEMA_TYPE_DOUBLE, "Double");
        xmlSchemaPropertyMapping.put(XML_SCHEMA_TYPE_INTEGER, "Integer");
        xmlSchemaPropertyMapping.put(XML_SCHEMA_TYPE_STRING, "String");
        customKTypeMapping.put("KAttribute", XML_SCHEMA_TYPE_STRING);
        customKTypeMapping.put("KBoolean", XML_SCHEMA_TYPE_BOOLEAN);
        customKTypeMapping.put("KBlob", XML_SCHEMA_TYPE_STRING);
        customKTypeMapping.put("KColorValue", XML_SCHEMA_TYPE_STRING);
        customKTypeMapping.put("KContainerAttribute", XML_SCHEMA_TYPE_STRING);
        customKTypeMapping.put("KDate", XML_SCHEMA_TYPE_DATE);
        customKTypeMapping.put("KDateAndTime", XML_SCHEMA_TYPE_DATE_TIME);
        customKTypeMapping.put("KDocumentAttribute", XML_SCHEMA_TYPE_STRING);
        customKTypeMapping.put("KFlexTime", XML_SCHEMA_TYPE_STRING);
        customKTypeMapping.put("KFloat", XML_SCHEMA_TYPE_DOUBLE);
        customKTypeMapping.put("KInteger", XML_SCHEMA_TYPE_INTEGER);
        customKTypeMapping.put("KInterval", XML_SCHEMA_TYPE_STRING);
        customKTypeMapping.put("KStringAttribute", XML_SCHEMA_TYPE_STRING);
        customKTypeMapping.put("KURLAttribute", XML_SCHEMA_TYPE_URI);
    }

    private static class Tuple<K, V> {
        private K key = null;
        private V value = null;

        public Tuple(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    private static class Visitor
    implements FileVisitor<Path> {
        private Set<Path> files = null;

        public Visitor(Set<Path> set) {
            this.files = set;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            this.files.add(path);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

