/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rdfs;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.structr.common.CaseHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.rdfs.Name;
import org.structr.rdfs.OWLParserv2;
import org.structr.schema.ConfigurationProvider;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RDFItem<T extends RDFItem>
implements Comparable<RDFItem> {
    protected final List<Name> names = new LinkedList<Name>();
    private final Set<T> subclasses = new TreeSet<T>();
    protected String createdAt = null;
    protected String modifiedAt = null;
    protected String rdfReferenceId = null;
    private Element element = null;
    private T superclass = null;
    private URI superclassId = null;
    private URI id = null;
    private String internalName = null;
    private String type = null;

    protected abstract Set<String> getInheritanceIdentifiers();

    public RDFItem(Element element) {
        if (element != null) {
            this.type = element.getTagName();
            this.element = element;
            this.initialize(element);
        }
    }

    public String toString() {
        return this.getTypeName() + ", " + this.id + " extends " + this.superclassId;
    }

    public List<Name> getNames() {
        return this.names;
    }

    public final String getTypeName() {
        return CaseHelper.toUpperCamelCase((String)RDFItem.cleanName(this.type));
    }

    public final String getStructrName(boolean bl) {
        return this.getFragmentName(bl);
    }

    public String getRawFragmentName() {
        if (this.id != null) {
            return this.id.getFragment();
        }
        return null;
    }

    public String getFragmentName(boolean bl) {
        String string;
        if (this.id != null && StringUtils.isNotBlank((String)(string = this.id.getFragment()))) {
            if (bl) {
                return CaseHelper.toUpperCamelCase((String)RDFItem.cleanName(string));
            }
            return CaseHelper.toLowerCamelCase((String)RDFItem.cleanName(string));
        }
        return this.internalName;
    }

    public final URI getSuperclassId() {
        return this.superclassId;
    }

    public final URI getId() {
        return this.id;
    }

    public final void setId(String string) {
        if (string != null) {
            try {
                this.setId(URI.create(string));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public final void setId(URI uRI) {
        this.id = uRI;
    }

    public void resolveSuperclasses(Map<URI, T> map) {
        RDFItem rDFItem;
        URI uRI = this.getSuperclassId();
        if (uRI != null && (rDFItem = (RDFItem)map.get(uRI)) != null) {
            this.addSuperclass(rDFItem);
        }
    }

    public void addSuperclass(T t) {
        ((RDFItem)t).getSubclasses().add(this);
        this.superclass = t;
    }

    public T getSuperclass() {
        return this.superclass;
    }

    public Set<T> getSubclasses() {
        return this.subclasses;
    }

    public T getRoot() {
        if (this.superclass != null) {
            return ((RDFItem)this.superclass).getRoot();
        }
        return (T)this;
    }

    public Set<T> getTypeAndSuperclasses() {
        LinkedHashSet<RDFItem<T>> linkedHashSet = new LinkedHashSet<RDFItem<T>>();
        linkedHashSet.add(this);
        if (this.getSuperclass() != null) {
            linkedHashSet.addAll(((RDFItem)this.superclass).getTypeAndSuperclasses());
        }
        return linkedHashSet;
    }

    @Override
    public int compareTo(RDFItem rDFItem) {
        if (this.id != null && rDFItem != null && rDFItem.id != null) {
            return this.id.compareTo(rDFItem.id);
        }
        return -1;
    }

    protected final Element getElement() {
        return this.element;
    }

    protected final String getResourceId(Node node) {
        return this.getAttribute(node, "rdf:resource");
    }

    protected final String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    protected final String getValue(Node node) {
        Node node2;
        if (node != null && (node2 = node.getFirstChild()) != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    protected Element getFirstElement(Element element, String string) {
        return (Element)element.getElementsByTagName(string).item(0);
    }

    protected NodeList getElements(Element element, String string) {
        return element.getElementsByTagName(string);
    }

    protected Set<String> getResourceIds(String string) {
        NodeList nodeList = this.element.getElementsByTagName(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                String string2 = this.getResourceId(node);
                if (string2 == null) continue;
                treeSet.add(string2);
            }
        }
        return treeSet;
    }

    protected Object setProperty(Class clazz, GraphObject graphObject, String string, Object object) throws FrameworkException {
        ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
        Object object2 = object;
        if (object2 != null) {
            PropertyKey propertyKey = configurationProvider.getPropertyKeyForJSONName(clazz, string, false);
            if (propertyKey != null) {
                PropertyConverter propertyConverter = propertyKey.inputConverter(SecurityContext.getSuperUserInstance());
                if (propertyConverter != null) {
                    object2 = propertyConverter.convert(object2);
                }
                if (object2 == null) {
                    OWLParserv2.logger.println("Invalid converted value " + object2 + ", source was " + object);
                }
                return graphObject.setProperty(propertyKey, object2);
            }
            System.out.println("Key " + string + " not found on " + clazz.getSimpleName());
        }
        return null;
    }

    private void initialize(Element element) {
        String string = this.getAttribute(element, "rdf:about");
        if (string != null) {
            this.setId(string);
        }
        this.initializeRDFSLabels(element.getElementsByTagName("rdfs:label"));
        this.internalName = this.getValue(this.getFirstElement(this.getElement(), "krdf:internalName"));
        for (String string2 : this.getInheritanceIdentifiers()) {
            this.initializeSuperclass(element.getElementsByTagName(string2));
            if (this.superclassId == null) continue;
            break;
        }
        this.createdAt = this.getValue(this.getFirstElement(this.getElement(), "createdAt"));
        this.modifiedAt = this.getValue(this.getFirstElement(this.getElement(), "modifiedAt"));
        this.rdfReferenceId = this.getAttribute(this.getElement(), "rdf:ID");
    }

    private void initializeSuperclass(NodeList nodeList) {
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string = this.getResourceId(nodeList.item(i));
                if (string == null) continue;
                this.superclassId = URI.create(string);
            }
        }
    }

    private void initializeRDFSLabels(NodeList nodeList) {
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                String string = this.getValue(node);
                String string2 = this.getAttribute(node, "xml:lang");
                if (string2 == null) {
                    string2 = "de";
                }
                if (string2 == null || string == null) continue;
                this.names.add(new Name(string2, string));
            }
        }
    }

    public static String cleanName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("[ ,\\.\\-\\+\\?\\*\\\"\\'\\=\\(\\)\\[\\]<>]+");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i].trim();
            if (!StringUtils.isNotBlank((String)string2)) continue;
            string2 = string2.replace("\u00e4", "ae");
            string2 = string2.replace("\u00f6", "oe");
            string2 = string2.replace("\u00fc", "ue");
            string2 = string2.replace("\u00c4", "Ae");
            string2 = string2.replace("\u00d6", "Oe");
            string2 = string2.replace("\u00dc", "Ue");
            string2 = string2.replace("\u00df", "ss");
            stringBuilder.append(StringUtils.capitalize((String)string2));
        }
        return stringBuilder.toString().replaceAll("[\\W]+", "");
    }
}

