/*
 * Decompiled with CFR 0.152.
 */
package urn.ebay.apis.eBLBaseComponents;

import com.paypal.core.SDKUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import urn.ebay.apis.EnhancedDataTypes.EnhancedPayerInfoType;
import urn.ebay.apis.eBLBaseComponents.AddressType;
import urn.ebay.apis.eBLBaseComponents.CountryCodeType;
import urn.ebay.apis.eBLBaseComponents.PayPalUserStatusCodeType;
import urn.ebay.apis.eBLBaseComponents.PersonNameType;
import urn.ebay.apis.eBLBaseComponents.TaxIdDetailsType;
import urn.ebay.apis.eBLBaseComponents.WalletItemsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayerInfoType {
    private static final String nameSpace = "urn:ebay:apis:eBLBaseComponents";
    private static final String preferredPrefix = "ebl";
    private String payer;
    private String payerID;
    private PayPalUserStatusCodeType payerStatus;
    private PersonNameType payerName;
    private CountryCodeType payerCountry;
    private String payerBusiness;
    private AddressType address;
    private String contactPhone;
    private List<WalletItemsType> walletItems = new ArrayList<WalletItemsType>();
    private TaxIdDetailsType taxIdDetails;
    private EnhancedPayerInfoType enhancedPayerInfo;

    public PayerInfoType() {
    }

    public String getPayer() {
        return this.payer;
    }

    public void setPayer(String payer) {
        this.payer = payer;
    }

    public String getPayerID() {
        return this.payerID;
    }

    public void setPayerID(String payerID) {
        this.payerID = payerID;
    }

    public PayPalUserStatusCodeType getPayerStatus() {
        return this.payerStatus;
    }

    public void setPayerStatus(PayPalUserStatusCodeType payerStatus) {
        this.payerStatus = payerStatus;
    }

    public PersonNameType getPayerName() {
        return this.payerName;
    }

    public void setPayerName(PersonNameType payerName) {
        this.payerName = payerName;
    }

    public CountryCodeType getPayerCountry() {
        return this.payerCountry;
    }

    public void setPayerCountry(CountryCodeType payerCountry) {
        this.payerCountry = payerCountry;
    }

    public String getPayerBusiness() {
        return this.payerBusiness;
    }

    public void setPayerBusiness(String payerBusiness) {
        this.payerBusiness = payerBusiness;
    }

    public AddressType getAddress() {
        return this.address;
    }

    public void setAddress(AddressType address) {
        this.address = address;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public List<WalletItemsType> getWalletItems() {
        return this.walletItems;
    }

    public void setWalletItems(List<WalletItemsType> walletItems) {
        this.walletItems = walletItems;
    }

    public TaxIdDetailsType getTaxIdDetails() {
        return this.taxIdDetails;
    }

    public void setTaxIdDetails(TaxIdDetailsType taxIdDetails) {
        this.taxIdDetails = taxIdDetails;
    }

    public EnhancedPayerInfoType getEnhancedPayerInfo() {
        return this.enhancedPayerInfo;
    }

    public void setEnhancedPayerInfo(EnhancedPayerInfoType enhancedPayerInfo) {
        this.enhancedPayerInfo = enhancedPayerInfo;
    }

    public String toXMLString(String prefix, String name) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            if (prefix != null) {
                sb.append("<").append(prefix).append(":").append(name).append(">");
            } else {
                sb.append("<").append(preferredPrefix).append(":").append(name).append(">");
            }
        }
        if (this.payer != null) {
            sb.append("<").append(preferredPrefix).append(":Payer>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.payer));
            sb.append("</").append(preferredPrefix).append(":Payer>");
        }
        if (this.payerID != null) {
            sb.append("<").append(preferredPrefix).append(":PayerID>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.payerID));
            sb.append("</").append(preferredPrefix).append(":PayerID>");
        }
        if (this.payerStatus != null) {
            sb.append("<").append(preferredPrefix).append(":PayerStatus>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.payerStatus.getValue()));
            sb.append("</").append(preferredPrefix).append(":PayerStatus>");
        }
        if (this.payerName != null) {
            sb.append(this.payerName.toXMLString(preferredPrefix, "PayerName"));
        }
        if (this.payerCountry != null) {
            sb.append("<").append(preferredPrefix).append(":PayerCountry>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.payerCountry.getValue()));
            sb.append("</").append(preferredPrefix).append(":PayerCountry>");
        }
        if (this.payerBusiness != null) {
            sb.append("<").append(preferredPrefix).append(":PayerBusiness>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.payerBusiness));
            sb.append("</").append(preferredPrefix).append(":PayerBusiness>");
        }
        if (this.address != null) {
            sb.append(this.address.toXMLString(preferredPrefix, "Address"));
        }
        if (this.contactPhone != null) {
            sb.append("<").append(preferredPrefix).append(":ContactPhone>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.contactPhone));
            sb.append("</").append(preferredPrefix).append(":ContactPhone>");
        }
        if (this.walletItems != null) {
            for (int i = 0; i < this.walletItems.size(); ++i) {
                sb.append(this.walletItems.get(i).toXMLString(preferredPrefix, "WalletItems"));
            }
        }
        if (this.taxIdDetails != null) {
            sb.append(this.taxIdDetails.toXMLString(preferredPrefix, "TaxIdDetails"));
        }
        if (this.enhancedPayerInfo != null) {
            sb.append(this.enhancedPayerInfo.toXMLString(preferredPrefix, "EnhancedPayerInfo"));
        }
        if (name != null) {
            if (prefix != null) {
                sb.append("</").append(prefix).append(":").append(name).append(">");
            } else {
                sb.append("</").append(preferredPrefix).append(":").append(name).append(">");
            }
        }
        return sb.toString();
    }

    private boolean isWhitespaceNode(Node n) {
        if (n.getNodeType() == 3) {
            String val = n.getNodeValue();
            return val.trim().length() == 0;
        }
        if (n.getNodeType() == 1) {
            return n.getChildNodes().getLength() == 0;
        }
        return false;
    }

    public PayerInfoType(Node node) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Node childNode = null;
        NodeList nodeList = null;
        childNode = (Node)xpath.evaluate("Payer", node, XPathConstants.NODE);
        if (childNode != null && !this.isWhitespaceNode(childNode)) {
            this.payer = childNode.getTextContent();
        }
        if ((childNode = (Node)xpath.evaluate("PayerID", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.payerID = childNode.getTextContent();
        }
        if ((childNode = (Node)xpath.evaluate("PayerStatus", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.payerStatus = PayPalUserStatusCodeType.fromValue(childNode.getTextContent());
        }
        if ((childNode = (Node)xpath.evaluate("PayerName", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.payerName = new PersonNameType(childNode);
        }
        if ((childNode = (Node)xpath.evaluate("PayerCountry", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.payerCountry = CountryCodeType.fromValue(childNode.getTextContent());
        }
        if ((childNode = (Node)xpath.evaluate("PayerBusiness", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.payerBusiness = childNode.getTextContent();
        }
        if ((childNode = (Node)xpath.evaluate("Address", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.address = new AddressType(childNode);
        }
        if ((childNode = (Node)xpath.evaluate("ContactPhone", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.contactPhone = childNode.getTextContent();
        }
        if ((nodeList = (NodeList)xpath.evaluate("WalletItems", node, XPathConstants.NODESET)) != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node subNode = nodeList.item(i);
                this.walletItems.add(new WalletItemsType(subNode));
            }
        }
        if ((childNode = (Node)xpath.evaluate("TaxIdDetails", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.taxIdDetails = new TaxIdDetailsType(childNode);
        }
        if ((childNode = (Node)xpath.evaluate("EnhancedPayerInfo", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.enhancedPayerInfo = new EnhancedPayerInfoType(childNode);
        }
    }
}

