/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.function.ThrowingPredicate;
import org.neo4j.function.ThrowingSupplier;

public final class Suppliers {
    public static <T> Supplier<T> singleton(T instance) {
        return () -> instance;
    }

    public static <T> Supplier<T> lazySingleton(final Supplier<T> supplier) {
        return new Supplier<T>(){
            volatile T instance = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.instance != null) {
                    return this.instance;
                }
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.instance == null) {
                        this.instance = supplier.get();
                    }
                }
                return this.instance;
            }
        };
    }

    public static <T, V> Supplier<T> adapted(final Supplier<V> supplier, final Function<V, T> adaptor) {
        return new Supplier<T>(){
            volatile V lastValue = null;
            T instance = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                Object value = supplier.get();
                if (value == this.lastValue) {
                    return this.instance;
                }
                Object adaptedValue = adaptor.apply(value);
                2 var3_3 = this;
                synchronized (var3_3) {
                    if (value != this.lastValue) {
                        this.instance = adaptedValue;
                        this.lastValue = value;
                    }
                }
                return this.instance;
            }
        };
    }

    public static <T, E extends Exception> ThrowingCapturingSupplier<T, E> compose(ThrowingSupplier<T, ? extends E> input, ThrowingPredicate<T, ? extends E> predicate) {
        return new ThrowingCapturingSupplier<T, E>(input, predicate);
    }

    public static BooleanSupplier untilTimeExpired(long duration, TimeUnit unit) {
        long endTimeInMilliseconds = System.currentTimeMillis() + unit.toMillis(duration);
        return () -> System.currentTimeMillis() <= endTimeInMilliseconds;
    }

    static class ThrowingCapturingSupplier<T, E extends Exception>
    implements ThrowingSupplier<Boolean, E> {
        private final ThrowingSupplier<T, ? extends E> input;
        private final ThrowingPredicate<T, ? extends E> predicate;
        private T current;

        ThrowingCapturingSupplier(ThrowingSupplier<T, ? extends E> input, ThrowingPredicate<T, ? extends E> predicate) {
            this.input = input;
            this.predicate = predicate;
        }

        T lastInput() {
            return this.current;
        }

        @Override
        public Boolean get() throws E {
            this.current = this.input.get();
            return this.predicate.test(this.current);
        }

        public String toString() {
            return String.format("%s on %s", this.predicate, this.input);
        }
    }
}

