/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Serialize;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ava
implements Externalizable,
Cloneable,
Comparable<Ava> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Ava.class);
    private String normType;
    private String upType;
    private Value<?> value;
    private String upName;
    private AttributeType attributeType;
    private SchemaManager schemaManager;
    private volatile int h;

    public Ava() {
        this(null);
    }

    public Ava(SchemaManager schemaManager) {
        this.normType = null;
        this.upType = null;
        this.value = null;
        this.upName = "";
        this.schemaManager = schemaManager;
        this.attributeType = null;
    }

    public Ava(String upType, byte[] upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Ava(SchemaManager schemaManager, String upType, byte[] upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new BinaryValue(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new BinaryValue(upValue));
    }

    public Ava(String upType, String upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Ava(SchemaManager schemaManager, String upType, String upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new StringValue(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new StringValue(upValue));
    }

    private void createAva(SchemaManager schemaManager, String upType, Value<?> value) throws LdapInvalidDnException {
        this.normType = this.attributeType.getOid();
        this.upType = upType;
        this.value = value;
        this.upName = this.upType + '=' + (value == null ? "" : Rdn.escapeValue(value.getString()));
        this.hashCode();
    }

    private void createAva(String upType, Value<?> upValue) throws LdapInvalidDnException {
        String upTypeTrimmed = Strings.trim((String)upType);
        String normTypeTrimmed = Strings.trim((String)this.normType);
        if (Strings.isEmpty((String)upTypeTrimmed)) {
            if (Strings.isEmpty((String)normTypeTrimmed)) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.upType = this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
        } else if (Strings.isEmpty((String)normTypeTrimmed)) {
            this.normType = Strings.lowerCaseAscii((String)upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = upType;
        }
        this.value = upValue;
        this.upName = this.upType + '=' + (this.value == null ? "" : Rdn.escapeValue(this.value.getString()));
        this.hashCode();
    }

    Ava(SchemaManager schemaManager, String upType, String normType, Value<?> value) throws LdapInvalidDnException {
        this.upType = upType;
        this.normType = normType;
        this.value = value;
        this.upName = this.upType + '=' + (this.value == null ? "" : this.value.getString());
        if (schemaManager != null) {
            this.apply(schemaManager);
        }
        this.hashCode();
    }

    Ava(String upType, String normType, Value<?> value, String upName) throws LdapInvalidDnException {
        this(null, upType, normType, value, upName);
    }

    Ava(AttributeType attributeType, String upType, String normType, Value<?> value, String upName) throws LdapInvalidDnException {
        this.attributeType = attributeType;
        String upTypeTrimmed = Strings.trim((String)upType);
        String normTypeTrimmed = Strings.trim((String)normType);
        if (Strings.isEmpty((String)upTypeTrimmed)) {
            if (Strings.isEmpty((String)normTypeTrimmed)) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = normType;
        } else if (Strings.isEmpty((String)normTypeTrimmed)) {
            this.normType = Strings.lowerCaseAscii((String)upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = upType;
        }
        this.value = value;
        this.upName = upName;
        this.hashCode();
    }

    public void apply(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            AttributeType tmpAttributeType = null;
            try {
                tmpAttributeType = schemaManager.lookupAttributeTypeRegistry(this.normType);
            }
            catch (LdapException le) {
                if (schemaManager.isRelaxed()) {
                    return;
                }
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            if (this.attributeType == tmpAttributeType) {
                return;
            }
            this.attributeType = tmpAttributeType;
            this.normType = tmpAttributeType.getOid();
            try {
                this.value.apply(tmpAttributeType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            this.hashCode();
        }
    }

    public String getNormType() {
        return this.normType;
    }

    public String getType() {
        return this.upType;
    }

    public Value<?> getValue() {
        return this.value.clone();
    }

    public String getNormName() {
        return this.normalize();
    }

    public String getName() {
        return this.upName;
    }

    public Ava clone() {
        try {
            Ava clone = (Ava)super.clone();
            clone.value = this.value.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure", cnse);
        }
    }

    public String normalize() {
        if (this.value.isHumanReadable()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.normType).append('=');
            String normalizedValue = (String)this.value.getNormValue();
            if (normalizedValue != null && normalizedValue.length() > 0) {
                sb.append(Rdn.escapeValue(normalizedValue));
            }
            return sb.toString();
        }
        return this.normType + "=#" + Strings.dumpHexPairs((byte[])this.value.getBytes());
    }

    public int hashCode() {
        if (this.h == 0) {
            this.h = 37;
            this.h = this.h * 17 + (this.normType != null ? this.normType.hashCode() : 0);
            this.h = this.h * 17 + (this.value != null ? this.value.hashCode() : 0);
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ava)) {
            return false;
        }
        Ava instance = (Ava)obj;
        if (this.normType == null ? instance.normType != null : !this.normType.equals(instance.normType)) {
            return false;
        }
        if (this.value.isNull()) {
            return instance.value.isNull();
        }
        if (this.schemaManager != null) {
            MatchingRule equalityMatchingRule = this.attributeType.getEquality();
            if (equalityMatchingRule != null) {
                return equalityMatchingRule.getLdapComparator().compare(this.value.getValue(), instance.value.getValue()) == 0;
            }
            if (this.value instanceof BinaryValue) {
                return Arrays.equals(this.value.getBytes(), instance.value.getBytes());
            }
            return this.value.getString().equals(instance.value.getString());
        }
        return this.value.equals(instance.value);
    }

    public int serialize(byte[] buffer, int pos) throws IOException {
        if (Strings.isEmpty((String)this.upName) || Strings.isEmpty((String)this.upType) || Strings.isEmpty((String)this.normType) || this.value.isNull() || this.value.isNull()) {
            String message = "Cannot serialize an wrong ATAV, ";
            if (Strings.isEmpty((String)this.upName)) {
                message = message + "the upName should not be null or empty";
            } else if (Strings.isEmpty((String)this.upType)) {
                message = message + "the upType should not be null or empty";
            } else if (Strings.isEmpty((String)this.normType)) {
                message = message + "the normType should not be null or empty";
            } else if (this.value.isNull()) {
                message = message + "the value should not be null";
            }
            LOG.error(message);
            throw new IOException(message);
        }
        int length = 0;
        byte[] upNameBytes = null;
        if (this.upName != null) {
            upNameBytes = Strings.getBytesUtf8((String)this.upName);
            length += 5 + upNameBytes.length;
        }
        byte[] upTypeBytes = null;
        if (this.upType != null) {
            upTypeBytes = Strings.getBytesUtf8((String)this.upType);
            length += 5 + upTypeBytes.length;
        }
        byte[] normTypeBytes = null;
        if (this.normType != null) {
            normTypeBytes = Strings.getBytesUtf8((String)this.normType);
            length += 5 + normTypeBytes.length;
        }
        ++length;
        if (buffer.length - pos < (length += 4)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.upName != null) {
            buffer[pos++] = 1;
            pos = Serialize.serialize((byte[])upNameBytes, (byte[])buffer, (int)pos);
        } else {
            buffer[pos++] = 0;
        }
        if (this.upType != null) {
            buffer[pos++] = 1;
            pos = Serialize.serialize((byte[])upTypeBytes, (byte[])buffer, (int)pos);
        } else {
            buffer[pos++] = 0;
        }
        if (this.normType != null) {
            buffer[pos++] = 1;
            pos = Serialize.serialize((byte[])normTypeBytes, (byte[])buffer, (int)pos);
        } else {
            buffer[pos++] = 0;
        }
        buffer[pos++] = this.value.isHumanReadable() ? (byte)1 : 0;
        if (this.value.isHumanReadable()) {
            pos = ((StringValue)this.value).serialize(buffer, pos);
        }
        pos = Serialize.serialize((int)this.h, (byte[])buffer, (int)pos);
        return pos;
    }

    public int deserialize(byte[] buffer, int pos) throws IOException, LdapInvalidAttributeValueException {
        if (pos < 0 || pos >= buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean hasUpName = Serialize.deserializeBoolean((byte[])buffer, (int)pos);
        ++pos;
        if (hasUpName) {
            byte[] wrappedValueBytes = Serialize.deserializeBytes((byte[])buffer, (int)pos);
            pos += 4 + wrappedValueBytes.length;
            this.upName = Strings.utf8ToString((byte[])wrappedValueBytes);
        }
        boolean hasUpType = Serialize.deserializeBoolean((byte[])buffer, (int)pos);
        ++pos;
        if (hasUpType) {
            byte[] upTypeBytes = Serialize.deserializeBytes((byte[])buffer, (int)pos);
            pos += 4 + upTypeBytes.length;
            this.upType = Strings.utf8ToString((byte[])upTypeBytes);
        }
        boolean hasNormType = Serialize.deserializeBoolean((byte[])buffer, (int)pos);
        ++pos;
        if (hasNormType) {
            byte[] normTypeBytes = Serialize.deserializeBytes((byte[])buffer, (int)pos);
            pos += 4 + normTypeBytes.length;
            this.normType = Strings.utf8ToString((byte[])normTypeBytes);
        }
        if (this.schemaManager != null) {
            this.attributeType = !Strings.isEmpty((String)this.upType) ? this.schemaManager.getAttributeType(this.upType) : this.schemaManager.getAttributeType(this.normType);
        }
        boolean isHR = Serialize.deserializeBoolean((byte[])buffer, (int)pos);
        ++pos;
        if (isHR) {
            this.value = new StringValue(this.attributeType);
            pos = ((StringValue)this.value).deserialize(buffer, pos);
        }
        this.h = Serialize.deserializeInt((byte[])buffer, (int)pos);
        return pos += 4;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (Strings.isEmpty((String)this.upName) || Strings.isEmpty((String)this.upType) || Strings.isEmpty((String)this.normType) || this.value.isNull()) {
            String message = "Cannot serialize a wrong ATAV, ";
            if (Strings.isEmpty((String)this.upName)) {
                message = message + "the upName should not be null or empty";
            } else if (Strings.isEmpty((String)this.upType)) {
                message = message + "the upType should not be null or empty";
            } else if (Strings.isEmpty((String)this.normType)) {
                message = message + "the normType should not be null or empty";
            } else if (this.value.isNull()) {
                message = message + "the value should not be null";
            }
            LOG.error(message);
            throw new IOException(message);
        }
        if (this.upName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upName);
        } else {
            out.writeBoolean(false);
        }
        if (this.upType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upType);
        } else {
            out.writeBoolean(false);
        }
        if (this.normType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.normType);
        } else {
            out.writeBoolean(false);
        }
        boolean isHR = this.value.isHumanReadable();
        out.writeBoolean(isHR);
        this.value.writeExternal(out);
        out.writeInt(this.h);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isHR;
        boolean hasNormType;
        boolean hasUpType;
        boolean hasUpName = in.readBoolean();
        if (hasUpName) {
            this.upName = in.readUTF();
        }
        if (hasUpType = in.readBoolean()) {
            this.upType = in.readUTF();
        }
        if (hasNormType = in.readBoolean()) {
            this.normType = in.readUTF();
        }
        if (this.schemaManager != null) {
            this.attributeType = !Strings.isEmpty((String)this.upType) ? this.schemaManager.getAttributeType(this.upType) : this.schemaManager.getAttributeType(this.normType);
        }
        this.value = (isHR = in.readBoolean()) ? StringValue.deserialize(this.attributeType, in) : BinaryValue.deserialize(this.attributeType, in);
        this.h = in.readInt();
        if (this.schemaManager != null) {
            this.attributeType = this.schemaManager.getAttributeType(this.upType);
        }
    }

    public boolean isSchemaAware() {
        return this.attributeType != null;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    private int compareValues(Ava that) {
        int comp = 0;
        if (this.value.getNormValue() instanceof String) {
            comp = ((String)this.value.getNormValue()).compareTo((String)that.value.getNormValue());
            return comp;
        }
        byte[] bytes1 = (byte[])this.value.getNormValue();
        byte[] bytes2 = (byte[])that.value.getNormValue();
        for (int pos = 0; pos < bytes1.length; ++pos) {
            int v1 = bytes1[pos] & 0xFF;
            int v2 = bytes2[pos] & 0xFF;
            if (v1 > v2) {
                return 1;
            }
            if (v2 <= v1) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(Ava that) {
        if (that == null) {
            return 1;
        }
        int comp = 0;
        if (this.schemaManager == null) {
            comp = this.normType.compareTo(that.normType);
            if (comp != 0) {
                return comp;
            }
            if (this.value == null) {
                if (that.value == null) {
                    return 0;
                }
                return -1;
            }
            if (that.value == null) {
                return 1;
            }
            if (this.value instanceof StringValue) {
                comp = ((StringValue)this.value).compareTo((StringValue)that.value);
                return comp;
            }
            comp = ((BinaryValue)this.value).compareTo((BinaryValue)that.value);
            return comp;
        }
        if (that.schemaManager == null) {
            try {
                that.apply(this.schemaManager);
            }
            catch (LdapInvalidDnException lide) {
                return 1;
            }
        }
        if ((comp = this.attributeType.getOid().compareTo(that.attributeType.getOid())) != 0) {
            return comp;
        }
        MatchingRule orderingMR = this.attributeType.getOrdering();
        if (orderingMR != null) {
            LdapComparator<? super Object> comparator = orderingMR.getLdapComparator();
            if (comparator != null) {
                comp = comparator.compare(this.value.getNormValue(), that.value.getNormValue());
                return comp;
            }
            comp = this.compareValues(that);
            return comp;
        }
        comp = this.compareValues(that);
        return comp;
    }

    public String toString() {
        return this.upName;
    }
}

