/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.shell;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.util.Writable;

public abstract class AdminConsoleCommand {
    private static final Map<String, Class<? extends AdminConsoleCommand>> commands = new TreeMap<String, Class<? extends AdminConsoleCommand>>();

    public abstract void run(SecurityContext var1, List<String> var2, Writable var3) throws FrameworkException, IOException;

    public abstract void commandHelp(Writable var1) throws IOException;

    public abstract void detailHelp(Writable var1) throws IOException;

    public static Set<String> commandNames() {
        return commands.keySet();
    }

    public static void registerCommand(String name, Class<? extends AdminConsoleCommand> cmd) {
        commands.put(name, cmd);
    }

    public static AdminConsoleCommand getCommand(String name) {
        Class<? extends AdminConsoleCommand> cls = commands.get(name);
        if (cls != null) {
            try {
                return cls.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean requiresEnclosingTransaction() {
        return true;
    }

    protected String getParameter(List<String> params, int index) {
        if (params.size() > index) {
            return params.get(index);
        }
        return null;
    }

    protected Map<String, Object> toMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (key != null && value != null) {
            map.put(key, value);
        }
        return map;
    }

    protected Map<String, Object> toMap(String key, Object value, String key2, Object value2) {
        Map<String, Object> map = this.toMap(key, value);
        if (key2 != null && value2 != null) {
            map.put(key2, value2);
        }
        return map;
    }

    protected Map<String, Object> toMap(String key, Object value, String key2, Object value2, String key3, Object value3) {
        Map<String, Object> map = this.toMap(key, value, key2, value2);
        if (key3 != null && value3 != null) {
            map.put(key3, value3);
        }
        return map;
    }
}

