/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.shell;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.console.shell.AdminConsoleCommand;
import org.structr.util.Writable;

public class HelpConsoleCommand
extends AdminConsoleCommand {
    @Override
    public void run(SecurityContext securityContext, List<String> parameters, Writable writable) throws FrameworkException, IOException {
        if (parameters.size() > 1) {
            String key = parameters.get(1);
            AdminConsoleCommand cmd = AdminConsoleCommand.getCommand(key);
            if (cmd != null) {
                cmd.detailHelp(writable);
            } else {
                writable.println(new Object[]{"Unknown command '" + key + "'."});
            }
        } else {
            for (String key : AdminConsoleCommand.commandNames()) {
                AdminConsoleCommand cmd = AdminConsoleCommand.getCommand(key);
                writable.print(new Object[]{StringUtils.rightPad((String)key, (int)10)});
                writable.print(new Object[]{" - "});
                cmd.commandHelp(writable);
            }
        }
    }

    @Override
    public void commandHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"Prints a list of all commands and a short help text. Use 'help <command> to get more details."});
    }

    @Override
    public void detailHelp(Writable writable) throws IOException {
        this.commandHelp(writable);
    }

    static {
        AdminConsoleCommand.registerCommand("help", HelpConsoleCommand.class);
    }
}

