/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.shell;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.console.shell.AdminConsoleCommand;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.graph.BulkCreateLabelsCommand;
import org.structr.core.graph.BulkRebuildIndexCommand;
import org.structr.core.graph.BulkSetUuidCommand;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.util.Writable;

public class InitConsoleCommand
extends AdminConsoleCommand {
    @Override
    public void run(SecurityContext securityContext, List<String> parameters, Writable writable) throws FrameworkException, IOException {
        Principal user = securityContext.getUser(false);
        int paramCount = parameters.size();
        if (user != null && user.isAdmin()) {
            Object command = null;
            boolean allNodes = true;
            boolean allRels = true;
            boolean isCreateLabels = false;
            boolean isIndex = false;
            boolean isIds = false;
            boolean hasCommand = false;
            boolean hasFor = false;
            boolean error = false;
            String type = null;
            String typeKey = null;
            String mode = null;
            for (int i = 1; i < paramCount && !error; ++i) {
                String param;
                switch (param = this.getParameter(parameters, i)) {
                    case "index": {
                        if (hasCommand) {
                            writable.println(new Object[]{"Syntax error, too many parameters."});
                            error = true;
                            break;
                        }
                        command = (NodeServiceCommand)StructrApp.getInstance((SecurityContext)securityContext).command(BulkRebuildIndexCommand.class);
                        command.setLogBuffer(writable);
                        isIndex = true;
                        hasCommand = true;
                        break;
                    }
                    case "ids": {
                        if (hasCommand) {
                            writable.println(new Object[]{"Syntax error, too many parameters."});
                            error = true;
                            break;
                        }
                        command = (NodeServiceCommand)StructrApp.getInstance((SecurityContext)securityContext).command(BulkSetUuidCommand.class);
                        command.setLogBuffer(writable);
                        isIds = true;
                        hasCommand = true;
                        break;
                    }
                    case "labels": {
                        if (hasCommand) {
                            writable.println(new Object[]{"Syntax error, too many parameters."});
                            error = true;
                            break;
                        }
                        if ("relsOnly".equals(mode)) {
                            writable.println(new Object[]{"Cannot set labels on relationships."});
                            error = true;
                            break;
                        }
                        command = (NodeServiceCommand)StructrApp.getInstance((SecurityContext)securityContext).command(BulkCreateLabelsCommand.class);
                        command.setLogBuffer(writable);
                        isCreateLabels = true;
                        hasCommand = true;
                        break;
                    }
                    case "node": {
                        if (hasCommand) {
                            if (isIndex) {
                                writable.println(new Object[]{"Index type must be specified before the 'index' keyword."});
                                error = true;
                                break;
                            }
                            if (!isIds) break;
                            writable.println(new Object[]{"Entity type must be specified before the 'ids' keyword."});
                            error = true;
                            break;
                        }
                        mode = "nodesOnly";
                        typeKey = "type";
                        allRels = false;
                        break;
                    }
                    case "rel": 
                    case "relationship": {
                        if (hasCommand) {
                            if (isIndex) {
                                writable.println(new Object[]{"Index type must be specified before the 'index' keyword."});
                                error = true;
                                break;
                            }
                            if (!isIds) break;
                            writable.println(new Object[]{"Entity type must be specified before the 'ids' keyword."});
                            error = true;
                            break;
                        }
                        if (isCreateLabels) {
                            writable.println(new Object[]{"Cannot set labels on relationships."});
                            error = true;
                        }
                        mode = "relsOnly";
                        typeKey = "relType";
                        allNodes = false;
                        break;
                    }
                    case "for": {
                        if (!hasCommand) {
                            writable.println(new Object[]{"Unknown init mode 'for'."});
                            error = true;
                        }
                        hasFor = true;
                        break;
                    }
                    default: {
                        if (hasCommand && hasFor) {
                            if (StringUtils.isNotBlank(type)) {
                                writable.println(new Object[]{"Syntax error, too many parameters."});
                                error = true;
                                break;
                            }
                            type = param;
                            if (typeKey != null) break;
                            typeKey = "type";
                            break;
                        }
                        if (!hasCommand) {
                            writable.println(new Object[]{"Unknown init mode '" + param + "'."});
                            error = true;
                            break;
                        }
                        writable.println(new Object[]{"Syntax error, please specify something like 'init node index for User'."});
                        error = true;
                    }
                }
                if (error) break;
            }
            if (!error && !hasCommand) {
                writable.println(new Object[]{"Please specify what to initialize."});
                error = true;
            }
            if (!error && hasCommand && hasFor && StringUtils.isEmpty(type)) {
                writable.println(new Object[]{"Missing type specification, please specify something like 'init node index for User'."});
                error = true;
            }
            if (!error) {
                if (command instanceof MaintenanceCommand) {
                    Map<String, Object> data = this.toMap("mode", mode, typeKey, type);
                    if (type == null) {
                        data.put("allNodes", allNodes);
                        data.put("allRels", allRels);
                    }
                    ((MaintenanceCommand)command).execute(data);
                } else if (command != null) {
                    writable.println(new Object[]{"Cannot execute command '" + command.getClass().getSimpleName() + "', wrong type."});
                } else {
                    writable.println(new Object[]{"Cannot execute null command."});
                }
            }
        } else {
            writable.println(new Object[]{"You must be admin user to use this command."});
        }
    }

    @Override
    public void commandHelp(Writable buf) throws IOException {
        buf.println(new Object[]{"Initializes UUIDs, labels and indexes on nodes and relationships."});
    }

    @Override
    public void detailHelp(Writable buf) throws IOException {
        buf.println(new Object[]{"init [node|rel] index [for <type>] - Rebuilds the node/relationship index."});
        buf.println(new Object[]{"init [node|rel] ids [for <type>]   - Sets UUIDs on nodes and/or relationship."});
        buf.println(new Object[]{"init [node] labels [for <type>]    - Sets labels on nodes and/or relationship."});
    }

    static {
        AdminConsoleCommand.registerCommand("init", InitConsoleCommand.class);
    }
}

