/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.tabcompletion;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.console.tabcompletion.AbstractTabCompletionProvider;
import org.structr.console.tabcompletion.TabCompletionResult;
import org.structr.core.app.StructrApp;

public class CypherTabCompletionProvider
extends AbstractTabCompletionProvider {
    private static final Pattern nodePattern = Pattern.compile("\\([a-zA-Z]?[a-zA-Z0-9]+:[a-zA-Z]?[a-zA-Z0-9]+");
    private static final Pattern relPattern = Pattern.compile("\\[[a-zA-Z]?[a-zA-Z0-9]+:[a-zA-Z]?[a-zA-Z0-9]+");
    private final List<String> words = new LinkedList<String>();

    public CypherTabCompletionProvider() {
        this.words.add("any");
        this.words.add("asc");
        this.words.add("assert");
        this.words.add("case");
        this.words.add("constraint");
        this.words.add("create");
        this.words.add("csv");
        this.words.add("delete");
        this.words.add("desc");
        this.words.add("detach");
        this.words.add("distinct");
        this.words.add("drop");
        this.words.add("end");
        this.words.add("foreach");
        this.words.add("from");
        this.words.add("index");
        this.words.add("limit");
        this.words.add("load");
        this.words.add("match");
        this.words.add("merge");
        this.words.add("order");
        this.words.add("remove");
        this.words.add("return");
        this.words.add("set");
        this.words.add("skip");
        this.words.add("then");
        this.words.add("union");
        this.words.add("unique");
        this.words.add("unwind");
        this.words.add("using");
        this.words.add("when");
        this.words.add("where");
        this.words.add("with");
    }

    @Override
    public List<TabCompletionResult> getTabCompletion(SecurityContext securityContext, String line) {
        LinkedList<TabCompletionResult> results = new LinkedList<TabCompletionResult>();
        String token = this.getToken(line, " ");
        results.addAll(this.getCaseInsensitiveResultsForCollection(this.words, token, " "));
        results.addAll(this.getTabCompletionForUUIDs(securityContext, token, ""));
        Matcher nodeMatcher = nodePattern.matcher(token);
        if (nodeMatcher.matches()) {
            Set<String> keys = this.getNodeTypes();
            String subtoken = StringUtils.substringAfterLast((String)token, (String)":");
            String suffix = "";
            results.addAll(this.getExactResultsForCollection(keys, subtoken, ""));
        }
        Collections.sort(results);
        return results;
    }

    private Set<String> getNodeTypes() {
        return StructrApp.getConfiguration().getNodeEntities().keySet();
    }
}

