/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cmis.wrapper.CMISObjectWrapper;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.files.cmis.AbstractStructrCmisService;
import org.structr.files.cmis.StructrCMISService;
import org.structr.files.cmis.wrapper.CMISContentStream;
import org.structr.files.cmis.wrapper.CMISPagingListWrapper;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public class CMISObjectService
extends AbstractStructrCmisService
implements ObjectService {
    private static final Logger logger = LoggerFactory.getLogger((String)CMISObjectService.class.getName());

    public CMISObjectService(StructrCMISService parentService, SecurityContext securityContext) {
        super(parentService, securityContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        FileBase newFile = null;
        String uuid = null;
        try (Tx tx = app.tx();){
            String objectTypeId = this.getStringValue(properties, "cmis:objectTypeId");
            String fileName = this.getStringValue(properties, "cmis:name");
            Class type = this.typeFromObjectTypeId(objectTypeId, BaseTypeId.CMIS_DOCUMENT, File.class);
            if (type == null) throw new CmisObjectNotFoundException("Type with ID " + objectTypeId + " does not exist");
            BaseTypeId baseTypeId = this.getBaseTypeId(type);
            if (baseTypeId == null || !BaseTypeId.CMIS_DOCUMENT.equals((Object)baseTypeId)) throw new CmisConstraintException("Cannot create cmis:document of type " + objectTypeId);
            String mimeType = contentStream != null ? contentStream.getMimeType() : null;
            newFile = (FileBase)FileHelper.createFile(this.securityContext, new byte[0], mimeType, type, fileName);
            if (newFile != null) {
                InputStream inputStream;
                if (!"/".equals(folderId)) {
                    Folder parent = (Folder)app.get(Folder.class, folderId);
                    if (parent == null) throw new CmisObjectNotFoundException("Folder with ID " + folderId + " does not exist");
                    newFile.setProperties(this.securityContext, new PropertyMap((PropertyKey)Folder.parent, (Object)parent));
                }
                uuid = newFile.getUuid();
                if (contentStream != null && (inputStream = contentStream.getStream()) != null) {
                    try (FileOutputStream outputStream = newFile.getOutputStream(false, false);){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    inputStream.close();
                    FileHelper.updateMetadata(newFile);
                }
            }
            tx.success();
        }
        catch (Throwable t) {
            throw new CmisRuntimeException("New document could not be created: " + t.getMessage());
        }
        if (newFile == null) return uuid;
        newFile.notifyUploadCompletion();
        return uuid;
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        String uuid = null;
        try (Tx tx = app.tx();){
            FileBase existingDocument = (FileBase)app.get(FileBase.class, sourceId);
            if (existingDocument != null) {
                try (InputStream inputStream = existingDocument.getInputStream();){
                    ContentStreamImpl copyContentStream = new ContentStreamImpl();
                    copyContentStream.setFileName(existingDocument.getName());
                    copyContentStream.setMimeType(existingDocument.getContentType());
                    copyContentStream.setLength(BigInteger.valueOf(existingDocument.getSize()));
                    copyContentStream.setStream(inputStream);
                    uuid = this.createDocument(repositoryId, properties, folderId, (ContentStream)copyContentStream, versioningState, policies, addAces, removeAces, extension);
                }
            } else {
                throw new CmisObjectNotFoundException("Document with ID " + sourceId + " does not exist");
            }
            tx.success();
        }
        catch (Throwable t) {
            throw new CmisRuntimeException("New document could not be created: " + t.getMessage());
        }
        return uuid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        String uuid = null;
        try (Tx tx = app.tx();){
            String objectTypeId = this.getStringValue(properties, "cmis:objectTypeId");
            Class type = this.typeFromObjectTypeId(objectTypeId, BaseTypeId.CMIS_FOLDER, Folder.class);
            if (type == null) throw new CmisObjectNotFoundException("Type with ID " + objectTypeId + " does not exist");
            BaseTypeId baseTypeId = this.getBaseTypeId(type);
            if (baseTypeId == null || !BaseTypeId.CMIS_FOLDER.equals((Object)baseTypeId)) throw new CmisConstraintException("Cannot create cmis:folder of type " + objectTypeId);
            NodeInterface newFolder = app.create(type, PropertyMap.cmisTypeToJavaType((SecurityContext)this.securityContext, (Class)type, (Properties)properties));
            if (!"/".equals(folderId)) {
                Folder parent = (Folder)app.get(Folder.class, folderId);
                if (parent == null) throw new CmisObjectNotFoundException("Folder with ID " + folderId + " does not exist");
                newFolder.setProperties(this.securityContext, new PropertyMap((PropertyKey)Folder.parent, (Object)parent));
            }
            uuid = newFolder.getUuid();
            tx.success();
            return uuid;
        }
        catch (Throwable t) {
            throw new CmisRuntimeException("New folder could not be created: " + t.getMessage());
        }
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        ObjectData obj = this.getObject(repositoryId, objectId, null, true, IncludeRelationships.NONE, null, false, false, extension);
        if (obj != null) {
            return obj.getAllowableActions();
        }
        throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectData getObject(String repositoryId, String objectId, String propertyFilter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            GraphObject obj = app.get(objectId);
            if (obj == null) throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
            CMISObjectWrapper data = CMISObjectWrapper.wrap((GraphObject)obj, (String)propertyFilter, (Boolean)includeAllowableActions);
            tx.success();
            CMISObjectWrapper cMISObjectWrapper = data;
            return cMISObjectWrapper;
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
    }

    public Properties getProperties(String repositoryId, String objectId, String propertyFilter, ExtensionsData extension) {
        ObjectData obj = this.getObject(repositoryId, objectId, propertyFilter, false, IncludeRelationships.NONE, null, false, false, extension);
        if (obj != null) {
            return obj.getProperties();
        }
        throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectData obj = this.getObject(repositoryId, objectId, renditionFilter, false, IncludeRelationships.NONE, null, false, false, extension);
        if (obj != null) {
            return new CMISPagingListWrapper(obj.getRenditions(), maxItems, skipCount).getPagedList();
        }
        throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String propertyFilter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        App app = StructrApp.getInstance();
        CMISObjectWrapper result = null;
        try (Tx tx = app.tx();){
            AbstractFile file = (AbstractFile)app.nodeQuery(AbstractFile.class).and(AbstractFile.path, (Object)path).getFirst();
            if (file != null) {
                result = CMISObjectWrapper.wrap((GraphObject)file, (String)propertyFilter, (Boolean)includeAllowableActions);
            }
            tx.success();
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        if (result != null) {
            return result;
        }
        throw new CmisObjectNotFoundException("Object with path " + path + " does not exist");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        App app = StructrApp.getInstance();
        ContentStream result = null;
        try (Tx tx = app.tx();){
            FileBase file = (FileBase)app.get(FileBase.class, objectId);
            if (file != null) {
                CMISContentStream cMISContentStream = new CMISContentStream(file, offset, length);
                return cMISContentStream;
            }
            tx.success();
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        if (result == null) throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
        return result;
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        App app = StructrApp.getInstance();
        String id = (String)objectId.getValue();
        try (Tx tx = app.tx();){
            GraphObject obj = app.get(id);
            if (obj != null) {
                PropertyMap propertyMap = PropertyMap.cmisTypeToJavaType((SecurityContext)this.securityContext, obj.getClass(), (Properties)properties);
                if (propertyMap != null) {
                    obj.setProperties(this.securityContext, propertyMap);
                }
            } else {
                throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            throw new CmisConstraintException(fex.getMessage(), (Throwable)fex);
        }
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdsAndChangeTokens, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        LinkedList<BulkUpdateObjectIdAndChangeToken> result = new LinkedList<BulkUpdateObjectIdAndChangeToken>();
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            for (BulkUpdateObjectIdAndChangeToken token : objectIdsAndChangeTokens) {
                GraphObject obj = app.get(token.getId());
                if (obj == null) continue;
                PropertyMap propertyMap = PropertyMap.cmisTypeToJavaType((SecurityContext)this.securityContext, obj.getClass(), (Properties)properties);
                if (propertyMap != null) {
                    obj.setProperties(this.securityContext, propertyMap);
                }
                result.add(token);
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            throw new CmisConstraintException(fex.getMessage(), (Throwable)fex);
        }
        return result;
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        block20: {
            if (sourceFolderId != null && targetFolderId != null) {
                if (sourceFolderId.equals(targetFolderId)) {
                    return;
                }
                App app = StructrApp.getInstance((SecurityContext)this.securityContext);
                try (Tx tx = app.tx();){
                    FileBase file = this.get(app, FileBase.class, (String)objectId.getValue());
                    Folder parent = (Folder)((Object)file.getProperty((PropertyKey)FileBase.parent));
                    if ("/".equals(sourceFolderId) && parent != null) {
                        throw new CmisInvalidArgumentException("Object with ID " + (String)objectId.getValue() + " is not filed in folder with ID " + sourceFolderId);
                    }
                    if (parent != null && !sourceFolderId.equals(parent.getUuid())) {
                        throw new CmisInvalidArgumentException("Object with ID " + (String)objectId.getValue() + " is not filed in folder with ID " + sourceFolderId);
                    }
                    if ("/".equals(targetFolderId)) {
                        file.setProperties(this.securityContext, new PropertyMap((PropertyKey)FileBase.parent, null));
                    } else {
                        file.setProperties(this.securityContext, new PropertyMap((PropertyKey)FileBase.parent, (Object)this.get(app, Folder.class, targetFolderId)));
                    }
                    tx.success();
                    break block20;
                }
                catch (FrameworkException fex) {
                    throw new CmisConstraintException(fex.getMessage(), (Throwable)fex);
                }
            }
            throw new CmisInvalidArgumentException("Source and target folder must be set");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            Principal principal = this.securityContext.getUser(false);
            GraphObject obj = app.get(objectId);
            if (obj == null) throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
            if (!principal.isGranted(Permission.delete, this.securityContext)) throw new CmisPermissionDeniedException("Cannot delete object with ID " + objectId);
            if (obj.isNode()) {
                app.delete(obj.getSyncNode());
            } else {
                app.delete(obj.getSyncRelationship());
            }
            tx.success();
            return;
        }
        catch (FrameworkException fex) {
            throw new CmisConstraintException(fex.getMessage(), (Throwable)fex);
        }
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        if (UnfileObject.UNFILE.equals((Object)unfileObjects)) {
            throw new CmisNotSupportedException("Unfiling not supported");
        }
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        result.setIds(new LinkedList());
        try (Tx tx = app.tx();){
            Folder folder = (Folder)app.get(Folder.class, folderId);
            if (folder == null) {
                throw new CmisObjectNotFoundException("Folder with ID " + folderId + " does not exist");
            }
            this.recursivelyCheckAndDeleteFiles(app, result, folder, continueOnFailure);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return result;
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void recursivelyCheckAndDeleteFiles(App app, FailedToDeleteDataImpl result, AbstractFile toDelete, Boolean continueOnFailure) throws FrameworkException {
        if (toDelete != null) {
            Principal owner = toDelete.getOwnerNode();
            if (owner == null || owner.isGranted(Permission.delete, this.securityContext)) {
                app.delete((NodeInterface)toDelete);
                for (AbstractFile child : (List)toDelete.getProperty((PropertyKey)AbstractFile.children)) {
                    this.recursivelyCheckAndDeleteFiles(app, result, child, continueOnFailure);
                }
            } else if (continueOnFailure.booleanValue()) {
                result.getIds().add(toDelete.getUuid());
            } else {
                throw new CmisPermissionDeniedException("Cannot delete object with ID " + toDelete.getUuid());
            }
        }
    }

    private <T extends GraphObject> T get(App app, Class<T> type, String id) throws FrameworkException {
        GraphObject obj = app.get(type, id);
        if (obj != null) {
            return (T)obj;
        }
        throw new CmisObjectNotFoundException("Object with ID " + id + " does not exist");
    }
}

