/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.app.StructrApp;
import org.structr.files.cmis.CMISAclService;
import org.structr.files.cmis.CMISDiscoveryService;
import org.structr.files.cmis.CMISMultiFilingService;
import org.structr.files.cmis.CMISNavigationService;
import org.structr.files.cmis.CMISObjectService;
import org.structr.files.cmis.CMISPolicyService;
import org.structr.files.cmis.CMISRelationshipService;
import org.structr.files.cmis.CMISRepositoryService;
import org.structr.files.cmis.CMISVersioningService;
import org.structr.files.cmis.repository.CMISRootFolder;

public class StructrCMISService
extends AbstractCmisService {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrCMISService.class.getName());
    private CMISPolicyService policyService = null;
    private CMISAclService aclService = null;
    private CMISRelationshipService relationshipService = null;
    private CMISMultiFilingService multiFilingService = null;
    private CMISDiscoveryService discoveryService = null;
    private CMISVersioningService versioningService = null;
    private CMISObjectService objectService = null;
    private CMISNavigationService navigationService = null;
    private CMISRepositoryService repositoryService = null;
    private SecurityContext securityContext = null;

    public StructrCMISService(SecurityContext securityContext) {
        this.repositoryService = new CMISRepositoryService(this, securityContext);
        this.navigationService = new CMISNavigationService(this, securityContext);
        this.objectService = new CMISObjectService(this, securityContext);
        this.versioningService = new CMISVersioningService(this, securityContext);
        this.discoveryService = new CMISDiscoveryService(this, securityContext);
        this.multiFilingService = new CMISMultiFilingService(this, securityContext);
        this.relationshipService = new CMISRelationshipService(this, securityContext);
        this.aclService = new CMISAclService(this, securityContext);
        this.policyService = new CMISPolicyService(this, securityContext);
        this.securityContext = securityContext;
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.objectService.deleteObject(repositoryId, objectId, allVersions, extension);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        return this.aclService.applyAcl(repositoryId, objectId, aces, aclPropagation);
    }

    public ObjectInfo getObjectInfo(String repositoryId, String objectId) {
        CMISRootFolder obj = null;
        if (objectId == null) {
            return null;
        }
        obj = "/".equals(objectId) ? new CMISRootFolder(null, false) : this.getObject(repositoryId, objectId, null, Boolean.FALSE, IncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
        return this.getObjectInfoIntern(repositoryId, (ObjectData)obj);
    }

    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        String objectTypeId = this.objectService.getStringValue(properties, "cmis:objectTypeId");
        if (objectTypeId != null) {
            Class type;
            BaseTypeId baseTypeId = this.objectService.getBaseTypeId(objectTypeId);
            if (baseTypeId == null && (type = StructrApp.getConfiguration().getNodeEntityClass(objectTypeId)) != null) {
                baseTypeId = this.objectService.getBaseTypeId(type);
            }
            if (baseTypeId != null) {
                switch (baseTypeId) {
                    case CMIS_DOCUMENT: {
                        if (contentStream == null) {
                            throw new CmisInvalidArgumentException("Document object must have a content stream");
                        }
                        return this.objectService.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, null, null, extension);
                    }
                    case CMIS_FOLDER: {
                        if (contentStream != null) {
                            throw new CmisInvalidArgumentException("Folder object must not have a content stream");
                        }
                        return this.objectService.createFolder(repositoryId, properties, folderId, policies, null, null, extension);
                    }
                    case CMIS_ITEM: {
                        return this.objectService.createItem(repositoryId, properties, folderId, policies, null, null, extension);
                    }
                    case CMIS_RELATIONSHIP: {
                        return this.objectService.createRelationship(repositoryId, properties, policies, null, null, extension);
                    }
                    case CMIS_POLICY: {
                        return this.objectService.createPolicy(repositoryId, properties, folderId, policies, null, null, extension);
                    }
                    case CMIS_SECONDARY: {
                        throw new CmisInvalidArgumentException("Cannot create object of secondary type");
                    }
                }
            } else {
                throw new CmisObjectNotFoundException("Type " + objectTypeId + " does not exist");
            }
        }
        throw new CmisInvalidArgumentException("Property 'cmis:objectTypeId' must be set!");
    }

    public void close() {
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        return this.repositoryService.getRepositoryInfos(extension);
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        return this.repositoryService.getRepositoryInfo(repositoryId, extension);
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.repositoryService.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        return this.repositoryService.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, extension);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.repositoryService.getTypeDefinition(repositoryId, typeId, extension);
    }

    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        return this.repositoryService.createType(repositoryId, type, extension);
    }

    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        return this.repositoryService.updateType(repositoryId, type, extension);
    }

    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        this.repositoryService.deleteType(repositoryId, typeId, extension);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.navigationService.getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, extension);
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.navigationService.getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension);
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.navigationService.getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension);
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        return this.navigationService.getObjectParents(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, extension);
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String propertyFilter, ExtensionsData extension) {
        ObjectData parent = this.navigationService.getFolderParent(repositoryId, folderId, propertyFilter, extension);
        if (parent != null) {
            return parent;
        }
        return new CMISRootFolder(propertyFilter, false);
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.navigationService.getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.objectService.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.objectService.createDocumentFromSource(repositoryId, sourceId, properties, folderId, versioningState, policies, addAces, removeAces, extension);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.objectService.createFolder(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.objectService.createRelationship(repositoryId, properties, policies, addAces, removeAces, extension);
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.objectService.createPolicy(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
    }

    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.objectService.createItem(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        if ("/".equals(objectId)) {
            return new CMISRootFolder(null, true).getAllowableActions();
        }
        return this.objectService.getAllowableActions(repositoryId, objectId, extension);
    }

    public ObjectData getObject(String repositoryId, String objectId, String propertyFilter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        if (objectId == null) {
            throw new CmisInvalidArgumentException("objectId may not be null");
        }
        if ("/".equals(objectId)) {
            return new CMISRootFolder(propertyFilter, includeAllowableActions);
        }
        return this.objectService.getObject(repositoryId, objectId, propertyFilter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
    }

    public Properties getProperties(String repositoryId, String objectId, String propertyFilter, ExtensionsData extension) {
        if ("/".equals(objectId)) {
            return new CMISRootFolder(propertyFilter, false).getProperties();
        }
        return this.objectService.getProperties(repositoryId, objectId, propertyFilter, extension);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        if ("/".equals(objectId)) {
            return new CMISRootFolder(null, false).getRenditions();
        }
        return this.objectService.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, extension);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String propertyFilter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        String cleanPath = FilenameUtils.normalize((String)path);
        if ("/".equals(cleanPath) || cleanPath == null || path == null) {
            return new CMISRootFolder(propertyFilter, includeAllowableActions);
        }
        return this.objectService.getObjectByPath(repositoryId, cleanPath, propertyFilter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        return this.objectService.getContentStream(repositoryId, objectId, streamId, offset, length, extension);
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.objectService.updateProperties(repositoryId, objectId, changeToken, properties, extension);
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdsAndChangeTokens, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        return this.objectService.bulkUpdateProperties(repositoryId, objectIdsAndChangeTokens, properties, addSecondaryTypeIds, removeSecondaryTypeIds, extension);
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.objectService.moveObject(repositoryId, objectId, targetFolderId, sourceFolderId, extension);
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.objectService.deleteObject(repositoryId, objectId, allVersions, extension);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        return this.objectService.deleteTree(repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, extension);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.objectService.setContentStream(repositoryId, objectId, overwriteFlag, changeToken, contentStream, extension);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.objectService.deleteContentStream(repositoryId, objectId, changeToken, extension);
    }

    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        this.objectService.appendContentStream(repositoryId, objectId, changeToken, contentStream, isLastChunk, extension);
    }

    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        this.versioningService.checkOut(repositoryId, objectId, extension, contentCopied);
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.versioningService.cancelCheckOut(repositoryId, objectId, extension);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.versioningService.checkIn(repositoryId, objectId, major, properties, contentStream, checkinComment, policies, addAces, removeAces, extension);
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.versioningService.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        return this.versioningService.getPropertiesOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, extension);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        LinkedList<ObjectData> result = new LinkedList<ObjectData>();
        result.add(this.getObject(repositoryId, objectId, filter, includeAllowableActions, IncludeRelationships.NONE, null, false, false, extension));
        return result;
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.discoveryService.query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        return this.discoveryService.getContentChanges(repositoryId, changeLogToken, includeProperties, filter, includePolicyIds, includeAcl, maxItems, extension);
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        this.multiFilingService.addObjectToFolder(repositoryId, objectId, folderId, allVersions, extension);
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        this.multiFilingService.removeObjectFromFolder(repositoryId, objectId, folderId, extension);
    }

    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.relationshipService.getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes, relationshipDirection, typeId, filter, includeAllowableActions, maxItems, skipCount, extension);
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        return this.aclService.getAcl(repositoryId, objectId, onlyBasicPermissions, extension);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        return this.aclService.applyAcl(repositoryId, objectId, addAces, removeAces, aclPropagation, extension);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.policyService.applyPolicy(repositoryId, policyId, objectId, extension);
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.policyService.removePolicy(repositoryId, policyId, objectId, extension);
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return this.policyService.getAppliedPolicies(repositoryId, objectId, filter, extension);
    }
}

