/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis.wrapper;

import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.structr.cmis.wrapper.CMISObjectWrapper;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.files.cmis.wrapper.CMISPagingListWrapper;

public class CMISObjectInFolderWrapper
extends CMISPagingListWrapper<ObjectInFolderData>
implements ObjectInFolderList {
    private Boolean includeAllowableActions = false;
    private String propertyFilter = null;

    public CMISObjectInFolderWrapper(Boolean includeAllowableActions) {
        this(null, includeAllowableActions, null, null);
    }

    public CMISObjectInFolderWrapper(String propertyFilter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount) {
        super(maxItems, skipCount);
        this.includeAllowableActions = includeAllowableActions;
        this.propertyFilter = propertyFilter;
    }

    public ObjectInFolderData wrapObjectData(ObjectData element, String pathSegment) {
        ObjectInFolderDataImpl data = new ObjectInFolderDataImpl(element);
        data.setPathSegment(pathSegment);
        return data;
    }

    public ObjectData wrapGraphObject(GraphObject item) throws FrameworkException {
        return CMISObjectWrapper.wrap((GraphObject)item, (String)this.propertyFilter, (Boolean)this.includeAllowableActions);
    }

    public void wrap(List<? extends GraphObject> list) throws FrameworkException {
        for (GraphObject graphObject : list) {
            this.add(this.wrapObjectData(this.wrapGraphObject(graphObject), (String)graphObject.getProperty((PropertyKey)AbstractNode.name)));
        }
    }

    public List<ObjectInFolderData> getObjects() {
        return this.getPagedList();
    }
}

