/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.auth;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.web.auth.StructrOAuthClient;

public class GitHubAuthClient
extends StructrOAuthClient {
    private static final Logger logger = LoggerFactory.getLogger((String)GitHubAuthClient.class.getName());

    @Override
    public String getScope() {
        return "user:email";
    }

    @Override
    public StructrOAuthClient.ResponseFormat getResponseFormat() {
        return StructrOAuthClient.ResponseFormat.json;
    }

    @Override
    public String getUserResourceUri() {
        return (String)Settings.OAuthGithubUserDetailsUri.getValue();
    }

    @Override
    public String getReturnUri() {
        return (String)Settings.OAuthGithubReturnUri.getValue();
    }

    @Override
    public String getErrorUri() {
        return (String)Settings.OAuthGithubErrorUri.getValue();
    }

    @Override
    public String getCredential(HttpServletRequest request) {
        JsonArray arr;
        Iterator iterator;
        OAuthResourceResponse userResponse = this.getUserResponse(request);
        if (userResponse == null) {
            return null;
        }
        String body = userResponse.getBody();
        logger.debug("User response body: {}", (Object)body);
        JsonParser parser = new JsonParser();
        JsonElement result = parser.parse(body);
        if (result instanceof JsonArray && (iterator = (arr = (JsonArray)result).iterator()).hasNext()) {
            JsonElement el = (JsonElement)iterator.next();
            String address = el.getAsJsonObject().get("email").getAsString();
            logger.info("Got 'email' credential from GitHub: {}", (Object)address);
            return address;
        }
        return null;
    }
}

