/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.auth;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.web.auth.StructrOAuthClient;

public class LinkedInAuthClient
extends StructrOAuthClient {
    private static final Logger logger = LoggerFactory.getLogger((String)LinkedInAuthClient.class.getName());

    @Override
    protected String getAccessTokenParameterKey() {
        return "oauth2_access_token";
    }

    @Override
    public String getScope() {
        return "r_basicprofile r_emailaddress";
    }

    @Override
    public StructrOAuthClient.ResponseFormat getResponseFormat() {
        return StructrOAuthClient.ResponseFormat.json;
    }

    @Override
    public String getUserResourceUri() {
        return (String)Settings.OAuthLinkedInUserDetailsUri.getValue();
    }

    @Override
    public String getReturnUri() {
        return (String)Settings.OAuthLinkedInReturnUri.getValue();
    }

    @Override
    public String getErrorUri() {
        return (String)Settings.OAuthLinkedInErrorUri.getValue();
    }

    @Override
    protected String getState() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getCredential(HttpServletRequest request) {
        OAuthResourceResponse userResponse = this.getUserResponse(request);
        if (userResponse == null) {
            return null;
        }
        String body = userResponse.getBody();
        logger.debug("User response body: {}", (Object)body);
        String[] addresses = StringUtils.stripAll((String[])StringUtils.stripAll((String[])StringUtils.stripEnd((String)StringUtils.stripStart((String)body, (String)"["), (String)"]").split(",")), (String)"\"");
        return addresses.length > 0 ? addresses[0] : null;
    }
}

