/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.common;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.structr.api.config.Settings;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.rest.ResourceProvider;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.web.common.AsyncBuffer;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.html.relation.ResourceLink;

public class RenderContext
extends ActionContext {
    private final Map<String, GraphObject> dataObjects = new LinkedHashMap<String, GraphObject>();
    private final Stack<SecurityContext> scStack = new Stack();
    private EditMode editMode = EditMode.NONE;
    private AsyncBuffer buffer = new AsyncBuffer();
    private int depth = 0;
    private boolean inBody = false;
    private boolean appLibRendered = false;
    private GraphObject detailsDataObject = null;
    private GraphObject currentDataObject = null;
    private GraphObject sourceDataObject = null;
    private Iterable<GraphObject> listSource = null;
    private PropertyKey relatedProperty = null;
    private Page page = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ResourceProvider resourceProvider = null;
    private Result result = null;
    private boolean anyChildNodeCreatesNewLine = false;
    private boolean indentHtml = true;

    public RenderContext(SecurityContext securityContext) {
        super(securityContext);
        this.readConfigParameters();
    }

    public RenderContext(RenderContext other) {
        super((ActionContext)other);
        this.dataObjects.putAll(other.dataObjects);
        this.editMode = other.editMode;
        this.inBody = other.inBody;
        this.appLibRendered = other.appLibRendered;
        this.detailsDataObject = other.detailsDataObject;
        this.currentDataObject = other.currentDataObject;
        this.sourceDataObject = other.sourceDataObject;
        this.listSource = other.listSource;
        this.relatedProperty = other.relatedProperty;
        this.page = other.page;
        this.request = other.request;
        this.response = other.response;
        this.resourceProvider = other.resourceProvider;
        this.result = other.result;
        this.anyChildNodeCreatesNewLine = other.anyChildNodeCreatesNewLine;
        this.locale = other.locale;
        this.indentHtml = other.indentHtml;
    }

    public RenderContext(SecurityContext securityContext, HttpServletRequest request, HttpServletResponse response, EditMode editMode) {
        super(securityContext);
        this.request = request;
        this.response = response;
        this.editMode = editMode;
        this.readConfigParameters();
        if (EditMode.DEPLOYMENT.equals((Object)this.editMode)) {
            this.indentHtml = true;
        }
    }

    public static RenderContext getInstance(SecurityContext securityContext, HttpServletRequest request, HttpServletResponse response) {
        String editString = StringUtils.defaultString((String)request.getParameter("edit"));
        return new RenderContext(securityContext, request, response, RenderContext.editMode(editString));
    }

    public void setDetailsDataObject(GraphObject detailsDataObject) {
        this.detailsDataObject = detailsDataObject;
    }

    public GraphObject getDetailsDataObject() {
        return this.detailsDataObject;
    }

    public void setDataObject(GraphObject currentDataObject) {
        this.currentDataObject = currentDataObject;
    }

    public GraphObject getDataObject() {
        return this.currentDataObject;
    }

    public void setSourceDataObject(GraphObject sourceDataObject) {
        this.sourceDataObject = sourceDataObject;
    }

    public GraphObject getSourceDataObject() {
        return this.sourceDataObject;
    }

    public void setListSource(Iterable<GraphObject> listSource) {
        this.listSource = listSource;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Iterable<GraphObject> getListSource() {
        return this.listSource;
    }

    public PropertyKey getRelatedProperty() {
        return this.relatedProperty;
    }

    public void setRelatedProperty(PropertyKey relatedProperty) {
        this.relatedProperty = relatedProperty;
    }

    public void pushSecurityContext(SecurityContext securityContext) {
        this.scStack.push(this.securityContext);
        this.securityContext = securityContext;
    }

    public void popSecurityContext() {
        if (!this.scStack.isEmpty()) {
            this.securityContext = this.scStack.pop();
        }
    }

    public EditMode getEditMode(Principal user) {
        return user == null ? EditMode.NONE : this.editMode;
    }

    public void setEditMode(EditMode edit) {
        this.editMode = edit;
    }

    public static EditMode editMode(String editString) {
        EditMode edit;
        switch (editString) {
            case "1": {
                edit = EditMode.WIDGET;
                break;
            }
            case "2": {
                edit = EditMode.CONTENT;
                break;
            }
            case "3": {
                edit = EditMode.RAW;
                break;
            }
            case "4": {
                edit = EditMode.DEPLOYMENT;
                break;
            }
            default: {
                edit = EditMode.NONE;
            }
        }
        return edit;
    }

    public String getISO3Country() {
        return this.getLocale().getISO3Country();
    }

    public String getISO3Language() {
        return this.getLocale().getISO3Language();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void increaseDepth() {
        ++this.depth;
    }

    public void decreaseDepth() {
        --this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setBuffer(AsyncBuffer buffer) {
        this.buffer = buffer;
    }

    public AsyncBuffer getBuffer() {
        return this.buffer;
    }

    public void setInBody(boolean inBody) {
        this.inBody = inBody;
    }

    public boolean inBody() {
        return this.inBody;
    }

    public void setAppLibRendered(boolean appLibRendered) {
        this.appLibRendered = appLibRendered;
    }

    public boolean appLibRendered() {
        return this.appLibRendered;
    }

    public GraphObject getDataNode(String key) {
        return this.dataObjects.get(key);
    }

    public void putDataObject(String key, GraphObject currentDataObject) {
        this.dataObjects.put(key, currentDataObject);
        this.setDataObject(currentDataObject);
    }

    public void clearDataObject(String key) {
        this.dataObjects.remove(key);
        this.setDataObject(null);
    }

    public boolean hasDataForKey(String key) {
        return this.dataObjects.containsKey(key);
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public Page getPage() {
        return this.page;
    }

    public String getPageId() {
        return this.page != null ? this.page.getUuid() : null;
    }

    public Result getResult() {
        return this.result;
    }

    public void setAnyChildNodeCreatesNewLine(boolean anyChildNodeCreatesNewLine) {
        this.anyChildNodeCreatesNewLine = anyChildNodeCreatesNewLine;
    }

    public boolean getAnyChildNodeCreatesNewLine() {
        return this.anyChildNodeCreatesNewLine;
    }

    public boolean returnRawValue() {
        EditMode editMode = this.getEditMode(this.securityContext.getUser(false));
        return EditMode.RAW.equals((Object)editMode) || EditMode.WIDGET.equals((Object)editMode);
    }

    public Object evaluate(GraphObject entity, String key, Object data, String defaultValue, int depth) throws FrameworkException {
        if (depth == 0 && this.hasDataForKey(key)) {
            return this.getDataNode(key);
        }
        Object value = super.evaluate(entity, key, data, defaultValue, depth);
        if (value == null) {
            if (data != null) {
                switch (key) {
                    case "link": {
                        ResourceLink rel;
                        if (!(data instanceof AbstractNode) || (rel = (ResourceLink)((AbstractNode)data).getOutgoingRelationship(ResourceLink.class)) == null) break;
                        return rel.getTargetNode();
                    }
                }
            } else {
                switch (key) {
                    case "id": {
                        GraphObject detailsObject = this.getDetailsDataObject();
                        if (detailsObject != null) {
                            return detailsObject.getUuid();
                        }
                        if (defaultValue == null) break;
                        return Function.numberOrString((String)defaultValue);
                    }
                    case "current": {
                        return this.getDetailsDataObject();
                    }
                    case "template": {
                        if (!(entity instanceof DOMNode)) break;
                        return ((DOMNode)entity).getClosestTemplate(this.getPage());
                    }
                    case "page": {
                        return this.getPage();
                    }
                    case "parent": {
                        if (!(entity instanceof DOMNode)) break;
                        return ((DOMNode)entity).getParentNode();
                    }
                    case "children": {
                        if (!(entity instanceof DOMNode)) break;
                        return ((DOMNode)entity).getChildNodes();
                    }
                    case "link": {
                        ResourceLink rel;
                        if (!(entity instanceof NodeInterface) || (rel = (ResourceLink)((NodeInterface)entity).getOutgoingRelationship(ResourceLink.class)) == null) break;
                        return rel.getTargetNode();
                    }
                    case "result_count": 
                    case "result_size": {
                        Result sizeResult = this.getResult();
                        if (sizeResult == null) break;
                        return sizeResult.getRawResultCount();
                    }
                    case "page_size": {
                        Result pageSizeResult = this.getResult();
                        if (pageSizeResult == null) break;
                        return pageSizeResult.getPageSize();
                    }
                    case "page_count": {
                        Result pageCountResult = this.getResult();
                        if (pageCountResult == null) break;
                        Integer pageCount = this.result.getPageCount();
                        if (pageCount != null) {
                            return pageCount;
                        }
                        return 1;
                    }
                    case "page_no": {
                        Result pageNoResult = this.getResult();
                        if (pageNoResult == null) break;
                        return pageNoResult.getPage();
                    }
                }
            }
        }
        return value;
    }

    private void readConfigParameters() {
        this.indentHtml = (Boolean)Settings.HtmlIndentation.getValue();
    }

    public boolean shouldIndentHtml() {
        return this.indentHtml;
    }

    public static enum EditMode {
        NONE,
        WIDGET,
        CONTENT,
        RAW,
        DEPLOYMENT;

    }
}

