/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.common.microformat;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.NodeVisitor;

public class MicroformatParser {
    public List<Map<String, Object>> parse(String source, String selector) {
        LinkedList<Map<String, Object>> objects = new LinkedList<Map<String, Object>>();
        for (Element element : Jsoup.parse((String)source).select(selector)) {
            this.unwrap(element);
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            this.recurse(element, values, 0);
            objects.add(values);
        }
        return objects;
    }

    private void recurse(Element element, Map<String, Object> values, int depth) {
        block8: {
            Object content;
            String link;
            Set classes;
            Tag tag;
            block9: {
                tag = element.tag();
                classes = element.classNames();
                link = element.attr("href");
                content = this.extractChildContent(element);
                if (classes.isEmpty()) break block8;
                this.removeEmpty(classes);
                if (!tag.isBlock()) break block9;
                if (depth == 0) {
                    values.put("type", classes);
                    for (Element child : element.children()) {
                        this.recurse(child, values, depth + 1);
                    }
                } else {
                    LinkedHashMap<String, Object> childMap = new LinkedHashMap<String, Object>();
                    values.put((String)classes.iterator().next(), childMap);
                    if (content != null) {
                        childMap.put("name", content);
                    }
                    for (Element child : element.children()) {
                        this.recurse(child, childMap, depth + 1);
                    }
                }
                break block8;
            }
            if (!tag.isInline()) break block8;
            if (classes.contains("url") && StringUtils.isNotBlank((CharSequence)link)) {
                values.put("url", link);
                classes.remove("url");
            }
            if (content != null) {
                for (String type : classes) {
                    values.put(type, content);
                }
            }
        }
    }

    private void removeEmpty(Set<String> source) {
        Iterator<String> it = source.iterator();
        while (it.hasNext()) {
            if (!StringUtils.isBlank((CharSequence)it.next())) continue;
            it.remove();
        }
    }

    private void unwrap(Element element) {
        final LinkedHashSet elementsToUnwrap = new LinkedHashSet();
        element.traverse(new NodeVisitor(){

            public void head(Node node, int depth) {
                Element element;
                if (node instanceof Element && (element = (Element)node).isBlock()) {
                    Set classes = element.classNames();
                    MicroformatParser.this.removeEmpty(classes);
                    if (classes.isEmpty()) {
                        elementsToUnwrap.add(element);
                    }
                }
            }

            public void tail(Node node, int depth) {
            }
        });
        for (Element unwrap : elementsToUnwrap) {
            unwrap.unwrap();
        }
    }

    private Object extractChildContent(Element element) {
        String ownText;
        final LinkedList<String> parts = new LinkedList<String>();
        element.traverse(new NodeVisitor(){

            public void head(Node node, int depth) {
                if (node instanceof Element) {
                    Element element = (Element)node;
                    Set classes = element.classNames();
                    MicroformatParser.this.removeEmpty(classes);
                    if (classes.isEmpty()) {
                        parts.add(element.ownText());
                    }
                }
            }

            public void tail(Node node, int depth) {
            }
        });
        if (parts.isEmpty() && StringUtils.isNotBlank((CharSequence)(ownText = element.ownText()))) {
            parts.add(element.ownText());
        }
        if (parts.isEmpty()) {
            return null;
        }
        if (parts.size() == 1) {
            return parts.get(0);
        }
        return parts;
    }
}

