/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.datasource;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.Value;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.rest.ResourceProvider;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.resource.Resource;
import org.structr.rest.servlet.ResourceHelper;
import org.structr.web.common.GraphDataSource;
import org.structr.web.common.RenderContext;
import org.structr.web.common.UiResourceProvider;
import org.structr.web.entity.dom.DOMNode;

public class RestDataSource
implements GraphDataSource<Iterable<GraphObject>> {
    private static final Logger logger = LoggerFactory.getLogger((String)RestDataSource.class.getName());

    @Override
    public Iterable<GraphObject> getData(RenderContext renderContext, AbstractNode referenceNode) throws FrameworkException {
        String restQuery = ((DOMNode)referenceNode).getPropertyWithVariableReplacement(renderContext, (PropertyKey)DOMNode.restQuery);
        if (restQuery == null || restQuery.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.getData(renderContext, restQuery);
    }

    public List<GraphObject> getData(RenderContext renderContext, final String restQuery) throws FrameworkException {
        LinkedHashMap resourceMap = new LinkedHashMap();
        SecurityContext securityContext = renderContext.getSecurityContext();
        ResourceProvider resourceProvider = renderContext.getResourceProvider();
        if (resourceProvider == null) {
            try {
                resourceProvider = (ResourceProvider)UiResourceProvider.class.newInstance();
            }
            catch (Throwable t) {
                logger.error("Couldn't establish a resource provider", t);
                return Collections.EMPTY_LIST;
            }
        }
        resourceMap.putAll(resourceProvider.getResources());
        ThreadLocalPropertyView propertyView = new ThreadLocalPropertyView();
        propertyView.set(securityContext, "ui");
        HttpServletRequest request = securityContext.getRequest();
        if (request == null) {
            request = renderContext.getRequest();
        }
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public Enumeration<String> getParameterNames() {
                return new IteratorEnumeration(this.getParameterMap().keySet().iterator());
            }

            public String getParameter(String key) {
                String[] p = this.getParameterMap().get(key);
                return p != null ? p[0] : null;
            }

            public String[] getParameterValues(String key) {
                return this.getParameterMap().get(key);
            }

            public Map<String, String[]> getParameterMap() {
                String[] parts = StringUtils.split((String)this.getQueryString(), (String)"&");
                HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
                for (String p : parts) {
                    String[] kv = StringUtils.split((String)p, (String)"=");
                    if (kv.length <= 1) continue;
                    parameterMap.put(kv[0], new String[]{kv[1]});
                }
                return parameterMap;
            }

            public String getQueryString() {
                return StringUtils.substringAfter((String)restQuery, (String)"?");
            }

            public String getPathInfo() {
                return StringUtils.substringBefore((String)restQuery, (String)"?");
            }

            public StringBuffer getRequestURL() {
                return new StringBuffer(restQuery);
            }
        };
        HttpServletRequest origRequest = securityContext.getRequest();
        securityContext.setRequest((HttpServletRequest)wrappedRequest);
        Resource resource = null;
        try {
            resource = ResourceHelper.applyViewTransformation((HttpServletRequest)wrappedRequest, (SecurityContext)securityContext, (Resource)ResourceHelper.optimizeNestedResourceChain((SecurityContext)securityContext, (HttpServletRequest)wrappedRequest, resourceMap, (Value)propertyView), (Value)propertyView);
        }
        catch (IllegalPathException | NotFoundException e) {
            logger.warn("Illegal path for REST query: {}", (Object)restQuery);
        }
        securityContext.setRequest(origRequest);
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        securityContext.ignoreResultCount(true);
        String pageSizeParameter = wrappedRequest.getParameter("pageSize");
        String pageParameter = wrappedRequest.getParameter("page");
        String offsetId = wrappedRequest.getParameter("pageStartId");
        String sortOrder = wrappedRequest.getParameter("order");
        String sortKeyName = wrappedRequest.getParameter("sort");
        boolean sortDescending = sortOrder != null && "desc".equals(sortOrder.toLowerCase());
        int pageSize = RestDataSource.parseInt(pageSizeParameter, Integer.MAX_VALUE);
        int page = RestDataSource.parseInt(pageParameter, 1);
        PropertyKey sortKey = null;
        if (sortKeyName != null) {
            Class<AbstractNode> type = resource.getEntityClass();
            if (type == null) {
                type = AbstractNode.class;
            }
            sortKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(type, sortKeyName, false);
        }
        Result result = Result.EMPTY_RESULT;
        try {
            result = resource.doGet(sortKey, sortDescending, pageSize, page, offsetId);
        }
        catch (NotFoundException nfe) {
            logger.warn("No result from internal REST query: {}", (Object)restQuery);
        }
        result.setIsCollection(resource.isCollectionResource());
        result.setIsPrimitiveArray(resource.isPrimitiveArray());
        PagingHelper.addPagingParameter((Result)result, (int)pageSize, (int)page);
        List res = result.getResults();
        renderContext.setResult(result);
        return res != null ? res : Collections.EMPTY_LIST;
    }

    private static int parseInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    private static class ThreadLocalPropertyView
    extends ThreadLocal<String>
    implements Value<String> {
        private ThreadLocalPropertyView() {
        }

        @Override
        protected String initialValue() {
            return "ui";
        }

        public void set(SecurityContext securityContext, String value) {
            this.set(value);
        }

        public String get(SecurityContext securityContext) {
            return (String)this.get();
        }
    }
}

