/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.cmis.CMISInfo;
import org.structr.cmis.info.CMISDocumentInfo;
import org.structr.cmis.info.CMISFolderInfo;
import org.structr.cmis.info.CMISItemInfo;
import org.structr.cmis.info.CMISPolicyInfo;
import org.structr.cmis.info.CMISRelationshipInfo;
import org.structr.cmis.info.CMISSecondaryInfo;
import org.structr.common.AccessMode;
import org.structr.common.Permission;
import org.structr.common.ResultTransformer;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.common.fulltext.FulltextIndexer;
import org.structr.common.fulltext.Indexable;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.JsonInput;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Favoritable;
import org.structr.core.entity.Principal;
import org.structr.core.function.Functions;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StartNodes;
import org.structr.core.property.StringProperty;
import org.structr.core.script.Scripting;
import org.structr.files.cmis.config.StructrFileActions;
import org.structr.module.StructrModule;
import org.structr.module.api.APIBuilder;
import org.structr.rest.common.CsvHelper;
import org.structr.rest.common.XMLHandler;
import org.structr.rest.common.XMLStructureAnalyzer;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.schema.action.JavaScriptSource;
import org.structr.web.common.FileHelper;
import org.structr.web.common.ImageHelper;
import org.structr.web.common.RenderContext;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.AbstractMinifiedFile;
import org.structr.web.entity.Folder;
import org.structr.web.entity.Image;
import org.structr.web.entity.Linkable;
import org.structr.web.entity.User;
import org.structr.web.entity.relation.Folders;
import org.structr.web.entity.relation.MinificationSource;
import org.structr.web.entity.relation.UserFavoriteFile;
import org.structr.web.property.FileDataProperty;

public class FileBase
extends AbstractFile
implements Indexable,
Linkable,
JavaScriptSource,
CMISInfo,
CMISDocumentInfo,
Favoritable {
    private static final Logger logger = LoggerFactory.getLogger((String)FileBase.class.getName());
    public static final Property<String> relativeFilePath = new StringProperty("relativeFilePath").systemInternal();
    public static final Property<Long> size = new LongProperty("size").indexed().systemInternal();
    public static final Property<String> url = new StringProperty("url");
    public static final Property<Long> checksum = new LongProperty("checksum").indexed().unvalidated().systemInternal();
    public static final Property<Integer> cacheForSeconds = new IntProperty("cacheForSeconds").cmis();
    public static final Property<Integer> version = new IntProperty("version").indexed().systemInternal();
    public static final Property<String> base64Data = new FileDataProperty("base64Data");
    public static final Property<Boolean> isFile = new ConstantBooleanProperty("isFile", true);
    public static final Property<List<AbstractMinifiedFile>> minificationTargets = new StartNodes("minificationTarget", MinificationSource.class);
    public static final Property<List<User>> favoriteOfUsers = new StartNodes("favoriteOfUsers", UserFavoriteFile.class);
    public static final Property<Boolean> isTemplate = new BooleanProperty("isTemplate");
    public static final View publicView = new View(FileBase.class, "public", new Property[]{type, name, size, url, owner, path, isFile, visibleToPublicUsers, visibleToAuthenticatedUsers, includeInFrontendExport, isFavoritable, isTemplate});
    public static final View uiView = new View(FileBase.class, "ui", new Property[]{type, relativeFilePath, size, url, parent, checksum, version, cacheForSeconds, owner, isFile, hasParent, includeInFrontendExport, isFavoritable, isTemplate});

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.onCreation(securityContext, errorBuffer)) {
            Folder workingOrHomeDir;
            PropertyMap changedProperties = new PropertyMap();
            if (((Boolean)Settings.FilesystemEnabled.getValue()).booleanValue() && !((Boolean)this.getProperty((PropertyKey)AbstractFile.hasParent)).booleanValue() && (workingOrHomeDir = this.getCurrentWorkingDir()) != null && this.getProperty((PropertyKey)AbstractFile.parent) == null) {
                changedProperties.put(AbstractFile.parent, (Object)workingOrHomeDir);
            }
            changedProperties.put((PropertyKey)hasParent, (Object)(this.getProperty((PropertyKey)parentId) != null ? 1 : 0));
            this.setProperties(securityContext, changedProperties);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            FileBase fileBase = this;
            synchronized (fileBase) {
                SecurityContext previousSecurityContext = securityContext;
                this.securityContext = SecurityContext.getSuperUserInstance();
                this.setProperties(this.securityContext, new PropertyMap((PropertyKey)hasParent, (Object)(this.getProperty((PropertyKey)parentId) != null ? 1 : 0)));
                this.securityContext = previousSecurityContext;
            }
            this.triggerMinificationIfNeeded(modificationQueue);
            return true;
        }
        return false;
    }

    public void onNodeCreation() {
        String uuid = this.getUuid();
        String filePath = FileBase.getDirectoryPath(uuid) + "/" + uuid;
        try {
            this.unlockSystemPropertiesOnce();
            this.setProperties(this.securityContext, new PropertyMap(relativeFilePath, (Object)filePath));
        }
        catch (Throwable t) {
            logger.warn("Exception while trying to set relative file path {}: {}", new Object[]{filePath, t});
        }
    }

    public void onNodeDeletion() {
        String filePath = null;
        try {
            File toDelete;
            String path = this.getRelativeFilePath();
            if (path != null && (toDelete = new File(filePath = FileHelper.getFilePath(path))).exists() && toDelete.isFile()) {
                toDelete.delete();
            }
        }
        catch (Throwable t) {
            logger.debug("Exception while trying to delete file {}: {}", new Object[]{filePath, t});
        }
    }

    public void afterCreation(SecurityContext securityContext) {
        try {
            String filesPath = (String)Settings.FilesPath.getValue();
            File fileOnDisk = new File(filesPath + "/" + this.getRelativeFilePath());
            if (fileOnDisk.exists()) {
                return;
            }
            fileOnDisk.getParentFile().mkdirs();
            try {
                fileOnDisk.createNewFile();
            }
            catch (IOException ex) {
                logger.error("Could not create file", (Throwable)ex);
                return;
            }
            PropertyMap changedProperties = new PropertyMap();
            changedProperties.put(checksum, (Object)FileHelper.getChecksum(this));
            changedProperties.put(version, (Object)0);
            long fileSize = FileHelper.getSize(this);
            if (fileSize > 0L) {
                changedProperties.put(size, (Object)fileSize);
            }
            this.unlockSystemPropertiesOnce();
            this.setProperties(securityContext, changedProperties);
        }
        catch (FrameworkException ex) {
            logger.error("Could not create file", (Throwable)ex);
        }
    }

    @Override
    public String getPath() {
        return FileHelper.getFolderPath(this);
    }

    @Export
    public GraphObject getSearchContext(String searchTerm, int contextLength) {
        String text = (String)this.getProperty((PropertyKey)extractedContent);
        if (text != null) {
            FulltextIndexer indexer = StructrApp.getInstance((SecurityContext)this.securityContext).getFulltextIndexer(new Object[0]);
            return indexer.getContextObject(searchTerm, text, contextLength);
        }
        return null;
    }

    public void notifyUploadCompletion() {
        try {
            FulltextIndexer indexer = StructrApp.getInstance((SecurityContext)this.securityContext).getFulltextIndexer(new Object[0]);
            indexer.addToFulltextIndex((Indexable)this);
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to index " + this, (Throwable)fex);
        }
    }

    public String getRelativeFilePath() {
        return (String)this.getProperty((PropertyKey)relativeFilePath);
    }

    public String getUrl() {
        return (String)this.getProperty((PropertyKey)url);
    }

    public String getContentType() {
        return (String)this.getProperty((PropertyKey)contentType);
    }

    public Long getSize() {
        return (Long)this.getProperty((PropertyKey)size);
    }

    public Long getChecksum() {
        return (Long)this.getProperty((PropertyKey)checksum);
    }

    public String getFormattedSize() {
        return FileUtils.byteCountToDisplaySize((long)this.getSize());
    }

    public static String getDirectoryPath(String uuid) {
        return uuid != null ? uuid.substring(0, 1) + "/" + uuid.substring(1, 2) + "/" + uuid.substring(2, 3) + "/" + uuid.substring(3, 4) : null;
    }

    public void increaseVersion() throws FrameworkException {
        Integer _version = (Integer)this.getProperty((PropertyKey)version);
        this.unlockSystemPropertiesOnce();
        if (_version == null) {
            this.setProperties(this.securityContext, new PropertyMap(version, (Object)1));
        } else {
            this.setProperties(this.securityContext, new PropertyMap(version, (Object)(_version + 1)));
        }
    }

    public void triggerMinificationIfNeeded(ModificationQueue modificationQueue) throws FrameworkException {
        List targets = (List)this.getProperty((PropertyKey)minificationTargets);
        if (!targets.isEmpty()) {
            boolean versionChanged = false;
            for (ModificationEvent modState : modificationQueue.getModificationEvents()) {
                if (!this.getUuid().equals(modState.getUuid())) continue;
                versionChanged = versionChanged || modState.getRemovedProperties().containsKey(version) || modState.getModifiedProperties().containsKey(version) || modState.getNewProperties().containsKey(version);
            }
            if (versionChanged) {
                for (AbstractMinifiedFile minifiedFile : targets) {
                    try {
                        minifiedFile.minify();
                    }
                    catch (IOException ex) {
                        logger.warn("Could not automatically update minification target: ".concat(minifiedFile.getName()), (Throwable)ex);
                    }
                }
            }
        }
    }

    public InputStream getInputStream() {
        String relativeFilePath = this.getRelativeFilePath();
        if (relativeFilePath != null) {
            String filePath = FileHelper.getFilePath(relativeFilePath);
            FileInputStream fis = null;
            try {
                File fileOnDisk = new File(filePath);
                fis = new FileInputStream(fileOnDisk);
                if (((Boolean)this.getProperty((PropertyKey)isTemplate)).booleanValue()) {
                    String editParameter;
                    boolean userIsAdmin = false;
                    Principal requestingUser = this.securityContext.getUser(false);
                    if (requestingUser != null) {
                        userIsAdmin = (Boolean)requestingUser.getProperty((PropertyKey)Principal.isAdmin);
                    }
                    boolean editModeActive = false;
                    if (this.securityContext.getRequest() != null && (editParameter = this.securityContext.getRequest().getParameter("edit")) != null) {
                        boolean bl = editModeActive = !RenderContext.EditMode.NONE.equals((Object)RenderContext.editMode(editParameter));
                    }
                    if (!userIsAdmin || userIsAdmin && !editModeActive) {
                        String content = IOUtils.toString((InputStream)fis, (String)"UTF-8");
                        try {
                            String result = Scripting.replaceVariables((ActionContext)new ActionContext(this.securityContext), (GraphObject)this, (Object)content);
                            return IOUtils.toInputStream((String)result, (String)"UTF-8");
                        }
                        catch (Throwable t) {
                            logger.warn("Scripting error in {}:\n{}", new Object[]{this.getUuid(), content, t});
                        }
                    }
                }
                return fis;
            }
            catch (FileNotFoundException e) {
                logger.debug("File not found: {}", new Object[]{relativeFilePath});
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(FileBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public FileOutputStream getOutputStream() {
        return this.getOutputStream(true, false);
    }

    public FileOutputStream getOutputStream(final boolean notifyIndexerAfterClosing, boolean append) {
        String path = this.getRelativeFilePath();
        if (path != null) {
            String filePath = FileHelper.getFilePath(path);
            try {
                File fileOnDisk = new File(filePath);
                fileOnDisk.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(fileOnDisk, append){
                    private boolean closed;
                    {
                        super(x0, x1);
                        this.closed = false;
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        try (Tx tx = StructrApp.getInstance().tx();){
                            super.close();
                            String _contentType = FileHelper.getContentMimeType(FileBase.this);
                            PropertyMap changedProperties = new PropertyMap();
                            changedProperties.put(checksum, (Object)FileHelper.getChecksum(FileBase.this));
                            changedProperties.put(size, (Object)FileHelper.getSize(FileBase.this));
                            changedProperties.put((PropertyKey)Indexable.contentType, (Object)_contentType);
                            if (StringUtils.startsWith((CharSequence)_contentType, (CharSequence)"image") || ImageHelper.isImageType((String)FileBase.this.getProperty((PropertyKey)NodeInterface.name))) {
                                changedProperties.put((PropertyKey)NodeInterface.type, (Object)Image.class.getSimpleName());
                            }
                            FileBase.this.unlockSystemPropertiesOnce();
                            FileBase.this.setProperties(FileBase.this.securityContext, changedProperties);
                            FileBase.this.increaseVersion();
                            if (notifyIndexerAfterClosing) {
                                FileBase.this.notifyUploadCompletion();
                            }
                            tx.success();
                        }
                        catch (Throwable ex) {
                            logger.error("Could not determine or save checksum and size after closing file output stream", ex);
                        }
                        this.closed = true;
                    }
                };
                return fos;
            }
            catch (FileNotFoundException e) {
                logger.error("File not found: {}", (Object)path);
            }
        }
        return null;
    }

    public File getFileOnDisk() {
        String path = this.getRelativeFilePath();
        if (path != null) {
            return new File(FileHelper.getFilePath(path));
        }
        return null;
    }

    public Path getPathOnDisk() {
        String path = this.getRelativeFilePath();
        if (path != null) {
            return Paths.get(FileHelper.getFilePath(path), new String[0]);
        }
        return null;
    }

    @Export
    public Map<String, Object> getFirstLines(Map<String, Object> parameters) {
        String separator;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        LineAndSeparator ls = this.getFirstLines(this.getNumberOrDefault(parameters, "num", 3));
        switch (separator = ls.getSeparator()) {
            case "\n": {
                result.put("separator", "LF");
                break;
            }
            case "\r": {
                result.put("separator", "CR");
                break;
            }
            case "\r\n": {
                result.put("separator", "CR+LF");
            }
        }
        result.put("lines", ls.getLine());
        return result;
    }

    @Export
    public Map<String, Object> getCSVHeaders(Map<String, Object> parameters) throws FrameworkException {
        if ("text/csv".equals(this.getProperty((PropertyKey)contentType))) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Function func = Functions.get((String)"get_csv_headers");
            if (func != null) {
                try {
                    Object[] sources = new Object[4];
                    String delimiter = ";";
                    String quoteChar = "\"";
                    String recordSeparator = "\n";
                    if (parameters != null) {
                        if (parameters.containsKey("delimiter")) {
                            delimiter = parameters.get("delimiter").toString();
                        }
                        if (parameters.containsKey("quoteChar")) {
                            quoteChar = parameters.get("quoteChar").toString();
                        }
                        if (parameters.containsKey("recordSeparator")) {
                            recordSeparator = parameters.get("recordSeparator").toString();
                        }
                    }
                    switch (recordSeparator) {
                        case "CR+LF": {
                            recordSeparator = "\r\n";
                            break;
                        }
                        case "CR": {
                            recordSeparator = "\r";
                            break;
                        }
                        case "LF": {
                            recordSeparator = "\n";
                            break;
                        }
                        case "TAB": {
                            recordSeparator = "\t";
                        }
                    }
                    sources[0] = this.getFirstLines(1).getLine();
                    sources[1] = delimiter;
                    sources[2] = quoteChar;
                    sources[3] = recordSeparator;
                    map.put("headers", func.apply(new ActionContext(this.securityContext), null, sources));
                }
                catch (UnlicensedException ex) {
                    logger.warn("CSV module is not available.");
                }
            }
            return map;
        }
        throw new FrameworkException(400, "File format is not CSV");
    }

    @Export
    public void doCSVImport(Map<String, Object> parameters) throws FrameworkException {
        Map importMappings = (Map)parameters.get("mappings");
        Map transforms = (Map)parameters.get("transforms");
        String targetType = (String)parameters.get("targetType");
        String delimiter = (String)parameters.get("delimiter");
        String quoteChar = (String)parameters.get("quoteChar");
        if (targetType != null && delimiter != null && quoteChar != null) {
            logger.info("Importing CSV from {} to {} using {}", new Object[]{this.getUuid(), targetType, parameters});
            StructrModule module = (StructrModule)StructrApp.getConfiguration().getModules().get("api-builder");
            if (module != null && module instanceof APIBuilder) {
                APIBuilder builder = (APIBuilder)module;
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHMM");
                String importTypeName = "ImportFromCsv" + df.format(System.currentTimeMillis());
                this.startNewThread(() -> {
                    SecurityContext threadContext = SecurityContext.getInstance((Principal)this.securityContext.getUser(false), (AccessMode)AccessMode.Backend);
                    App app = StructrApp.getInstance((SecurityContext)threadContext);
                    try (InputStream is = this.getInputStream();){
                        ResultTransformer mapper = builder.createMapping(app, targetType, importTypeName, importMappings, transforms);
                        Class targetEntityType = StructrApp.getConfiguration().getNodeEntityClass(targetType);
                        char fieldSeparator = delimiter.charAt(0);
                        char quoteCharacter = quoteChar.charAt(0);
                        Iterable iterable = CsvHelper.cleanAndParseCSV((SecurityContext)threadContext, (Reader)new InputStreamReader(is, "utf-8"), (Class)targetEntityType, (char)fieldSeparator, (char)quoteCharacter, this.reverse(importMappings));
                        Iterator iterator = iterable.iterator();
                        int batchSize = 1000;
                        int chunks = 0;
                        while (iterator.hasNext()) {
                            int count = 0;
                            Tx tx = app.tx();
                            Throwable throwable = null;
                            try {
                                while (iterator.hasNext() && count++ < 1000) {
                                    JsonInput input = (JsonInput)iterator.next();
                                    mapper.transformInput(threadContext, targetEntityType, (Map)input);
                                    app.create(targetEntityType, PropertyMap.inputTypeToJavaType((SecurityContext)threadContext, (Class)targetEntityType, (Map)input));
                                }
                                tx.success();
                                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                                data.put("type", "CSV_IMPORT_STATUS");
                                data.put("title", "CSV Import Status");
                                data.put("text", "Finished importing chunk " + ++chunks);
                                data.put("username", threadContext.getUser(false).getName());
                                TransactionCommand.simpleBroadcast((String)"GENERIC_MESSAGE", data);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (tx == null) continue;
                                if (throwable != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                tx.close();
                            }
                        }
                        builder.removeMapping(app, targetType, importTypeName);
                        logger.info("CSV: Finished importing csv data.");
                        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                        data.put("type", "CSV_IMPORT_STATUS");
                        data.put("title", "CSV Import Done");
                        data.put("text", "Finished importing csv data.");
                        data.put("username", threadContext.getUser(false).getName());
                        TransactionCommand.simpleBroadcast((String)"GENERIC_MESSAGE", data);
                    }
                    catch (IOException | FrameworkException fex) {
                        fex.printStackTrace();
                    }
                }, false);
            } else {
                logger.warn("API builder module is not available.");
            }
        } else {
            throw new FrameworkException(400, "Cannot import CSV, please specify target type.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Export
    public String getXMLStructure() throws FrameworkException {
        String contentType = (String)this.getProperty((PropertyKey)FileBase.contentType);
        if (!"text/xml".equals(contentType)) {
            if (!"application/xml".equals(contentType)) return null;
        }
        try (InputStreamReader input = new InputStreamReader(this.getInputStream());){
            XMLStructureAnalyzer analyzer = new XMLStructureAnalyzer((Reader)input);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String string = gson.toJson((Object)analyzer.getStructure(100));
            return string;
        }
        catch (IOException | XMLStreamException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Export
    public void doXMLImport(Map<String, Object> config) throws FrameworkException {
        String contentType = (String)this.getProperty((PropertyKey)FileBase.contentType);
        if ("text/xml".equals(contentType) || "application/xml".equals(contentType)) {
            logger.info("Importing XML from {}..", (Object)this.getUuid());
            this.startNewThread(() -> {
                SecurityContext threadContext = SecurityContext.getInstance((Principal)this.securityContext.getUser(false), (AccessMode)AccessMode.Backend);
                App app = StructrApp.getInstance((SecurityContext)threadContext);
                int overallCount = 0;
                try (InputStreamReader reader = new InputStreamReader(this.getInputStream());){
                    XMLHandler iterator = new XMLHandler(config, (Reader)reader);
                    int batchSize = 100;
                    int chunks = 0;
                    while (iterator.hasNext()) {
                        int count = 0;
                        Tx tx = app.tx();
                        Throwable throwable = null;
                        try {
                            while (iterator.hasNext() && ++count <= 100) {
                                PropertyMap map = PropertyMap.inputTypeToJavaType((SecurityContext)threadContext, (Map)((Map)iterator.next()));
                                app.create(AbstractNode.class, map);
                                ++overallCount;
                            }
                            tx.success();
                            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                            data.put("type", "XML_IMPORT_STATUS");
                            data.put("title", "XML Import Status");
                            data.put("text", "Finished importing chunk " + ++chunks);
                            data.put("username", threadContext.getUser(false).getName());
                            TransactionCommand.simpleBroadcast((String)"GENERIC_MESSAGE", data);
                            logger.info("XML: Imported {} objects, commiting batch.", (Object)overallCount);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                        }
                    }
                    logger.info("XML: Finished importing XML data.");
                    LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                    data.put("type", "XML_IMPORT_STATUS");
                    data.put("title", "XML Import Done");
                    data.put("text", "Finished importing XML data.");
                    data.put("username", threadContext.getUser(false).getName());
                    TransactionCommand.simpleBroadcast((String)"GENERIC_MESSAGE", data);
                }
                catch (IOException | XMLStreamException | FrameworkException fex) {
                    System.out.println(fex.toString());
                    System.out.println(fex.getMessage());
                    fex.printStackTrace();
                }
            }, false);
        } else {
            logger.warn("Cannot import XML from file with content type {}", (Object)contentType);
        }
    }

    private Folder getCurrentWorkingDir() {
        Principal _owner = (Principal)this.getProperty((PropertyKey)owner);
        Folder workingOrHomeDir = null;
        if (_owner != null && _owner instanceof User && (workingOrHomeDir = (Folder)((Object)_owner.getProperty(User.workingDirectory))) == null) {
            workingOrHomeDir = (Folder)((Object)_owner.getProperty(User.homeDirectory));
        }
        return workingOrHomeDir;
    }

    private int getNumberOrDefault(Map<String, Object> data, String key, int defaultValue) {
        Object value = data.get(key);
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                try {
                    return Integer.valueOf((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    private LineAndSeparator getFirstLines(int num) {
        StringBuilder lines = new StringBuilder();
        int[] separator = new int[10];
        int separatorLength = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(), "utf-8"));){
            for (int count = 0; count < num; ++count) {
                int[] buf = new int[10010];
                int ch = reader.read();
                int i = 0;
                separatorLength = 0;
                while (ch != 10 && ch != 13 && i < 10000) {
                    buf[i++] = ch;
                    ch = reader.read();
                }
                while (separatorLength < 2 && (ch == 10 || ch == 13)) {
                    separator[separatorLength++] = ch;
                    ch = reader.read();
                }
                buf[i++] = 10;
                lines.append(new String(buf, 0, i));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return new LineAndSeparator(lines.toString(), new String(separator, 0, separatorLength));
    }

    private void startNewThread(Runnable runnable, boolean wait) {
        Thread worker = new Thread(runnable);
        worker.start();
        if (wait) {
            try {
                worker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Map<String, String> reverse(Map<String, String> input) {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            output.put(entry.getValue(), entry.getKey());
        }
        return output;
    }

    public List<GraphObject> getSyncData() throws FrameworkException {
        List data = super.getSyncData();
        data.add(this.getProperty((PropertyKey)parent));
        data.add(this.getIncomingRelationship(Folders.class));
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJavascriptLibraryCode() {
        try (InputStream is = this.getInputStream();){
            String string = IOUtils.toString((InputStream)is);
            return string;
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
            return null;
        }
    }

    public CMISInfo getCMISInfo() {
        return this;
    }

    public BaseTypeId getBaseTypeId() {
        return BaseTypeId.CMIS_DOCUMENT;
    }

    public CMISFolderInfo getFolderInfo() {
        return null;
    }

    public CMISDocumentInfo getDocumentInfo() {
        return this;
    }

    public CMISItemInfo geItemInfo() {
        return null;
    }

    public CMISRelationshipInfo getRelationshipInfo() {
        return null;
    }

    public CMISPolicyInfo getPolicyInfo() {
        return null;
    }

    public CMISSecondaryInfo getSecondaryInfo() {
        return null;
    }

    public String getParentId() {
        return (String)this.getProperty((PropertyKey)parentId);
    }

    public AllowableActions getAllowableActions() {
        return new StructrFileActions(this.isImmutable());
    }

    public String getChangeToken() {
        return null;
    }

    public boolean isImmutable() {
        Principal _owner = this.getOwnerNode();
        if (_owner != null) {
            return !_owner.isGranted(Permission.write, this.securityContext);
        }
        return true;
    }

    public String getContext() {
        return (String)this.getProperty((PropertyKey)path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getFavoriteContent() {
        try (InputStream is = this.getInputStream();){
            String string = IOUtils.toString((InputStream)is);
            return string;
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
            return null;
        }
    }

    public String getFavoriteContentType() {
        return this.getContentType();
    }

    public void setFavoriteContent(String content) throws FrameworkException {
        try (FileOutputStream os = this.getOutputStream(true, false);){
            IOUtils.write((String)content, (OutputStream)os, (Charset)Charset.defaultCharset());
            os.flush();
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private class LineAndSeparator {
        private String line = null;
        private String separator = null;

        public LineAndSeparator(String line, String separator) {
            this.line = line;
            this.separator = separator;
        }

        public String getLine() {
            return this.line;
        }

        public String getSeparator() {
            return this.separator;
        }
    }
}

