/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.dom;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.common.AccessControllable;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.CreateNodeCommand;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.notion.Notion;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.RelationProperty;
import org.structr.core.property.StartNode;
import org.structr.core.property.StartNodes;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaService;
import org.structr.web.common.RenderContext;
import org.structr.web.common.StringRenderBuffer;
import org.structr.web.diff.InvertibleModificationOperation;
import org.structr.web.entity.Linkable;
import org.structr.web.entity.Site;
import org.structr.web.entity.dom.Cdata;
import org.structr.web.entity.dom.Comment;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMAttribute;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.DOMNodeList;
import org.structr.web.entity.dom.DocumentFragment;
import org.structr.web.entity.dom.Html5DocumentType;
import org.structr.web.entity.dom.Template;
import org.structr.web.entity.html.Html;
import org.structr.web.entity.html.relation.ResourceLink;
import org.structr.web.entity.relation.PageLink;
import org.structr.web.entity.relation.Pages;
import org.structr.web.importer.Importer;
import org.structr.web.property.UiNotion;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class Page
extends DOMNode
implements Linkable,
Document,
DOMImplementation {
    public static final Set<String> nonBodyTags = new HashSet<String>(Arrays.asList("html", "head", "body", "meta", "link"));
    private static final Logger logger = LoggerFactory.getLogger((String)Page.class.getName());
    public static final Property<Integer> version = new IntProperty("version").indexed().readOnly();
    public static final Property<Integer> position = new IntProperty("position").indexed();
    public static final Property<String> contentType = new StringProperty("contentType").indexed();
    public static final Property<Integer> cacheForSeconds = new IntProperty("cacheForSeconds");
    public static final Property<String> showOnErrorCodes = new StringProperty("showOnErrorCodes").indexed();
    public static final Property<List<DOMNode>> elements = new StartNodes("elements", PageLink.class);
    public static final Property<Boolean> isPage = new ConstantBooleanProperty("isPage", true);
    public static final Property<Boolean> dontCache = new BooleanProperty("dontCache").defaultValue((Object)false);
    public static final Property<String> category = new StringProperty("category").indexed();
    public static final Property<Boolean> pageCreatesRawData = new BooleanProperty("pageCreatesRawData").defaultValue((Object)false);
    public static final Property<String> path = new StringProperty("path").indexed();
    public static final Property<Site> site = new StartNode("site", Pages.class, (Notion)new UiNotion()).indexedWhenEmpty();
    public static final View publicView = new View(Page.class, "public", new Property[]{path, children, linkingElements, contentType, owner, cacheForSeconds, version, position, showOnErrorCodes, isPage, site, dontCache, pageCreatesRawData, enableBasicAuth, basicAuthRealm, category});
    public static final View uiView = new View(Page.class, "ui", new Property[]{path, children, linkingElements, contentType, owner, cacheForSeconds, version, position, showOnErrorCodes, isPage, site, dontCache, pageCreatesRawData, enableBasicAuth, basicAuthRealm, category});
    public static final View categoryView = new View(Page.class, "category", new Property[]{category});
    private Html5DocumentType docTypeNode = new Html5DocumentType(this);

    @Override
    public boolean contentEquals(DOMNode otherNode) {
        return false;
    }

    @Override
    public String getContextName() {
        return (String)this.getProperty((PropertyKey)name);
    }

    @Override
    public void updateFromNode(DOMNode newNode) throws FrameworkException {
    }

    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean valid = super.isValid(errorBuffer);
        valid &= this.nonEmpty(AbstractNode.name, errorBuffer);
        return valid &= ValidationHelper.isValidStringMatchingRegex((GraphObject)this, (PropertyKey)name, (String)"[_\\p{L}0-9\\s\\-\\.]+", (ErrorBuffer)errorBuffer);
    }

    public static Page createNewPage(SecurityContext securityContext, String name) throws FrameworkException {
        return Page.createNewPage(securityContext, null, name);
    }

    public static Page createNewPage(SecurityContext securityContext, String uuid, String name) throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        PropertyMap properties = new PropertyMap();
        properties.put((PropertyKey)AbstractNode.name, (Object)(name != null ? name : "page"));
        properties.put((PropertyKey)AbstractNode.type, (Object)Page.class.getSimpleName());
        properties.put(contentType, (Object)"text/html");
        properties.put((PropertyKey)hideOnDetail, (Object)false);
        properties.put((PropertyKey)hideOnIndex, (Object)false);
        properties.put((PropertyKey)enableBasicAuth, (Object)false);
        if (uuid != null) {
            properties.put((PropertyKey)id, (Object)uuid);
        }
        return (Page)app.create(Page.class, properties);
    }

    public static Page createSimplePage(SecurityContext securityContext, String name) throws FrameworkException {
        Page page = Page.createNewPage(securityContext, name);
        if (page != null) {
            Element html = page.createElement("html");
            Element head = page.createElement("head");
            Element body = page.createElement("body");
            Element title = page.createElement("title");
            Element h1 = page.createElement("h1");
            Element div = page.createElement("div");
            try {
                page.appendChild(html);
                html.appendChild(head);
                html.appendChild(body);
                head.appendChild(title);
                body.appendChild(h1);
                body.appendChild(div);
                title.appendChild(page.createTextNode("${capitalize(page.name)}"));
                h1.appendChild(page.createTextNode("${capitalize(page.name)}"));
                div.appendChild(page.createTextNode("Initial body text"));
            }
            catch (DOMException dex) {
                logger.warn("", (Throwable)dex);
                throw new FrameworkException(422, dex.getMessage());
            }
        }
        return page;
    }

    @Override
    protected void checkHierarchy(Node otherNode) throws DOMException {
        if (this.getDocumentElement() != null) {
            throw new DOMException(3, "A document may only have one html element.");
        }
        if (!(otherNode instanceof Html || otherNode instanceof org.w3c.dom.Comment || otherNode instanceof Template)) {
            throw new DOMException(3, "A document may only accept an html element as its document element.");
        }
        super.checkHierarchy(otherNode);
    }

    @Override
    public boolean hasChildNodes() {
        return true;
    }

    @Override
    public NodeList getChildNodes() {
        DOMNodeList _children = new DOMNodeList();
        _children.add(this.docTypeNode);
        _children.addAll(super.getChildNodes());
        return _children;
    }

    @Override
    public Node getFirstChild() {
        return this.docTypeNode;
    }

    public void increaseVersion() throws FrameworkException {
        Integer _version = (Integer)this.getProperty((PropertyKey)version);
        this.unlockReadOnlyPropertiesOnce();
        if (_version == null) {
            this.setProperties(this.securityContext, new PropertyMap(version, (Object)1));
        } else {
            this.setProperties(this.securityContext, new PropertyMap(version, (Object)(_version + 1)));
        }
    }

    @Override
    public Element createElement(String tag) throws DOMException {
        return this.createElement(tag, false);
    }

    public Element createElement(String tag, boolean suppressException) {
        block4: {
            String elementType = StringUtils.capitalize((String)tag);
            App app = StructrApp.getInstance((SecurityContext)this.securityContext);
            String c = Content.class.getSimpleName();
            if (elementType == null || c.equals(elementType)) {
                logger.warn("Blocked attempt to create a DOMElement of type {}", (Object)c);
                return null;
            }
            Page _page = this;
            try {
                Class<?> entityClass = Class.forName("org.structr.web.entity.html." + elementType);
                if (entityClass != null) {
                    DOMElement element = (DOMElement)app.create(entityClass, new NodeAttribute[]{new NodeAttribute(DOMElement.tag, (Object)tag), new NodeAttribute((PropertyKey)DOMElement.hideOnDetail, (Object)false), new NodeAttribute((PropertyKey)DOMElement.hideOnIndex, (Object)false)});
                    element.doAdopt(_page);
                    return element;
                }
            }
            catch (Throwable t) {
                if (suppressException) break block4;
                logger.error("Unable to instantiate element of type " + elementType, t);
            }
        }
        return null;
    }

    @Override
    protected void handleNewChild(Node newChild) {
        for (DOMNode child : this.getAllChildNodes()) {
            try {
                child.setProperties(this.securityContext, new PropertyMap((PropertyKey)ownerDocument, (Object)this));
            }
            catch (FrameworkException ex) {
                logger.warn("", (Throwable)ex);
            }
        }
    }

    @Override
    public org.w3c.dom.DocumentFragment createDocumentFragment() {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try {
            DocumentFragment fragment = (DocumentFragment)app.create(DocumentFragment.class, new NodeAttribute[0]);
            ((RelationProperty)elements).addSingleElement(this.securityContext, (GraphObject)this, (Object)fragment);
            return fragment;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            return null;
        }
    }

    @Override
    public Text createTextNode(String text) {
        try {
            Content content = (Content)((CreateNodeCommand)StructrApp.getInstance((SecurityContext)this.securityContext).command(CreateNodeCommand.class)).execute(new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.type, (Object)Content.class.getSimpleName()), new NodeAttribute((PropertyKey)Content.hideOnDetail, (Object)false), new NodeAttribute((PropertyKey)Content.hideOnIndex, (Object)false), new NodeAttribute(Content.content, (Object)text)});
            ((RelationProperty)elements).addSingleElement(this.securityContext, (GraphObject)this, (Object)content);
            return content;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            return null;
        }
    }

    @Override
    public org.w3c.dom.Comment createComment(String comment) {
        try {
            Comment commentNode = (Comment)((CreateNodeCommand)StructrApp.getInstance((SecurityContext)this.securityContext).command(CreateNodeCommand.class)).execute(new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.type, (Object)Comment.class.getSimpleName()), new NodeAttribute(Content.content, (Object)comment)});
            ((RelationProperty)elements).addSingleElement(this.securityContext, (GraphObject)this, (Object)commentNode);
            return commentNode;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            return null;
        }
    }

    @Override
    public CDATASection createCDATASection(String string) throws DOMException {
        try {
            Cdata content = (Cdata)((CreateNodeCommand)StructrApp.getInstance((SecurityContext)this.securityContext).command(CreateNodeCommand.class)).execute(new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.type, (Object)Cdata.class.getSimpleName())});
            ((RelationProperty)elements).addSingleElement(this.securityContext, (GraphObject)this, (Object)content);
            return content;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            return null;
        }
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string1) throws DOMException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return new DOMAttribute(this, null, name, null);
    }

    @Override
    public EntityReference createEntityReference(String string) throws DOMException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Element createElementNS(String string, String string1) throws DOMException {
        throw new UnsupportedOperationException("Namespaces not supported");
    }

    @Override
    public Attr createAttributeNS(String string, String string1) throws DOMException {
        throw new UnsupportedOperationException("Namespaces not supported");
    }

    @Override
    public Node importNode(Node node, boolean deep) throws DOMException {
        return this.importNode(node, deep, true);
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        return this.adoptNode(node, true);
    }

    private Node adoptNode(Node node, boolean removeParentFromSourceNode) throws DOMException {
        if (node instanceof DOMNode) {
            Node _parent;
            DOMNode domNode = (DOMNode)node;
            if (domNode.hasChildNodes()) {
                for (Node child = domNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.adoptNode(child, false);
                }
            }
            if (removeParentFromSourceNode && (_parent = domNode.getParentNode()) != null) {
                _parent.removeChild(domNode);
            }
            Node adoptedNode = domNode.doAdopt(this);
            return adoptedNode;
        }
        return null;
    }

    @Override
    public void normalizeDocument() {
        this.normalize();
    }

    @Override
    public Node renameNode(Node node, String string, String string1) throws DOMException {
        throw new DOMException(9, "Renaming of nodes is not supported by this implementation.");
    }

    @Override
    public DocumentType createDocumentType(String string, String string1, String string2) throws DOMException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Document createDocument(String string, String string1, DocumentType dt) throws DOMException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getContent(RenderContext.EditMode editMode) throws FrameworkException {
        RenderContext ctx = new RenderContext(this.securityContext, null, null, editMode);
        StringRenderBuffer buffer = new StringRenderBuffer();
        ctx.setBuffer(buffer);
        this.render(ctx, 0);
        return buffer.getBuffer().toString();
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public DOMImplementation getImplementation() {
        return this;
    }

    @Override
    public Element getDocumentElement() {
        Node node = super.getFirstChild();
        if (node instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getElementById(final String id) {
        DOMNodeList results = new DOMNodeList();
        this.collectNodesByPredicate(this, results, new Predicate<Node>(){

            public boolean accept(Node obj) {
                DOMElement elem;
                return obj instanceof DOMElement && id.equals((elem = (DOMElement)obj).getProperty((PropertyKey)DOMElement._id));
            }
        }, 0, true);
        if (results.getLength() == 1) {
            return (DOMElement)results.item(0);
        }
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return "UTF-8";
    }

    @Override
    public boolean getXmlStandalone() {
        return true;
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public boolean getStrictErrorChecking() {
        return true;
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        return new Html5DocumentType(this);
    }

    @Override
    public void render(RenderContext renderContext, int depth) throws FrameworkException {
        renderContext.setPage(this);
        DOMNode subNode = (DOMNode)this.getFirstChild().getNextSibling();
        if (subNode == null) {
            subNode = (DOMNode)super.getFirstChild();
        } else {
            renderContext.getBuffer().append("<!DOCTYPE html>\n");
        }
        while (subNode != null) {
            if (subNode.isNotDeleted() && this.securityContext.isVisible((AccessControllable)subNode)) {
                subNode.render(renderContext, depth);
            }
            subNode = (DOMNode)subNode.getNextSibling();
        }
    }

    @Override
    public void renderContent(RenderContext renderContext, int depth) throws FrameworkException {
    }

    @Override
    public boolean hasFeature(String string, String string1) {
        return false;
    }

    @Override
    public boolean isSynced() {
        return false;
    }

    @Override
    public void setXmlStandalone(boolean bln) throws DOMException {
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
    }

    @Override
    public void setStrictErrorChecking(boolean bln) {
    }

    @Override
    public void setDocumentURI(String string) {
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public NodeList getElementsByTagName(final String tagName) {
        DOMNodeList results = new DOMNodeList();
        this.collectNodesByPredicate(this, results, new Predicate<Node>(){

            public boolean accept(Node obj) {
                DOMElement elem;
                return obj instanceof DOMElement && tagName.equals((elem = (DOMElement)obj).getProperty((PropertyKey)DOMElement.tag));
            }
        }, 0, false);
        return results;
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String tagName) {
        throw new UnsupportedOperationException("Namespaces not supported.");
    }

    @Override
    public Node doAdopt(Page page) throws DOMException {
        throw new DOMException(9, "Document nodes cannot be adopted by another document.");
    }

    @Override
    public Node doImport(Page newPage) throws DOMException {
        throw new DOMException(9, "Document nodes cannot be imported into another document.");
    }

    @Override
    public String getPath() {
        return (String)this.getProperty((PropertyKey)path);
    }

    @Export
    public void diff(String file) throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            FileInputStream fis = new FileInputStream(file);
            String source = IOUtils.toString((InputStream)fis);
            Page diffPage = Importer.parsePageFromSource(this.securityContext, source, (String)this.getProperty((PropertyKey)name) + "diff");
            LinkedList<InvertibleModificationOperation> changeSet = new LinkedList<InvertibleModificationOperation>();
            fis.close();
            changeSet.addAll(Importer.diffNodes(this, diffPage));
            for (InvertibleModificationOperation op : changeSet) {
                System.out.println(op);
                op.apply(app, this, diffPage);
            }
            for (DOMNode child : (List)diffPage.getProperty((PropertyKey)elements)) {
                app.delete((NodeInterface)child);
            }
            app.delete((NodeInterface)diffPage);
            tx.success();
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
    }

    @Override
    public List<GraphObject> getSyncData() throws FrameworkException {
        List<GraphObject> data = super.getSyncData();
        data.addAll((Collection)this.getProperty((PropertyKey)Linkable.linkingElements));
        for (ResourceLink link : this.getRelationships(ResourceLink.class)) {
            data.add((GraphObject)link);
        }
        return data;
    }

    private Node importNode(Node node, boolean deep, boolean removeParentFromSourceNode) throws DOMException {
        if (node instanceof DOMNode) {
            Node _parent;
            DOMNode domNode = (DOMNode)node;
            Node importedNode = domNode.doImport(this);
            if (deep && domNode.hasChildNodes()) {
                for (Node child = domNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.importNode(child, deep, false);
                    logger.info("sibling is {}", (Object)child);
                }
            }
            if (removeParentFromSourceNode && (_parent = domNode.getParentNode()) != null) {
                _parent.removeChild(domNode);
            }
            return importedNode;
        }
        return null;
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"Page", (String)Page.class.getName());
    }
}

