/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.web.common.RenderContext;
import org.structr.web.datasource.FunctionDataSource;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.dom.DOMNode;

public class IncludeFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_INCLUDE = "Usage: ${include(name)}. Example: ${include(\"Main Template\")}";
    public static final String ERROR_MESSAGE_INCLUDE_JS = "Usage: ${{Structr.include(name)}}. Example: ${{Structr.include(\"Main Template\")}}";

    public String getName() {
        return "include()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasMinLengthAndAllElementsNotNull(sources, 1) || !(sources[0] instanceof String)) {
                return null;
            }
            SecurityContext securityContext = ctx.getSecurityContext();
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            RenderContext innerCtx = new RenderContext((RenderContext)ctx);
            List nodeList = app.nodeQuery(DOMNode.class).andName((String)sources[0]).getAsList();
            DOMNode node = null;
            for (DOMNode n : nodeList) {
                if (n.inTrash() || n.getProperty((PropertyKey)DOMNode.sharedComponent) != null) continue;
                if (node == null) {
                    node = n;
                    continue;
                }
                return "Ambiguous node name \"" + (String)sources[0] + "\" (nodes found: " + StringUtils.join((Iterable)nodeList, (String)", ") + ")";
            }
            if (node != null) {
                if (sources.length == 3 && sources[1] instanceof Iterable && sources[2] instanceof String) {
                    Iterable<GraphObject> iterable = FunctionDataSource.map((Iterable)sources[1]);
                    String dataKey = (String)sources[2];
                    innerCtx.setListSource(iterable);
                    node.renderNodeList(securityContext, innerCtx, 0, dataKey);
                } else {
                    node.render(innerCtx, 0);
                }
            } else {
                FileBase file = (FileBase)app.nodeQuery(FileBase.class).andName((String)sources[0]).getFirst();
                if (file != null) {
                    String name = (String)file.getProperty((PropertyKey)NodeInterface.name);
                    String contentType = (String)file.getProperty((PropertyKey)FileBase.contentType);
                    String charset = StringUtils.substringAfterLast((String)contentType, (String)"charset=");
                    String extension = StringUtils.substringAfterLast((String)name, (String)".");
                    if (contentType == null || StringUtils.isBlank((CharSequence)extension)) {
                        logger.warn("No valid file type detected. Please make sure {} has a valid content type set or file extension. Parameters: {}", new Object[]{name, this.getParametersAsString(sources)});
                        return "No valid file type detected. Please make sure " + name + " has a valid content type set or file extension.";
                    }
                    if (contentType.startsWith("text/css")) {
                        return "<link href=\"" + file.getPath() + "\" rel=\"stylesheet\">";
                    }
                    if (contentType.contains("/javascript")) {
                        return "<script src=\"" + file.getPath() + "\"></script>";
                    }
                    if (contentType.startsWith("image/svg")) {
                        try {
                            byte[] buffer = new byte[file.getSize().intValue()];
                            IOUtils.read((InputStream)file.getInputStream(), (byte[])buffer);
                            return StringUtils.toEncodedString((byte[])buffer, (Charset)Charset.forName(charset));
                        }
                        catch (IOException ex) {
                            logger.warn("Exception for parameters: {}", (Object)this.getParametersAsString(sources));
                            logger.error("", (Throwable)ex);
                            return "<img alt=\"" + name + "\" src=\"" + file.getPath() + "\">";
                        }
                    }
                    if (contentType.startsWith("image/")) {
                        return "<img alt=\"" + name + "\" src=\"" + file.getPath() + "\">";
                    }
                    logger.warn("Don't know how to render content type or extension of {}. Parameters: {}", new Object[]{name, this.getParametersAsString(sources)});
                    return "Don't know how to render content type or extension of  " + name + ".";
                }
            }
            return StringUtils.join(innerCtx.getBuffer().getQueue(), (String)"");
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_INCLUDE_JS : ERROR_MESSAGE_INCLUDE;
    }

    public String shortDescription() {
        return "Includes the content of the node with the given name";
    }
}

