/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.MailHelper;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.structr.web.entity.FileBase;

public class SendHtmlMailFunction
extends Function<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger((String)SendHtmlMailFunction.class.getName());
    public static final String ERROR_MESSAGE_SEND_HTML_MAIL = "Usage: ${send_html_mail(fromAddress, fromName, toAddress, toName, subject, content[, textContent][, files])}.";

    public String getName() {
        return "send_html_mail()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 6, 8)) {
            String from = sources[0].toString();
            String fromName = sources[1].toString();
            String to = sources[2].toString();
            String toName = sources[3].toString();
            String subject = sources[4].toString();
            String htmlContent = sources[5].toString();
            String textContent = "";
            if (sources.length >= 7) {
                textContent = sources[6].toString();
            }
            List fileNodes = null;
            ArrayList<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
            try {
                if (sources.length == 8 && sources[7] instanceof List && ((List)sources[7]).size() > 0 && ((List)sources[7]).get(0) instanceof FileBase) {
                    fileNodes = (List)sources[7];
                    for (FileBase fileNode : fileNodes) {
                        EmailAttachment attachment = new EmailAttachment();
                        attachment.setURL(fileNode.getFileOnDisk().toURI().toURL());
                        attachment.setName((String)fileNode.getProperty((PropertyKey)FileBase.name));
                        attachment.setDisposition("attachment");
                        attachments.add(attachment);
                    }
                }
                return MailHelper.sendHtmlMail((String)from, (String)fromName, (String)to, (String)toName, null, null, (String)from, (String)subject, (String)htmlContent, (String)textContent, attachments.isEmpty() ? null : attachments.toArray(new EmailAttachment[attachments.size()]));
            }
            catch (MalformedURLException | EmailException ex) {
                this.logException(caller, ex, sources);
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return "";
    }

    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SEND_HTML_MAIL;
    }

    public String shortDescription() {
        return "Sends an HTML e-mail";
    }
}

