/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.importer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.CaseHelper;
import org.structr.common.PathHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.rest.common.HttpHelper;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.Actions;
import org.structr.schema.importer.GraphGistImporter;
import org.structr.schema.importer.SchemaJsonImporter;
import org.structr.web.common.FileHelper;
import org.structr.web.common.ImageHelper;
import org.structr.web.diff.CreateOperation;
import org.structr.web.diff.DeleteOperation;
import org.structr.web.diff.InvertibleModificationOperation;
import org.structr.web.diff.MoveOperation;
import org.structr.web.diff.UpdateOperation;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.Image;
import org.structr.web.entity.LinkSource;
import org.structr.web.entity.Linkable;
import org.structr.web.entity.dom.Comment;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.Template;
import org.structr.web.entity.html.Body;
import org.structr.web.entity.html.Head;
import org.structr.web.entity.html.Input;
import org.structr.web.importer.CommentHandler;
import org.structr.web.maintenance.DeployCommand;
import org.structr.websocket.command.CreateComponentCommand;

public class Importer {
    private static final Logger logger = LoggerFactory.getLogger((String)Importer.class.getName());
    private static final Set<String> hrefElements = new LinkedHashSet<String>(Arrays.asList("link"));
    private static final Set<String> ignoreElementNames = new LinkedHashSet<String>(Arrays.asList("#declaration", "#doctype"));
    private static final Set<String> srcElements = new LinkedHashSet<String>(Arrays.asList("img", "script", "audio", "video", "input", "source", "track"));
    private static final Map<String, String> contentTypeForExtension = new HashMap<String, String>();
    private static App app;
    private static ConfigurationProvider config;
    private static final String DATA_STRUCTR_PREFIX = "data-structr-";
    private static final String DATA_META_PREFIX = "data-structr-meta-";
    private final StringBuilder commentSource = new StringBuilder();
    private final SecurityContext securityContext;
    private final boolean publicVisible;
    private final boolean authVisible;
    private CommentHandler commentHandler;
    private boolean isDeployment = false;
    private Document parsedDocument = null;
    private final String name;
    private URL originalUrl;
    private String address;
    private String code;
    private Map<String, Linkable> alreadyDownloaded = new HashMap<String, Linkable>();

    public Importer(SecurityContext securityContext, String code, String address, String name, boolean publicVisible, boolean authVisible) {
        this.code = code;
        this.address = address;
        this.name = name;
        this.securityContext = securityContext;
        this.publicVisible = publicVisible;
        this.authVisible = authVisible;
        config = StructrApp.getConfiguration();
        if (address != null && !address.endsWith("/") && !address.endsWith(".html")) {
            this.address = this.address.concat("/");
        }
        if (this.address != null) {
            try {
                this.originalUrl = new URL(this.address);
            }
            catch (MalformedURLException ex) {
                logger.info("Cannot convert '{}' to URL - is the protocol ok? Trying to resume anyway...", (Object)this.address);
            }
        }
    }

    private void init() {
        app = StructrApp.getInstance((SecurityContext)this.securityContext);
    }

    public void setCommentHandler(CommentHandler handler) {
        this.commentHandler = handler;
    }

    public boolean parse() throws FrameworkException {
        return this.parse(false);
    }

    public boolean parse(boolean fragment) throws FrameworkException {
        this.init();
        if (StringUtils.isNotBlank((CharSequence)this.code)) {
            if (!this.isDeployment) {
                logger.info("##### Start parsing code for page {} #####", new Object[]{this.name});
            } else {
                this.code = this.code.replaceAll("<(area|base|br|col|command|embed|hr|img|input|keygen|link|meta|param|source|track|wbr)([^>]*)>", "<$1$2/>");
            }
            if (fragment) {
                if (this.isDeployment) {
                    List nodeList = Parser.parseXmlFragment((String)this.code, (String)"");
                    this.parsedDocument = Document.createShell((String)"");
                    Element body = this.parsedDocument.body();
                    Node[] nodes = nodeList.toArray(new Node[nodeList.size()]);
                    for (int i = nodes.length - 1; i > 0; --i) {
                        nodes[i].remove();
                    }
                    for (Node node : nodes) {
                        body.appendChild(node);
                    }
                } else {
                    this.parsedDocument = Jsoup.parseBodyFragment((String)this.code);
                }
            } else {
                this.parsedDocument = this.isDeployment ? Jsoup.parse((String)this.code, (String)"", (Parser)Parser.xmlParser()) : Jsoup.parse((String)this.code);
            }
        } else {
            if (!this.isDeployment) {
                logger.info("##### Start fetching {} for page {} #####", new Object[]{this.address, this.name});
            }
            this.code = HttpHelper.get((String)this.address);
            this.parsedDocument = Jsoup.parse((String)this.code);
        }
        return true;
    }

    public Page readPage() throws FrameworkException {
        return this.readPage(null);
    }

    public Page readPage(String uuid) throws FrameworkException {
        Page page = Page.createNewPage(this.securityContext, uuid, this.name);
        if (page != null) {
            PropertyMap changedProperties = new PropertyMap();
            changedProperties.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)this.authVisible);
            changedProperties.put((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)this.publicVisible);
            page.setProperties(this.securityContext, changedProperties);
            this.createChildNodes((Node)this.parsedDocument, (DOMNode)page, page);
            if (!this.isDeployment) {
                logger.info("##### Finished fetching {} for page {} #####", new Object[]{this.address, this.name});
            }
        }
        return page;
    }

    public DOMNode createComponentChildNodes(Page page) throws FrameworkException {
        return this.createComponentChildNodes(null, page);
    }

    public DOMNode createComponentChildNodes(DOMNode parent, Page page) throws FrameworkException {
        Element head = this.parsedDocument.head();
        Element body = this.parsedDocument.body();
        if (head != null && !head.html().isEmpty()) {
            Head headElement = (Head)page.createElement("head");
            this.createChildNodes((Node)head, headElement, page);
            return headElement;
        }
        if (body != null && !body.html().isEmpty()) {
            return this.createChildNodes((Node)body, parent, page);
        }
        return this.createChildNodes((Node)this.parsedDocument, parent, page);
    }

    public DOMNode createChildNodes(DOMNode parent, Page page) throws FrameworkException {
        return this.createChildNodes((Node)this.parsedDocument.body(), parent, page);
    }

    public void createChildNodes(DOMNode parent, Page page, boolean removeHashAttribute) throws FrameworkException {
        this.createChildNodes((Node)this.parsedDocument.body(), parent, page, removeHashAttribute, 0);
    }

    public void createChildNodesWithHtml(DOMNode parent, Page page, boolean removeHashAttribute) throws FrameworkException {
        this.createChildNodes((Node)this.parsedDocument, parent, page, removeHashAttribute, 0);
    }

    public void importDataComments() throws FrameworkException {
        GraphGistImporter importer = (GraphGistImporter)app.command(GraphGistImporter.class);
        byte[] data = this.commentSource.toString().getBytes();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        List sources = importer.extractSources((InputStream)bis);
        importer.importCypher(sources);
    }

    public void setIsDeployment(boolean isDeployment) {
        this.isDeployment = isDeployment;
    }

    public static Page parsePageFromSource(SecurityContext securityContext, String source, String name) throws FrameworkException {
        return Importer.parsePageFromSource(securityContext, source, name, false);
    }

    public static Page parsePageFromSource(SecurityContext securityContext, String source, String name, boolean removeHashAttribute) throws FrameworkException {
        Importer importer = new Importer(securityContext, source, null, "source", false, false);
        App localAppCtx = StructrApp.getInstance((SecurityContext)securityContext);
        Page page = null;
        try (Tx tx = localAppCtx.tx(true, false, false);){
            page = (Page)localAppCtx.create(Page.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)Page.name, (Object)name)});
            if (importer.parse()) {
                importer.createChildNodesWithHtml(page, page, removeHashAttribute);
            }
            tx.success();
        }
        return page;
    }

    public static List<InvertibleModificationOperation> diffNodes(DOMNode sourceNode, DOMNode modifiedNode) {
        if (sourceNode == null) {
            logger.warn("Source node was null, returning empty change set.");
            return Collections.EMPTY_LIST;
        }
        if (modifiedNode == null) {
            logger.warn("Modified node was null, returning empty change set.");
            return Collections.EMPTY_LIST;
        }
        LinkedList<InvertibleModificationOperation> changeSet = new LinkedList<InvertibleModificationOperation>();
        LinkedHashMap<String, DOMNode> indexMappedExistingNodes = new LinkedHashMap<String, DOMNode>();
        LinkedHashMap<String, DOMNode> hashMappedExistingNodes = new LinkedHashMap<String, DOMNode>();
        LinkedHashMap<DOMNode, Integer> depthMappedExistingNodes = new LinkedHashMap<DOMNode, Integer>();
        LinkedHashMap<String, DOMNode> indexMappedNewNodes = new LinkedHashMap<String, DOMNode>();
        LinkedHashMap<String, DOMNode> hashMappedNewNodes = new LinkedHashMap<String, DOMNode>();
        LinkedHashMap<DOMNode, Integer> depthMappedNewNodes = new LinkedHashMap<DOMNode, Integer>();
        InvertibleModificationOperation.collectNodes(sourceNode, indexMappedExistingNodes, hashMappedExistingNodes, depthMappedExistingNodes);
        InvertibleModificationOperation.collectNodes(modifiedNode, indexMappedNewNodes, hashMappedNewNodes, depthMappedNewNodes);
        for (Map.Entry existingNodeEntry : hashMappedExistingNodes.entrySet()) {
            DOMNode existingNode = (DOMNode)existingNodeEntry.getValue();
            String existingHash = existingNode.getIdHash();
            if (hashMappedNewNodes.containsKey(existingHash) || existingNode instanceof Page) continue;
            changeSet.add(new DeleteOperation(hashMappedExistingNodes, existingNode));
        }
        for (Map.Entry newNodeEntry : indexMappedNewNodes.entrySet()) {
            DOMNode newNode = (DOMNode)newNodeEntry.getValue();
            String newHash = (String)newNode.getProperty((PropertyKey)DOMNode.dataHashProperty);
            if (newHash == null) {
                newHash = newNode.getIdHash();
            }
            if (hashMappedExistingNodes.containsKey(newHash) || newNode instanceof Page) continue;
            DOMNode newParent = (DOMNode)newNode.getProperty((PropertyKey)DOMNode.parent);
            changeSet.add(new CreateOperation(hashMappedExistingNodes, Importer.getHashOrNull(newParent), Importer.getSiblingHashes(newNode), newNode, (Integer)depthMappedNewNodes.get(newNode)));
        }
        for (Map.Entry newNodeEntry : indexMappedNewNodes.entrySet()) {
            String newTreeIndex = (String)newNodeEntry.getKey();
            DOMNode newNode = (DOMNode)newNodeEntry.getValue();
            for (Map.Entry existingNodeEntry : indexMappedExistingNodes.entrySet()) {
                String existingTreeIndex = (String)existingNodeEntry.getKey();
                DOMNode existingNode = (DOMNode)existingNodeEntry.getValue();
                DOMNode newParent = null;
                int equalityBitmask = 0;
                if (newTreeIndex.equals(existingTreeIndex)) {
                    equalityBitmask |= 1;
                }
                if (newNode.getIdHashOrProperty().equals(existingNode.getIdHash())) {
                    equalityBitmask |= 2;
                }
                if (newNode.contentEquals(existingNode)) {
                    equalityBitmask |= 4;
                }
                switch (equalityBitmask) {
                    case 7: {
                        break;
                    }
                    case 6: {
                        newParent = (DOMNode)newNode.getProperty((PropertyKey)DOMNode.parent);
                        changeSet.add(new MoveOperation(hashMappedExistingNodes, Importer.getHashOrNull(newParent), Importer.getSiblingHashes(newNode), newNode, existingNode));
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 3: {
                        changeSet.add(new UpdateOperation(hashMappedExistingNodes, existingNode, newNode));
                        break;
                    }
                    case 2: {
                        newParent = (DOMNode)newNode.getProperty((PropertyKey)DOMNode.parent);
                        changeSet.add(new UpdateOperation(hashMappedExistingNodes, existingNode, newNode));
                        changeSet.add(new MoveOperation(hashMappedExistingNodes, Importer.getHashOrNull(newParent), Importer.getSiblingHashes(newNode), newNode, existingNode));
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
            }
        }
        return changeSet;
    }

    private static List<String> getSiblingHashes(DOMNode node) {
        LinkedList<String> siblingHashes = new LinkedList<String>();
        for (DOMNode nextSibling = (DOMNode)node.getProperty((PropertyKey)DOMNode.nextSibling); nextSibling != null; nextSibling = (DOMNode)nextSibling.getProperty((PropertyKey)DOMNode.nextSibling)) {
            siblingHashes.add(nextSibling.getIdHashOrProperty());
        }
        return siblingHashes;
    }

    private static String getHashOrNull(DOMNode node) {
        if (node != null) {
            return node.getIdHashOrProperty();
        }
        return null;
    }

    private DOMNode createChildNodes(Node startNode, DOMNode parent, Page page) throws FrameworkException {
        return this.createChildNodes(startNode, parent, page, false, 0);
    }

    private DOMNode createChildNodes(Node startNode, DOMNode parent, Page page, boolean removeHashAttribute, int depth) throws FrameworkException {
        DOMNode rootElement = null;
        Linkable res = null;
        String instructions = null;
        List children = startNode.childNodes();
        for (Node node : children) {
            String src;
            String tag = node.nodeName();
            if (tag != null) {
                tag = tag.replaceAll("[^a-zA-Z0-9#:.-_]+", "");
            }
            StringBuilder classString = new StringBuilder();
            String type = CaseHelper.toUpperCamelCase((String)tag);
            String comment = null;
            String content = null;
            String id = null;
            boolean isNewTemplateOrComponent = false;
            if (ignoreElementNames.contains(type)) continue;
            if (node instanceof Element) {
                Element el = (Element)node;
                Set classes = el.classNames();
                for (String cls : classes) {
                    classString.append(cls).append(" ");
                }
                id = el.id();
                if (!this.isDeployment) {
                    String downloadAddressAttr;
                    String string = srcElements.contains(tag) ? "src" : (downloadAddressAttr = hrefElements.contains(tag) ? "href" : null);
                    if (downloadAddressAttr != null && StringUtils.isNotBlank((CharSequence)node.attr(downloadAddressAttr))) {
                        String downloadAddress = node.attr(downloadAddressAttr);
                        res = this.downloadFile(downloadAddress, this.originalUrl);
                    }
                }
                if (removeHashAttribute) {
                    node.removeAttr(DOMNode.dataHashProperty.jsonName());
                }
            }
            if (type.equals("#comment")) {
                comment = ((org.jsoup.nodes.Comment)node).getData();
                tag = "";
                if (StringUtils.isBlank((CharSequence)comment)) continue;
                this.commentSource.append(comment).append("\n");
                if (this.commentHandler != null && this.commentHandler.containsInstructions(comment)) {
                    if (instructions != null) {
                        this.createEmptyContentNode(page, parent, this.commentHandler, instructions);
                    }
                    instructions = comment;
                    continue;
                }
            } else if (type.equals("#data")) {
                tag = "";
                content = ((DataNode)node).getWholeData();
                if (StringUtils.isBlank((CharSequence)content)) {
                    continue;
                }
            } else if (type.equals("#text")) {
                tag = "";
                if (this.isDeployment ? (content = Importer.trimTrailingNewline(((TextNode)node).getWholeText())) == null || content.length() == 0 : StringUtils.isBlank((CharSequence)(content = Importer.trimTrailingNewline(((TextNode)node).text())))) continue;
            }
            DOMNode newNode = null;
            if (StringUtils.isBlank((CharSequence)tag)) {
                if (page != null) {
                    if (!StringUtils.isBlank((CharSequence)comment)) {
                        newNode = (DOMNode)((Object)page.createComment(comment));
                        newNode.setProperty((PropertyKey)Comment.contentType, "text/html");
                    } else {
                        newNode = (Content)page.createTextNode(content);
                    }
                }
            } else if ("structr:template".equals(tag)) {
                src = node.attr("src");
                if (src != null) {
                    DOMNode template = null;
                    if (DeployCommand.isUuid(src)) {
                        template = (DOMNode)StructrApp.getInstance().nodeQuery(NodeInterface.class).and((PropertyKey)GraphObject.id, (Object)src).getFirst();
                        if (template == null) {
                            System.out.println("##################################### template with UUID " + src + " not found, this is a known bug");
                        }
                    } else {
                        template = Importer.findSharedComponentByName(src);
                        if (template == null && (template = Importer.findTemplateByName(src)) == null) {
                            template = this.createNewTemplateNode(parent, node.childNodes());
                            isNewTemplateOrComponent = true;
                        }
                    }
                    if (template != null) {
                        newNode = template;
                        if (template.isSharedComponent()) {
                            newNode = (DOMNode)template.cloneNode(false);
                            newNode.setProperty((PropertyKey)DOMNode.sharedComponent, template);
                            newNode.setProperty((PropertyKey)DOMNode.ownerDocument, page);
                        } else if (page != null) {
                            newNode.setProperty((PropertyKey)DOMNode.ownerDocument, page);
                        }
                    } else {
                        logger.warn("Unable to find template or shared component {}, template ignored!", (Object)src);
                    }
                } else {
                    logger.warn("Invalid template definition, missing src attribute!");
                }
            } else if ("structr:component".equals(tag)) {
                src = node.attr("src");
                if (src != null) {
                    DOMNode component = null;
                    component = DeployCommand.isUuid(src) ? (DOMNode)app.nodeQuery(DOMNode.class).and((PropertyKey)GraphObject.id, (Object)src).getFirst() : Importer.findSharedComponentByName(src);
                    if (component == null) {
                        component = this.createSharedComponent(node);
                    }
                    isNewTemplateOrComponent = true;
                    if (component != null) {
                        newNode = (DOMNode)component.cloneNode(false);
                        newNode.setProperty((PropertyKey)DOMNode.sharedComponent, component);
                        newNode.setProperty((PropertyKey)DOMNode.ownerDocument, page);
                    } else {
                        logger.warn("Unable to find shared component {} - ignored!", (Object)src);
                    }
                } else {
                    logger.warn("Invalid component definition, missing src attribute!");
                }
            } else {
                if (page != null) {
                    newNode = (DOMElement)page.createElement(tag, true);
                }
                if (newNode == null && (newNode = (DOMElement)app.create(DOMElement.class, new NodeAttribute[]{new NodeAttribute(DOMElement.tag, (Object)node.nodeName()), new NodeAttribute((PropertyKey)DOMElement.hideOnDetail, (Object)false), new NodeAttribute((PropertyKey)DOMElement.hideOnIndex, (Object)false)})) != null && page != null) {
                    newNode.doAdopt(page);
                }
            }
            if (newNode == null) continue;
            if (rootElement == null && !(newNode instanceof Comment)) {
                rootElement = newNode;
            }
            if (res != null) {
                newNode.setProperty((PropertyKey)LinkSource.linkable, res);
            }
            PropertyMap newNodeProperties = new PropertyMap();
            Class<?> newNodeType = newNode.getClass();
            newNodeProperties.put((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)this.publicVisible);
            newNodeProperties.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)this.authVisible);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                newNodeProperties.put(DOMElement._id, (Object)id);
            }
            if (StringUtils.isNotBlank((CharSequence)classString.toString())) {
                newNodeProperties.put(DOMElement._class, (Object)StringUtils.trim((String)classString.toString()));
            }
            for (Attribute nodeAttr : node.attributes()) {
                boolean isStructrLib;
                String key = nodeAttr.getKey();
                if (key.equals("text")) continue;
                String value = nodeAttr.getValue();
                if (key.startsWith("data-")) {
                    if (key.startsWith(DATA_META_PREFIX)) {
                        int l = DATA_META_PREFIX.length();
                        String upperCaseKey = WordUtils.capitalize((String)key.substring(l), (char[])new char[]{'-'}).replaceAll("-", "");
                        String camelCaseKey = key.substring(l, l + 1).concat(upperCaseKey.substring(1));
                        if (value == null) continue;
                        PropertyKey actualKey = StructrApp.getConfiguration().getPropertyKeyForJSONName(newNodeType, camelCaseKey, false);
                        if (actualKey != null) {
                            PropertyConverter converter = actualKey.inputConverter(this.securityContext);
                            if (converter != null) {
                                Object convertedValue = converter.convert((Object)value);
                                newNodeProperties.put(actualKey, convertedValue);
                                continue;
                            }
                            newNodeProperties.put(actualKey, (Object)value);
                            continue;
                        }
                        logger.warn("Unknown meta property key {}, ignoring.", (Object)camelCaseKey);
                        continue;
                    }
                    if (key.startsWith(DATA_STRUCTR_PREFIX)) {
                        PropertyKey propertyKey = config.getPropertyKeyForJSONName(newNodeType, key);
                        if (propertyKey == null) continue;
                        PropertyConverter inputConverter = propertyKey.inputConverter(this.securityContext);
                        if (value != null && inputConverter != null) {
                            newNodeProperties.put(propertyKey, propertyKey.inputConverter(this.securityContext).convert((Object)value));
                            continue;
                        }
                        newNodeProperties.put(propertyKey, (Object)value);
                        continue;
                    }
                    StringProperty propertyKey = new StringProperty(key);
                    if (value == null) continue;
                    newNodeProperties.put((PropertyKey)propertyKey, (Object)value);
                    continue;
                }
                boolean notBlank = StringUtils.isNotBlank((CharSequence)value);
                boolean isAnchor = notBlank && value.startsWith("#");
                boolean isLocal = notBlank && !value.startsWith("http");
                boolean isActive = notBlank && value.contains("${");
                boolean bl = isStructrLib = notBlank && value.startsWith("/structr/js/");
                if ("link".equals(tag) && "href".equals(key) && isLocal && !isActive && !this.isDeployment) {
                    newNodeProperties.put((PropertyKey)new StringProperty("_html_".concat(key)), (Object)"${link.path}?${link.version}");
                    continue;
                }
                if (!(!"href".equals(key) && !"src".equals(key) || !isLocal || isActive || isAnchor || isStructrLib || this.isDeployment)) {
                    newNodeProperties.put((PropertyKey)new StringProperty("_html_".concat(key)), (Object)"${link.path}");
                    continue;
                }
                newNodeProperties.put((PropertyKey)new StringProperty("_html_".concat(key)), (Object)value);
            }
            newNode.setProperties(this.securityContext, newNodeProperties);
            if ("script".equals(tag)) {
                String source;
                String contentType = (String)newNode.getProperty((PropertyKey)Input._type);
                if (contentType == null) {
                    newNode.setProperty((PropertyKey)Input._type, "text/javascript");
                } else if (contentType.equals("application/schema+json")) {
                    for (Node scriptContentNode : node.childNodes()) {
                        source = scriptContentNode.toString();
                        SchemaJsonImporter.importSchemaJson((String)source);
                    }
                } else {
                    if (contentType.equals("application/x-cypher")) {
                        for (Node scriptContentNode : node.childNodes()) {
                            source = scriptContentNode.toString();
                            GraphGistImporter importer = (GraphGistImporter)app.command(GraphGistImporter.class);
                            ArrayList<String> sources = new ArrayList<String>();
                            sources.add(source);
                            importer.importCypher(sources);
                        }
                        continue;
                    }
                    if (contentType.equals("application/x-structr-script")) {
                        for (Node scriptContentNode : node.childNodes()) {
                            source = scriptContentNode.toString();
                            try {
                                Actions.execute((SecurityContext)this.securityContext, null, (String)source, null);
                            }
                            catch (UnlicensedException ex) {
                                ex.log(logger);
                            }
                        }
                        continue;
                    }
                    if (contentType.equals("application/x-structr-javascript")) {
                        for (Node scriptContentNode : node.childNodes()) {
                            source = scriptContentNode.toString();
                            try {
                                Actions.execute((SecurityContext)this.securityContext, null, (String)source, null);
                            }
                            catch (UnlicensedException ex) {
                                ex.log(logger);
                            }
                        }
                        continue;
                    }
                }
            }
            if (instructions != null) {
                if (instructions.contains("@structr:content") && !(newNode instanceof Content)) {
                    this.createEmptyContentNode(page, parent, this.commentHandler, instructions);
                } else if (this.commentHandler != null) {
                    this.commentHandler.handleComment(page, newNode, instructions, true);
                }
                instructions = null;
            }
            if (parent != null) {
                if (newNode instanceof Head && parent instanceof Body) {
                    org.w3c.dom.Node html = parent.getParentNode();
                    html.insertBefore(newNode, parent);
                } else {
                    parent.appendChild(newNode);
                }
            }
            if (isNewTemplateOrComponent) continue;
            this.createChildNodes(node, newNode, page, removeHashAttribute, depth + 1);
        }
        if (instructions != null) {
            this.createEmptyContentNode(page, parent, this.commentHandler, instructions);
            instructions = null;
        }
        return rootElement;
    }

    private FileBase fileExists(String path, long checksum) throws FrameworkException {
        return (FileBase)app.nodeQuery(FileBase.class).and((PropertyKey)FileBase.path, (Object)path).and((PropertyKey)org.structr.dynamic.File.checksum, (Object)checksum).getFirst();
    }

    private Linkable downloadFile(String downloadAddress, URL base) {
        long checksum;
        long size;
        String contentType;
        URL downloadUrl;
        if (this.alreadyDownloaded.containsKey(downloadAddress)) {
            return this.alreadyDownloaded.get(downloadAddress);
        }
        String uuid = UUID.randomUUID().toString().replaceAll("[\\-]+", "");
        String relativeFilePath = org.structr.dynamic.File.getDirectoryPath(uuid) + "/" + uuid;
        String filePath = FileHelper.getFilePath(relativeFilePath);
        File fileOnDisk = new File(filePath);
        fileOnDisk.getParentFile().mkdirs();
        try {
            downloadUrl = new URL(base, downloadAddress);
            logger.info("Starting download from {}", (Object)downloadUrl);
            this.copyURLToFile(downloadUrl.toString(), fileOnDisk);
        }
        catch (IOException ioe) {
            if (this.originalUrl == null || this.address == null) {
                logger.info("Cannot download from {} without base address", (Object)downloadAddress);
                return null;
            }
            logger.warn("Unable to download from {} {}", new Object[]{this.originalUrl, downloadAddress});
            try {
                if (this.address.endsWith("/")) {
                    logger.info("Starting download from alternative URL {} {} {}", new Object[]{this.originalUrl, this.address, downloadAddress});
                    downloadUrl = new URL(new URL(this.originalUrl, this.address), downloadAddress);
                } else {
                    logger.info("Starting download from alternative URL {} {} {}", new Object[]{this.originalUrl, this.address.concat("/"), downloadAddress});
                    downloadUrl = new URL(new URL(this.originalUrl, this.address.concat("/")), downloadAddress);
                }
                this.copyURLToFile(downloadUrl.toString(), fileOnDisk);
            }
            catch (MalformedURLException ex) {
                logger.error("Could not resolve address {}", (Object)this.address.concat("/"));
                return null;
            }
            catch (IOException ex) {
                logger.warn("Unable to download from {}", (Object)this.address.concat("/"));
                return null;
            }
            logger.info("Starting download from alternative URL {}", (Object)downloadUrl);
        }
        String fileName = PathHelper.getName((String)downloadAddress);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            logger.warn("Can't figure out filename from download address {}, aborting.", (Object)downloadAddress);
            return null;
        }
        try {
            contentType = FileHelper.getContentMimeType(fileOnDisk, fileName);
            size = fileOnDisk.length();
            checksum = FileUtils.checksumCRC32((File)fileOnDisk);
        }
        catch (IOException ioe) {
            logger.warn("Unable to determine MIME type, size or checksum of {}", (Object)fileOnDisk);
            return null;
        }
        logger.info("Download URL: {}, address: {}, cleaned address: {}, filename: {}", new Object[]{downloadUrl, this.address, StringUtils.substringBeforeLast((String)this.address, (String)"/"), fileName});
        String relativePath = StringUtils.substringAfter((String)downloadUrl.toString(), (String)StringUtils.substringBeforeLast((String)this.address, (String)"/"));
        if (StringUtils.isBlank((CharSequence)relativePath)) {
            relativePath = downloadAddress;
        }
        String httpPrefix = "http://";
        String httpsPrefix = "https://";
        String flexiblePrefix = "//";
        String path = downloadAddress.startsWith("https://") ? StringUtils.substringBefore((String)StringUtils.substringAfter((String)downloadAddress, (String)"https://"), (String)fileName) : (downloadAddress.startsWith("http://") ? StringUtils.substringBefore((String)StringUtils.substringAfter((String)downloadAddress, (String)"http://"), (String)fileName) : (downloadAddress.startsWith("//") ? StringUtils.substringBefore((String)StringUtils.substringAfter((String)downloadAddress, (String)"//"), (String)fileName) : StringUtils.substringBefore((String)relativePath, (String)fileName)));
        logger.info("Relative path: {}, final path: {}", new Object[]{relativePath, path});
        if (contentType.equals("text/plain")) {
            contentType = (String)StringUtils.defaultIfBlank((CharSequence)contentTypeForExtension.get(StringUtils.substringAfterLast((String)fileName, (String)".")), (CharSequence)"text/plain");
        }
        String ct = contentType;
        try {
            String fullPath = path + fileName;
            FileBase fileNode = this.fileExists(fullPath, checksum);
            if (fileNode == null) {
                fileNode = ImageHelper.isImageType(fileName) ? this.createImageNode(uuid, fullPath, ct, size, checksum) : this.createFileNode(uuid, fullPath, ct, size, checksum);
                if (contentType.equals("text/css")) {
                    this.processCssFileNode(fileNode, downloadUrl);
                }
            } else {
                fileOnDisk.delete();
            }
            this.alreadyDownloaded.put(downloadAddress, fileNode);
            return fileNode;
        }
        catch (IOException | FrameworkException ex) {
            logger.warn("Could not create file node.", ex);
            return null;
        }
    }

    private FileBase createFileNode(String uuid, String path, String contentType, long size, long checksum) throws FrameworkException {
        return this.createFileNode(uuid, path, contentType, size, checksum, null);
    }

    private FileBase createFileNode(String uuid, String path, String contentType, long size, long checksum, Class fileClass) throws FrameworkException {
        String relativeFilePath = org.structr.dynamic.File.getDirectoryPath(uuid) + "/" + uuid;
        FileBase fileNode = (FileBase)app.create(fileClass != null ? fileClass : org.structr.dynamic.File.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)GraphObject.id, (Object)uuid), new NodeAttribute((PropertyKey)AbstractNode.name, (Object)PathHelper.getName((String)path)), new NodeAttribute((PropertyKey)org.structr.dynamic.File.relativeFilePath, (Object)relativeFilePath), new NodeAttribute((PropertyKey)org.structr.dynamic.File.contentType, (Object)contentType), new NodeAttribute((PropertyKey)org.structr.dynamic.File.size, (Object)size), new NodeAttribute((PropertyKey)org.structr.dynamic.File.checksum, (Object)checksum), new NodeAttribute((PropertyKey)org.structr.dynamic.File.version, (Object)1), new NodeAttribute((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)this.publicVisible), new NodeAttribute((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)this.authVisible)});
        Folder parentFolder = FileHelper.createFolderPath(this.securityContext, PathHelper.getFolderPath((String)path));
        fileNode.setProperty((PropertyKey)FileBase.parent, (Object)parentFolder);
        return fileNode;
    }

    private Image createImageNode(String uuid, String path, String contentType, long size, long checksum) throws FrameworkException {
        return (Image)this.createFileNode(uuid, path, contentType, size, checksum, Image.class);
    }

    private void processCssFileNode(FileBase fileNode, URL base) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)fileNode.getInputStream(), (Writer)sw, (String)"UTF-8");
        String css = sw.toString();
        this.processCss(css, base);
    }

    private void processCss(String css, URL base) throws IOException {
        Pattern pattern = Pattern.compile("(url\\(['|\"]?)([^'|\"|)]*)");
        Matcher matcher = pattern.matcher(css);
        while (matcher.find()) {
            String url = matcher.group(2);
            logger.info("Trying to download from URL found in CSS: {}", (Object)url);
            this.downloadFile(url, base);
        }
    }

    private void copyURLToFile(String address, File fileOnDisk) throws IOException {
        try {
            HttpHelper.streamURLToFile((String)address, (File)fileOnDisk);
        }
        catch (FrameworkException ex) {
            logger.warn(null, (Throwable)ex);
        }
    }

    public static DOMNode findSharedComponentByName(String name) throws FrameworkException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (DOMNode n : StructrApp.getInstance().nodeQuery(DOMNode.class).andName(name).and(DOMNode.ownerDocument, (Object)CreateComponentCommand.getOrCreateHiddenDocument()).getAsList()) {
            if (n.getProperty((PropertyKey)DOMNode.parent) != null) continue;
            return n;
        }
        return null;
    }

    public static DOMNode findTemplateByName(String name) throws FrameworkException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (DOMNode n : StructrApp.getInstance().nodeQuery(Template.class).andName(name).and().notBlank((PropertyKey)AbstractNode.name).getAsList()) {
            if (n.getProperty((PropertyKey)DOMNode.sharedComponent) != null) continue;
            return n;
        }
        return null;
    }

    private static String trimTrailingNewline(String source) {
        String workString = source;
        while (workString.startsWith("\n") || workString.startsWith("\t")) {
            workString = workString.substring(1);
        }
        while (workString.endsWith("\n") || workString.endsWith("\t")) {
            workString = workString.substring(0, workString.length() - 1);
        }
        return workString;
    }

    private Content createEmptyContentNode(Page page, DOMNode parent, CommentHandler commentHandler, String instructions) throws FrameworkException {
        Content contentNode = (Content)page.createTextNode("");
        contentNode.setVisibility(this.publicVisible, this.authVisible);
        if (parent != null) {
            parent.appendChild(contentNode);
        }
        if (commentHandler != null) {
            commentHandler.handleComment(page, contentNode, instructions, true);
        }
        return contentNode;
    }

    private Template createNewTemplateNode(DOMNode parent, List<Node> children) throws FrameworkException {
        StringBuilder sb = new StringBuilder();
        for (Node c : children) {
            sb.append(this.nodeToString(c));
        }
        return this.createNewTemplateNode(parent, sb.toString(), null);
    }

    private Template createNewHTMLTemplateNodeForUnsupportedTag(DOMNode parent, Node nodeOfUnsupportedTag) throws FrameworkException {
        return this.createNewTemplateNode(parent, this.nodeToString(nodeOfUnsupportedTag), "text/html");
    }

    private Template createNewTemplateNode(DOMNode parent, String content, String contentType) throws FrameworkException {
        PropertyMap map = new PropertyMap();
        map.put((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)this.publicVisible);
        map.put((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)this.authVisible);
        map.put(Content.contentType, (Object)contentType);
        map.put(Content.content, (Object)content);
        Template newTemplate = (Template)StructrApp.getInstance((SecurityContext)this.securityContext).create(Template.class, map);
        if (parent != null) {
            parent.appendChild(newTemplate);
        }
        return newTemplate;
    }

    private DOMNode createSharedComponent(Node node) throws FrameworkException {
        ShadowDocument shadowDoc = CreateComponentCommand.getOrCreateHiddenDocument();
        return this.createChildNodes(node, null, shadowDoc);
    }

    private String nodeToString(Node node) {
        if (node instanceof TextNode) {
            return ((TextNode)node).getWholeText();
        }
        if (node instanceof Element) {
            Element el = (Element)node;
            boolean prettyPrintBackup = el.ownerDocument().outputSettings().prettyPrint();
            el.ownerDocument().outputSettings().prettyPrint(false);
            String result = el.outerHtml();
            el.ownerDocument().outputSettings().prettyPrint(prettyPrintBackup);
            return result;
        }
        return node.toString();
    }

    static {
        contentTypeForExtension.put("css", "text/css");
        contentTypeForExtension.put("js", "text/javascript");
        contentTypeForExtension.put("xml", "text/xml");
        contentTypeForExtension.put("php", "application/x-php");
    }
}

