/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.maintenance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.GraphObjectComparator;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.Localization;
import org.structr.core.entity.MailTemplate;
import org.structr.core.entity.Principal;
import org.structr.core.entity.ResourceAccess;
import org.structr.core.entity.SchemaMethod;
import org.structr.core.entity.Security;
import org.structr.core.entity.relationship.PrincipalOwnsNode;
import org.structr.core.graph.FlushCachesCommand;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.script.Scripting;
import org.structr.rest.resource.MaintenanceParameterResource;
import org.structr.schema.action.ActionContext;
import org.structr.schema.export.StructrSchema;
import org.structr.schema.json.JsonSchema;
import org.structr.web.common.FileHelper;
import org.structr.web.common.RenderContext;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.Image;
import org.structr.web.entity.Widget;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.Template;
import org.structr.web.entity.html.relation.ResourceLink;
import org.structr.web.entity.relation.FileChildren;
import org.structr.web.entity.relation.FileSiblings;
import org.structr.web.entity.relation.FolderChildren;
import org.structr.web.entity.relation.Folders;
import org.structr.web.entity.relation.Images;
import org.structr.web.entity.relation.MinificationSource;
import org.structr.web.entity.relation.Thumbnails;
import org.structr.web.entity.relation.UserFavoriteFavoritable;
import org.structr.web.entity.relation.UserFavoriteFile;
import org.structr.web.entity.relation.UserWorkDir;
import org.structr.web.maintenance.deploy.ComponentImportVisitor;
import org.structr.web.maintenance.deploy.FileImportVisitor;
import org.structr.web.maintenance.deploy.PageImportVisitor;
import org.structr.web.maintenance.deploy.SchemaImportVisitor;
import org.structr.web.maintenance.deploy.TemplateImportVisitor;

public class DeployCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)DeployCommand.class.getName());
    private static final Pattern pattern = Pattern.compile("[a-f0-9]{32}");
    private static final Set<String> exportFileTypes = new HashSet<String>(Arrays.asList("File", "Folder", "Image"));

    public void execute(Map<String, Object> attributes) throws FrameworkException {
        String mode;
        if (!this.securityContext.getCachedUserId().equals("00000000000000000000000000000000")) {
            logger.info("");
            logger.info("/*************************************************************************************************/");
            logger.info("/*                                                                                               */");
            logger.info("/*   Deployment is faster using the superadmin account - consider using this account next time   */");
            logger.info("/*                                                                                               */");
            logger.info("/*************************************************************************************************/");
            logger.info("");
        }
        if ((mode = (String)attributes.get("mode")) != null && "export".equals(mode)) {
            this.doExport(attributes);
        } else {
            this.doImport(attributes);
        }
    }

    public boolean requiresEnclosingTransaction() {
        return false;
    }

    public boolean requiresFlushingOfCaches() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> readConfigMap(Path pagesConf) {
        if (!Files.exists(pagesConf, new LinkOption[0])) return new HashMap<String, Object>();
        try (BufferedReader reader = Files.newBufferedReader(pagesConf, Charset.forName("utf-8"));){
            HashMap<String, Object> hashMap = new HashMap<String, Object>((Map)this.getGson().fromJson((Reader)reader, Map.class));
            return hashMap;
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
        return new HashMap<String, Object>();
    }

    public Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public static boolean isUuid(String name) {
        return pattern.matcher(name).matches();
    }

    private void doImport(Map<String, Object> attributes) throws FrameworkException {
        Path postDeployConf;
        Path files;
        Path schema;
        Path templatesConfFile;
        Path componentsConfFile;
        Path pagesConfFile;
        Path filesConfFile;
        Path localizationsConf;
        Path widgetsConf;
        Path mailTemplatesConf;
        Path schemaMethodsConf;
        long startTime = System.currentTimeMillis();
        customHeaders.put("start", new Date(startTime).toString());
        String path = (String)attributes.get("source");
        SecurityContext ctx = SecurityContext.getSuperUserInstance();
        ctx.setDoTransactionNotifications(false);
        App app = StructrApp.getInstance((SecurityContext)ctx);
        HashMap<String, Object> componentsConf = new HashMap<String, Object>();
        HashMap<String, Object> templatesConf = new HashMap<String, Object>();
        HashMap<String, Object> pagesConf = new HashMap<String, Object>();
        HashMap<String, Object> filesConf = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new FrameworkException(422, "Please provide 'source' attribute for deployment source directory path.");
        }
        Path source = Paths.get(path, new String[0]);
        if (!Files.exists(source, new LinkOption[0])) {
            throw new FrameworkException(422, "Source path " + path + " does not exist.");
        }
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new FrameworkException(422, "Source path " + path + " is not a directory.");
        }
        TreeMap<String, Object> broadcastData = new TreeMap<String, Object>();
        broadcastData.put("start", startTime);
        TransactionCommand.simpleBroadcast((String)"DEPLOYMENT_IMPORT_STARTED", broadcastData);
        Path preDeployConf = source.resolve("pre-deploy.conf");
        if (Files.exists(preDeployConf, new LinkOption[0])) {
            try (Tx tx = app.tx();){
                String confSource = new String(Files.readAllBytes(preDeployConf), Charset.forName("utf-8")).trim();
                if (confSource.length() > 0) {
                    this.info("Applying pre-deployment configuration from {}..", new Object[]{preDeployConf});
                    Scripting.evaluate((ActionContext)new ActionContext(ctx), null, (String)confSource, (String)"pre-deploy.conf");
                } else {
                    this.info("Ignoring empty pre-deployment configuration {}..", new Object[]{preDeployConf});
                }
                tx.success();
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        boolean changeLogEnabled = (Boolean)Settings.ChangelogEnabled.getValue();
        Settings.ChangelogEnabled.setValue((Object)false);
        Path grantsConf = source.resolve("security/grants.json");
        if (Files.exists(grantsConf, new LinkOption[0])) {
            this.info("Reading {}..", new Object[]{grantsConf});
            this.importListData(ResourceAccess.class, this.readConfigList(grantsConf), new PropertyMap[0]);
        }
        if (Files.exists(schemaMethodsConf = source.resolve("schema-methods.json"), new LinkOption[0])) {
            this.info("Reading {}..", new Object[]{schemaMethodsConf});
            this.importListData(SchemaMethod.class, this.readConfigList(schemaMethodsConf), new PropertyMap[0]);
        }
        if (Files.exists(mailTemplatesConf = source.resolve("mail-templates.json"), new LinkOption[0])) {
            this.info("Reading {}..", new Object[]{mailTemplatesConf});
            this.importListData(MailTemplate.class, this.readConfigList(mailTemplatesConf), new PropertyMap[0]);
        }
        if (Files.exists(widgetsConf = source.resolve("widgets.json"), new LinkOption[0])) {
            this.info("Reading {}..", new Object[]{widgetsConf});
            this.importListData(Widget.class, this.readConfigList(widgetsConf), new PropertyMap[0]);
        }
        if (Files.exists(localizationsConf = source.resolve("localizations.json"), new LinkOption[0])) {
            PropertyMap additionalData = new PropertyMap();
            additionalData.put((PropertyKey)Localization.imported, (Object)false);
            this.info("Reading {}..", new Object[]{localizationsConf});
            this.importListData(Localization.class, this.readConfigList(localizationsConf), additionalData);
        }
        if (Files.exists(filesConfFile = source.resolve("files.json"), new LinkOption[0])) {
            this.info("Reading {}..", new Object[]{filesConfFile});
            filesConf.putAll(this.readConfigMap(filesConfFile));
        }
        if (Files.exists(pagesConfFile = source.resolve("pages.json"), new LinkOption[0])) {
            this.info("Reading {}..", new Object[]{pagesConfFile});
            pagesConf.putAll(this.readConfigMap(pagesConfFile));
        }
        if (Files.exists(componentsConfFile = source.resolve("components.json"), new LinkOption[0])) {
            this.info("Reading {}..", new Object[]{componentsConfFile});
            componentsConf.putAll(this.readConfigMap(componentsConfFile));
        }
        if (Files.exists(templatesConfFile = source.resolve("templates.json"), new LinkOption[0])) {
            this.info("Reading {}..", new Object[]{templatesConfFile});
            templatesConf.putAll(this.readConfigMap(templatesConfFile));
        }
        if (Files.exists(schema = source.resolve("schema"), new LinkOption[0])) {
            try {
                this.info("Importing data from schema/ directory..", new Object[0]);
                Files.walkFileTree(schema, new SchemaImportVisitor(schema));
            }
            catch (IOException ioex) {
                logger.warn("Exception while importing schema", (Throwable)ioex);
            }
        }
        if (Files.exists(files = source.resolve("files"), new LinkOption[0])) {
            try {
                this.info("Importing files...", new Object[0]);
                Files.walkFileTree(files, new FileImportVisitor(files, filesConf));
            }
            catch (IOException ioex) {
                logger.warn("Exception while importing files", (Throwable)ioex);
            }
        }
        Path templates = source.resolve("templates");
        Path components = source.resolve("components");
        Path pages = source.resolve("pages");
        if (Files.exists(templates, new LinkOption[0]) && Files.exists(components, new LinkOption[0]) && Files.exists(pages, new LinkOption[0])) {
            try (Tx tx = app.tx();){
                this.info("Removing pages, templates and components..", new Object[0]);
                app.cypher("MATCH (n:DOMNode) DETACH DELETE n", null);
                FlushCachesCommand.flushAll();
                tx.success();
            }
        } else {
            logger.info("Import directory does not seem to contain pages, templates or components, NOT removing any data.");
        }
        if (Files.exists(templates, new LinkOption[0])) {
            try {
                this.info("Importing templates..", new Object[0]);
                Files.walkFileTree(templates, new TemplateImportVisitor(templatesConf));
            }
            catch (IOException ioex) {
                logger.warn("Exception while importing templates", (Throwable)ioex);
            }
        }
        if (Files.exists(components, new LinkOption[0])) {
            try {
                this.info("Importing shared components..", new Object[0]);
                Files.walkFileTree(components, new ComponentImportVisitor(componentsConf));
            }
            catch (IOException ioex) {
                logger.warn("Exception while importing shared components", (Throwable)ioex);
            }
        }
        if (Files.exists(pages, new LinkOption[0])) {
            try {
                this.info("Importing pages..", new Object[0]);
                Files.walkFileTree(pages, new PageImportVisitor(pages, pagesConf));
            }
            catch (IOException ioex) {
                logger.warn("Exception while importing pages", (Throwable)ioex);
            }
        }
        if (Files.exists(postDeployConf = source.resolve("post-deploy.conf"), new LinkOption[0])) {
            try (Tx tx = app.tx();){
                String confSource = new String(Files.readAllBytes(postDeployConf), Charset.forName("utf-8")).trim();
                if (confSource.length() > 0) {
                    this.info("Applying post-deployment configuration from {}..", new Object[]{postDeployConf});
                    Scripting.evaluate((ActionContext)new ActionContext(ctx), null, (String)confSource, (String)"post-deploy.conf");
                } else {
                    this.info("Ignoring empty post-deployment configuration {}..", new Object[]{preDeployConf});
                }
                tx.success();
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        Settings.ChangelogEnabled.setValue((Object)changeLogEnabled);
        long endTime = System.currentTimeMillis();
        DecimalFormat decimalFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        String duration = decimalFormat.format((double)(endTime - startTime) / 1000.0) + "s";
        customHeaders.put("end", new Date(endTime).toString());
        customHeaders.put("duration", duration);
        this.info("Import from {} done. (Took {})", new Object[]{source.toString(), duration});
        broadcastData.put("end", endTime);
        broadcastData.put("duration", duration);
        TransactionCommand.simpleBroadcast((String)"DEPLOYMENT_IMPORT_FINISHED", broadcastData);
    }

    private void doExport(Map<String, Object> attributes) throws FrameworkException {
        String path = (String)attributes.get("target");
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new FrameworkException(422, "Please provide target path for deployment export.");
        }
        Path target = Paths.get(path, new String[0]);
        try {
            Files.createDirectories(target, new FileAttribute[0]);
            Path components = Files.createDirectories(target.resolve("components"), new FileAttribute[0]);
            Path files = Files.createDirectories(target.resolve("files"), new FileAttribute[0]);
            Path pages = Files.createDirectories(target.resolve("pages"), new FileAttribute[0]);
            Path schema = Files.createDirectories(target.resolve("schema"), new FileAttribute[0]);
            Path security = Files.createDirectories(target.resolve("security"), new FileAttribute[0]);
            Path templates = Files.createDirectories(target.resolve("templates"), new FileAttribute[0]);
            Path schemaJson = schema.resolve("schema.json");
            Path grants = security.resolve("grants.json");
            Path filesConf = target.resolve("files.json");
            Path pagesConf = target.resolve("pages.json");
            Path componentsConf = target.resolve("components.json");
            Path templatesConf = target.resolve("templates.json");
            Path schemaMethods = target.resolve("schema-methods.json");
            Path mailTemplates = target.resolve("mail-templates.json");
            Path localizations = target.resolve("localizations.json");
            Path widgets = target.resolve("widgets.json");
            this.exportFiles(files, filesConf);
            this.exportPages(pages, pagesConf);
            this.exportComponents(components, componentsConf);
            this.exportTemplates(templates, templatesConf);
            this.exportResourceAccessGrants(grants);
            this.exportSchema(schemaJson);
            this.exportSchemaMethods(schemaMethods);
            this.exportMailTemplates(mailTemplates);
            this.exportLocalizations(localizations);
            this.exportWidgets(widgets);
        }
        catch (IOException ex) {
            logger.warn("", (Throwable)ex);
        }
    }

    private void exportFiles(Path target, Path configTarget) throws FrameworkException {
        Throwable throwable;
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        App app = StructrApp.getInstance();
        try {
            throwable = null;
            try (Tx tx = app.tx();){
                for (Folder folder : app.nodeQuery(Folder.class).and((PropertyKey)Folder.parent, null).sort((PropertyKey)Folder.name).and(AbstractFile.includeInFrontendExport, (Object)true).getAsList()) {
                    this.exportFilesAndFolders(target, folder, config);
                }
                for (FileBase file : app.nodeQuery(FileBase.class).and((PropertyKey)Folder.parent, null).sort((PropertyKey)FileBase.name).and().or(AbstractFile.includeInFrontendExport, (Object)true).or((PropertyKey)FileBase.useAsJavascriptLibrary, (Object)true).getAsList()) {
                    this.exportFile(target, file, config);
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
        try {
            throwable = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(configTarget.toFile()));){
                this.getGson().toJson(config, (Appendable)fos);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void exportFilesAndFolders(Path target, Folder folder, Map<String, Object> config) throws IOException {
        String name = folder.getName();
        Path path = target.resolve(name);
        if (DeployCommand.okToExport(folder)) {
            TreeMap<String, Object> properties = new TreeMap<String, Object>();
            Files.createDirectories(path, new FileAttribute[0]);
            this.exportFileConfiguration(folder, properties);
            if (!properties.isEmpty()) {
                config.put(folder.getPath(), properties);
            }
        }
        List folders = (List)folder.getProperty((PropertyKey)Folder.folders);
        Collections.sort(folders, new GraphObjectComparator((PropertyKey)AbstractNode.name, false));
        for (Folder child : folders) {
            this.exportFilesAndFolders(path, child, config);
        }
        List files = (List)folder.getProperty((PropertyKey)Folder.files);
        Collections.sort(files, new GraphObjectComparator((PropertyKey)AbstractNode.name, false));
        for (FileBase file : files) {
            this.exportFile(path, file, config);
        }
    }

    private void exportFile(Path target, FileBase file, Map<String, Object> config) throws IOException {
        Long checksumOfExportFile;
        Long checksumOfExistingFile;
        if (!DeployCommand.okToExport(file)) {
            return;
        }
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        String name = file.getName();
        Path src = file.getFileOnDisk().toPath();
        Path targetPath = target.resolve(name);
        boolean doExport = true;
        if (Files.exists(targetPath, new LinkOption[0]) && (checksumOfExistingFile = FileHelper.getChecksum(targetPath.toFile())).equals(checksumOfExportFile = file.getChecksum())) {
            logger.info("Skipping export of file {}, no changes.", (Object)name);
            doExport = false;
        }
        if (doExport) {
            try {
                Files.copy(src, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ioex) {
                logger.warn("Unable to write file {}: {}", (Object)targetPath.toString(), (Object)ioex.getMessage());
            }
        }
        this.exportFileConfiguration(file, properties);
        if (!properties.isEmpty()) {
            config.put(file.getPath(), properties);
        }
    }

    private void exportPages(Path target, Path configTarget) throws FrameworkException {
        TreeMap<String, TreeMap<String, Object>> pagesConfig = new TreeMap<String, TreeMap<String, Object>>();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (Page page : app.nodeQuery(Page.class).sort((PropertyKey)Page.name).getAsList()) {
                String content;
                if (page instanceof ShadowDocument || (content = page.getContent(RenderContext.EditMode.DEPLOYMENT)) == null) continue;
                TreeMap<String, Object> properties = new TreeMap<String, Object>();
                String name = page.getName();
                Path pageFile = target.resolve(name + ".html");
                boolean doExport = true;
                if (Files.exists(pageFile, new LinkOption[0])) {
                    try {
                        String existingContent = new String(Files.readAllBytes(pageFile), "utf-8");
                        if (existingContent.equals(content)) {
                            logger.info("Skipping export of page {}, no changes.", (Object)name);
                            doExport = false;
                        }
                    }
                    catch (IOException ignore) {
                        logger.warn("", (Throwable)ignore);
                    }
                }
                pagesConfig.put(name, properties);
                this.exportConfiguration(page, properties);
                if (!doExport) continue;
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(pageFile.toFile()));
                    Throwable throwable = null;
                    try {
                        writer.write(content);
                        writer.flush();
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (IOException ioex) {
                    logger.warn("", (Throwable)ioex);
                }
            }
            tx.success();
        }
        try {
            var6_7 = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(configTarget.toFile()));){
                this.getGson().toJson(pagesConfig, (Appendable)fos);
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void exportComponents(Path target, Path configTarget) throws FrameworkException {
        TreeMap<String, TreeMap<String, Object>> configuration = new TreeMap<String, TreeMap<String, Object>>();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            ShadowDocument shadowDocument = (ShadowDocument)app.nodeQuery(ShadowDocument.class).getFirst();
            if (shadowDocument != null) {
                for (DOMNode node : (List)shadowDocument.getProperty((PropertyKey)Page.elements)) {
                    String content;
                    boolean hasParent = node.getProperty((PropertyKey)DOMNode.parent) != null;
                    boolean inTrash = node.inTrash();
                    boolean doExport = true;
                    if (inTrash || hasParent || (content = node.getContent(RenderContext.EditMode.DEPLOYMENT)) == null) continue;
                    String name = (String)node.getProperty((PropertyKey)AbstractNode.name);
                    if (name == null) {
                        name = node.getUuid();
                    }
                    TreeMap<String, Object> properties = new TreeMap<String, Object>();
                    Path targetFile = target.resolve(name + ".html");
                    if (Files.exists(targetFile, new LinkOption[0])) {
                        try {
                            String existingContent = new String(Files.readAllBytes(targetFile), "utf-8");
                            if (existingContent.equals(content)) {
                                logger.info("Skipping export of component {}, no changes.", (Object)name);
                                doExport = false;
                            }
                        }
                        catch (IOException existingContent) {
                            // empty catch block
                        }
                    }
                    configuration.put(name, properties);
                    this.exportConfiguration(node, properties);
                    if (!doExport) continue;
                    try {
                        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(targetFile.toFile()));
                        Throwable throwable = null;
                        try {
                            writer.write(content);
                            writer.flush();
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (writer == null) continue;
                            if (throwable != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            writer.close();
                        }
                    }
                    catch (IOException ioex) {
                        logger.warn("", (Throwable)ioex);
                    }
                }
            }
            tx.success();
        }
        try {
            var6_7 = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(configTarget.toFile()));){
                this.getGson().toJson(configuration, (Appendable)fos);
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void exportTemplates(Path target, Path configTarget) throws FrameworkException {
        TreeMap<String, Object> configuration = new TreeMap<String, Object>();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (Template template : app.nodeQuery(Template.class).getAsList()) {
                boolean isShared;
                boolean inTrash = template.inTrash();
                boolean bl = isShared = template.getProperty((PropertyKey)DOMNode.sharedComponent) != null;
                if (inTrash || isShared) continue;
                this.exportTemplateSource(target, template, configuration);
            }
            tx.success();
        }
        try {
            var6_7 = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(configTarget.toFile()));){
                this.getGson().toJson(configuration, (Appendable)fos);
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void exportTemplateSource(Path target, DOMNode template, Map<String, Object> configuration) throws FrameworkException {
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        boolean doExport = true;
        String content = (String)template.getProperty((PropertyKey)Template.content);
        if (content != null) {
            Path targetFile;
            String name = (String)template.getProperty((PropertyKey)AbstractNode.name);
            if (name == null) {
                name = template.getUuid();
            }
            if (Files.exists(targetFile = target.resolve(name + ".html"), new LinkOption[0])) {
                try {
                    String existingContent = new String(Files.readAllBytes(targetFile), "utf-8");
                    if (existingContent.equals(content)) {
                        logger.info("Skipping export of template {}, no changes.", (Object)name);
                        doExport = false;
                    }
                }
                catch (IOException existingContent) {
                    // empty catch block
                }
            }
            configuration.put(name, properties);
            this.exportConfiguration(template, properties);
            if (doExport) {
                try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(targetFile.toFile()));){
                    writer.write(content);
                    writer.flush();
                    writer.close();
                }
                catch (IOException ioex) {
                    logger.warn("", (Throwable)ioex);
                }
            }
        }
    }

    private void exportResourceAccessGrants(Path target) throws FrameworkException {
        LinkedList grants = new LinkedList();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (ResourceAccess res : app.nodeQuery(ResourceAccess.class).sort((PropertyKey)ResourceAccess.signature).getAsList()) {
                TreeMap<String, Object> grant = new TreeMap<String, Object>();
                grants.add(grant);
                grant.put("signature", res.getProperty((PropertyKey)ResourceAccess.signature));
                grant.put("flags", res.getProperty((PropertyKey)ResourceAccess.flags));
            }
            tx.success();
        }
        try {
            var5_6 = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(target.toFile()));){
                this.getGson().toJson(grants, (Appendable)fos);
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void exportSchema(Path target) throws FrameworkException {
        try {
            JsonSchema schema = StructrSchema.createFromDatabase((App)StructrApp.getInstance());
            try (FileWriter writer = new FileWriter(target.toFile());){
                ((Writer)writer).append(schema.toString());
                ((Writer)writer).append("\n");
                ((Writer)writer).flush();
            }
            catch (IOException ioex) {
                logger.warn("", (Throwable)ioex);
            }
        }
        catch (URISyntaxException x) {
            logger.warn("", (Throwable)x);
        }
    }

    private void exportConfiguration(DOMNode node, Map<String, Object> config) throws FrameworkException {
        if (node.isVisibleToPublicUsers()) {
            this.putIf(config, "visibleToPublicUsers", true);
        }
        if (node.isVisibleToAuthenticatedUsers()) {
            this.putIf(config, "visibleToAuthenticatedUsers", true);
        }
        this.putIf(config, "contentType", node.getProperty((PropertyKey)Content.contentType));
        if (node instanceof Template) {
            this.putIf(config, "shared", Boolean.toString(node.isSharedComponent() && node.getProperty((PropertyKey)DOMNode.parent) == null));
        }
        if (node instanceof Page) {
            this.putIf(config, "position", node.getProperty((PropertyKey)Page.position));
            this.putIf(config, "showOnErrorCodes", node.getProperty((PropertyKey)Page.showOnErrorCodes));
            this.putIf(config, "showConditions", node.getProperty((PropertyKey)Page.showConditions));
            this.putIf(config, "hideConditions", node.getProperty((PropertyKey)Page.hideConditions));
            this.putIf(config, "dontCache", node.getProperty((PropertyKey)Page.dontCache));
            this.putIf(config, "cacheForSeconds", node.getProperty((PropertyKey)Page.cacheForSeconds));
            this.putIf(config, "pageCreatesRawData", node.getProperty((PropertyKey)Page.pageCreatesRawData));
            this.putIf(config, "basicAuthRealm", node.getProperty((PropertyKey)Page.basicAuthRealm));
            this.putIf(config, "enableBasicAuth", node.getProperty((PropertyKey)Page.enableBasicAuth));
        }
        for (PropertyKey key : StructrApp.getConfiguration().getPropertySet(node.getClass(), "all")) {
            if (!key.isDynamic()) continue;
            this.putIf(config, key.jsonName(), node.getProperty(key));
        }
        this.exportOwnershipAndSecurity((AbstractNode)node, config);
    }

    private void exportFileConfiguration(AbstractFile file, Map<String, Object> config) {
        if (file.isVisibleToPublicUsers()) {
            this.putIf(config, "visibleToPublicUsers", true);
        }
        if (file.isVisibleToAuthenticatedUsers()) {
            this.putIf(config, "visibleToAuthenticatedUsers", true);
        }
        this.putIf(config, "type", file.getProperty((PropertyKey)FileBase.type));
        this.putIf(config, "contentType", file.getProperty((PropertyKey)FileBase.contentType));
        this.putIf(config, "cacheForSeconds", file.getProperty((PropertyKey)FileBase.cacheForSeconds));
        this.putIf(config, "useAsJavascriptLibrary", file.getProperty((PropertyKey)FileBase.useAsJavascriptLibrary));
        this.putIf(config, "includeInFrontendExport", file.getProperty((PropertyKey)FileBase.includeInFrontendExport));
        this.putIf(config, "basicAuthRealm", file.getProperty((PropertyKey)FileBase.basicAuthRealm));
        this.putIf(config, "enableBasicAuth", file.getProperty((PropertyKey)FileBase.enableBasicAuth));
        if (file instanceof Image) {
            this.putIf(config, "isThumbnail", file.getProperty((PropertyKey)Image.isThumbnail));
            this.putIf(config, "isImage", file.getProperty((PropertyKey)Image.isImage));
            this.putIf(config, "width", file.getProperty((PropertyKey)Image.width));
            this.putIf(config, "height", file.getProperty((PropertyKey)Image.height));
        }
        for (PropertyKey key : StructrApp.getConfiguration().getPropertySet(((Object)((Object)file)).getClass(), "all")) {
            if (!key.isDynamic()) continue;
            this.putIf(config, key.jsonName(), file.getProperty(key));
        }
        this.exportOwnershipAndSecurity((AbstractNode)file, config);
    }

    private void exportOwnershipAndSecurity(AbstractNode node, Map<String, Object> config) {
        Principal owner = node.getOwnerNode();
        if (owner != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", owner.getName());
            config.put("owner", map);
        }
        LinkedList grantees = new LinkedList();
        for (Security security : node.getSecurityRelationships()) {
            if (security == null) continue;
            TreeMap<String, Object> grant = new TreeMap<String, Object>();
            grant.put("name", ((Principal)security.getSourceNode()).getProperty((PropertyKey)AbstractNode.name));
            grant.put("allowed", StringUtils.join((Iterable)security.getPermissions(), (String)","));
            grantees.add(grant);
        }
        if (!grantees.isEmpty()) {
            config.put("grantees", grantees);
        }
    }

    private void exportMailTemplates(Path target) throws FrameworkException {
        LinkedList mailTemplates = new LinkedList();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (MailTemplate mailTemplate : app.nodeQuery(MailTemplate.class).sort((PropertyKey)MailTemplate.name).getAsList()) {
                TreeMap<String, Object> entry = new TreeMap<String, Object>();
                mailTemplates.add(entry);
                entry.put("name", mailTemplate.getProperty((PropertyKey)MailTemplate.name));
                entry.put("text", mailTemplate.getProperty((PropertyKey)MailTemplate.text));
                entry.put("locale", mailTemplate.getProperty((PropertyKey)MailTemplate.locale));
                entry.put("visibleToAuthenticatedUsers", mailTemplate.getProperty((PropertyKey)MailTemplate.visibleToAuthenticatedUsers));
                entry.put("visibleToPublicUsers", mailTemplate.getProperty((PropertyKey)MailTemplate.visibleToPublicUsers));
            }
            tx.success();
        }
        try {
            var5_6 = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(target.toFile()));){
                this.getGson().toJson(mailTemplates, (Appendable)fos);
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void exportWidgets(Path target) throws FrameworkException {
        LinkedList widgets = new LinkedList();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (Widget widget : app.nodeQuery(Widget.class).sort((PropertyKey)Widget.name).getAsList()) {
                TreeMap<String, Object> entry = new TreeMap<String, Object>();
                widgets.add(entry);
                entry.put("name", widget.getProperty((PropertyKey)Widget.name));
                entry.put("source", widget.getProperty((PropertyKey)Widget.source));
                entry.put("description", widget.getProperty((PropertyKey)Widget.description));
                entry.put("isWidget", widget.getProperty((PropertyKey)Widget.isWidget));
                entry.put("treePath", widget.getProperty((PropertyKey)Widget.treePath));
                entry.put("pictures", widget.getProperty((PropertyKey)Widget.pictures));
                entry.put("configuration", widget.getProperty((PropertyKey)Widget.configuration));
                entry.put("visibleToAuthenticatedUsers", widget.getProperty((PropertyKey)Widget.visibleToAuthenticatedUsers));
                entry.put("visibleToPublicUsers", widget.getProperty((PropertyKey)Widget.visibleToPublicUsers));
            }
            tx.success();
        }
        try {
            var5_6 = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(target.toFile()));){
                this.getGson().toJson(widgets, (Appendable)fos);
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void exportSchemaMethods(Path target) throws FrameworkException {
        LinkedList schemaMethods = new LinkedList();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (SchemaMethod schemaMethod : app.nodeQuery(SchemaMethod.class).and((PropertyKey)SchemaMethod.schemaNode, null).sort((PropertyKey)SchemaMethod.name).getAsList()) {
                TreeMap<String, Object> entry = new TreeMap<String, Object>();
                schemaMethods.add(entry);
                entry.put("name", schemaMethod.getProperty((PropertyKey)SchemaMethod.name));
                entry.put("comment", schemaMethod.getProperty((PropertyKey)SchemaMethod.comment));
                entry.put("source", schemaMethod.getProperty((PropertyKey)SchemaMethod.source));
                entry.put("virtualFileName", schemaMethod.getProperty((PropertyKey)SchemaMethod.virtualFileName));
                entry.put("visibleToAuthenticatedUsers", schemaMethod.getProperty((PropertyKey)SchemaMethod.visibleToAuthenticatedUsers));
                entry.put("visibleToPublicUsers", schemaMethod.getProperty((PropertyKey)SchemaMethod.visibleToPublicUsers));
            }
            tx.success();
        }
        try {
            var5_6 = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(target.toFile()));){
                this.getGson().toJson(schemaMethods, (Appendable)fos);
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void exportLocalizations(Path target) throws FrameworkException {
        LinkedList localizations = new LinkedList();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (Localization localization : app.nodeQuery(Localization.class).sort((PropertyKey)Localization.name).getAsList()) {
                TreeMap<String, Object> entry = new TreeMap<String, Object>();
                localizations.add(entry);
                entry.put("name", localization.getProperty((PropertyKey)Localization.name));
                entry.put("localizedName", localization.getProperty((PropertyKey)Localization.localizedName));
                entry.put("domain", localization.getProperty((PropertyKey)Localization.domain));
                entry.put("locale", localization.getProperty((PropertyKey)Localization.locale));
                entry.put("imported", localization.getProperty((PropertyKey)Localization.imported));
                entry.put("visibleToAuthenticatedUsers", localization.getProperty((PropertyKey)MailTemplate.visibleToAuthenticatedUsers));
                entry.put("visibleToPublicUsers", localization.getProperty((PropertyKey)MailTemplate.visibleToPublicUsers));
            }
            tx.success();
        }
        try {
            var5_6 = null;
            try (OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(target.toFile()));){
                this.getGson().toJson(localizations, (Appendable)fos);
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void putIf(Map<String, Object> target, String key, Object value) {
        if (value != null) {
            target.put(key, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, Object>> readConfigList(Path pagesConf) {
        try (BufferedReader reader = Files.newBufferedReader(pagesConf, Charset.forName("utf-8"));){
            List list = (List)this.getGson().fromJson((Reader)reader, List.class);
            return list;
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
            return Collections.emptyList();
        }
    }

    private <T extends NodeInterface> void importListData(Class<T> type, List<Map<String, Object>> data, PropertyMap ... additionalData) throws FrameworkException {
        SecurityContext context = SecurityContext.getSuperUserInstance();
        context.setDoTransactionNotifications(false);
        App app = StructrApp.getInstance((SecurityContext)context);
        try (Tx tx = app.tx();){
            for (NodeInterface nodeInterface : app.nodeQuery(type).getAsList()) {
                app.delete(nodeInterface);
            }
            for (Map map : data) {
                PropertyMap map2 = PropertyMap.inputTypeToJavaType((SecurityContext)context, type, (Map)map);
                for (PropertyMap add : additionalData) {
                    map2.putAll(add);
                }
                app.create(type, map2);
            }
            tx.success();
        }
    }

    public static boolean okToExport(AbstractFile file) {
        for (AbstractRelationship rel : file.getRelationships()) {
            if (rel instanceof Security || rel instanceof PrincipalOwnsNode || rel instanceof FolderChildren || rel instanceof FileChildren || rel instanceof FileSiblings || rel instanceof MinificationSource || rel instanceof UserFavoriteFile || rel instanceof UserWorkDir || rel instanceof Folders || rel instanceof org.structr.web.entity.relation.Files || rel instanceof Images || rel instanceof Thumbnails || rel instanceof ResourceLink || rel instanceof UserFavoriteFavoritable) continue;
            return false;
        }
        return true;
    }

    static {
        MaintenanceParameterResource.registerMaintenanceCommand((String)"deploy", DeployCommand.class);
    }
}

