/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.maintenance.deploy;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.Template;
import org.structr.web.importer.Importer;
import org.structr.web.maintenance.DeployCommand;
import org.structr.web.maintenance.deploy.DeploymentCommentHandler;
import org.structr.websocket.command.CreateComponentCommand;

public class ComponentImportVisitor
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger((String)ComponentImportVisitor.class.getName());
    private Map<String, Object> configuration = null;
    private SecurityContext securityContext = null;
    private App app = null;

    public ComponentImportVisitor(Map<String, Object> pagesConfiguration) {
        this.configuration = pagesConfiguration;
        this.securityContext = SecurityContext.getSuperUserInstance();
        this.app = StructrApp.getInstance();
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (attrs.isRegularFile()) {
            String fileName = file.getFileName().toString();
            if (fileName.endsWith(".html")) {
                try {
                    this.createComponent(file, fileName);
                }
                catch (FrameworkException fex) {
                    logger.warn("Exception while importing shared component {}", (Object)NodeInterface.name, (Object)fex);
                }
            }
        } else {
            logger.warn("Unexpected directory {} found in components/ directory, ignoring", (Object)file.getFileName().toString());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        logger.warn("Exception while importing file {}: {}", new Object[]{file.toString(), exc.getMessage()});
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    private DOMNode getExistingComponent(String name) {
        App app = StructrApp.getInstance();
        DOMNode result = null;
        try (Tx tx = app.tx();){
            result = DeployCommand.isUuid(name) ? (DOMNode)StructrApp.getInstance().nodeQuery(DOMNode.class).and((PropertyKey)GraphObject.id, (Object)name).getFirst() : Importer.findSharedComponentByName(name);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to determine if component {} already exists, ignoring.", (Object)name);
        }
        return result;
    }

    private void deleteComponent(App app, String name) throws FrameworkException {
        DOMNode node = this.getExistingComponent(name);
        if (node != null) {
            this.deleteRecursively(app, node);
        }
    }

    private void deleteRecursively(App app, DOMNode node) throws FrameworkException {
        for (DOMNode child : node.treeGetChildren()) {
            this.deleteRecursively(app, child);
        }
        for (DOMNode sync : (List)node.getProperty((PropertyKey)DOMNode.syncedNodes)) {
            this.deleteRecursively(app, sync);
        }
        app.delete((NodeInterface)node);
    }

    private PropertyMap getPropertiesForComponent(String name) {
        Object data = this.configuration.get(name);
        if (data != null && data instanceof Map) {
            try {
                return PropertyMap.inputTypeToJavaType((SecurityContext)SecurityContext.getSuperUserInstance(), DOMNode.class, (Map)((Map)data));
            }
            catch (FrameworkException ex) {
                logger.warn("Unable to resolve properties for shared component: {}", (Object)ex.getMessage());
            }
        }
        return new PropertyMap();
    }

    private <T> T get(PropertyMap src, PropertyKey<T> key, T defaultValue) {
        Object t;
        if (src != null && (t = src.get(key)) != null) {
            return (T)t;
        }
        return defaultValue;
    }

    private void createComponent(Path file, String fileName) throws IOException, FrameworkException {
        String name = StringUtils.substringBeforeLast((String)fileName, (String)".html");
        DOMNode existingComponent = this.getExistingComponent(name);
        boolean byId = DeployCommand.isUuid(name);
        try (Tx tx = this.app.tx(true, false, false);){
            PropertyMap properties = this.getPropertiesForComponent(name);
            if (existingComponent != null) {
                if (existingComponent instanceof Template) {
                    properties.put((PropertyKey)Template.content, existingComponent.getProperty((PropertyKey)Template.content));
                    existingComponent.setProperty((PropertyKey)Template.ownerDocument, null);
                } else {
                    this.deleteComponent(this.app, name);
                }
            }
            String src = new String(Files.readAllBytes(file), Charset.forName("UTF-8"));
            boolean visibleToPublic = this.get(properties, (PropertyKey)GraphObject.visibleToPublicUsers, false);
            boolean visibleToAuth = this.get(properties, (PropertyKey)GraphObject.visibleToAuthenticatedUsers, false);
            Importer importer = new Importer(this.securityContext, src, null, name, visibleToPublic, visibleToAuth);
            importer.setIsDeployment(true);
            boolean parseOk = importer.parse(false);
            if (parseOk) {
                logger.info("Importing component {} from {}..", new Object[]{name, fileName});
                importer.setCommentHandler(new DeploymentCommentHandler());
                ShadowDocument shadowDocument = CreateComponentCommand.getOrCreateHiddenDocument();
                DOMNode rootElement = importer.createComponentChildNodes(shadowDocument);
                if (rootElement != null) {
                    if (byId) {
                        rootElement.unlockSystemPropertiesOnce();
                        rootElement.setProperty((PropertyKey)GraphObject.id, name);
                    } else {
                        rootElement.setProperty((PropertyKey)AbstractNode.name, name);
                    }
                    rootElement.setProperties(this.securityContext, properties);
                }
            }
            tx.success();
        }
    }
}

