/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.maintenance.deploy;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.importer.Importer;
import org.structr.web.maintenance.deploy.DeploymentCommentHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageImportVisitor
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger((String)PageImportVisitor.class.getName());
    private static final String DoctypeString = "<!DOCTYPE";
    private Map<String, Object> pagesConfiguration = null;
    private SecurityContext securityContext = null;
    private Path basePath = null;
    private App app = null;

    public PageImportVisitor(Path basePath, Map<String, Object> pagesConfiguration) {
        this.pagesConfiguration = pagesConfiguration;
        this.securityContext = SecurityContext.getSuperUserInstance();
        this.securityContext.setDoTransactionNotifications(false);
        this.basePath = basePath;
        this.app = StructrApp.getInstance((SecurityContext)this.securityContext);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        try {
            String fileName;
            if (attrs.isDirectory()) {
                this.createFolder(file);
            } else if (attrs.isRegularFile() && (fileName = file.getFileName().toString()).endsWith(".html")) {
                try {
                    this.createPage(file, fileName);
                }
                catch (FrameworkException fex) {
                    logger.warn("Exception while importing page {}: {}", new Object[]{NodeInterface.name, fex.getMessage()});
                }
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        logger.warn("Exception while importing file {}: {}", new Object[]{file.toString(), exc.getMessage()});
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    private Page getExistingPage(String name) throws FrameworkException {
        return (Page)StructrApp.getInstance().nodeQuery(Page.class).andName(name).getFirst();
    }

    private void deletePage(App app, String name) throws FrameworkException {
        Page page = (Page)app.nodeQuery(Page.class).andName(name).getFirst();
        if (page != null) {
            for (DOMNode child : (List)page.getProperty((PropertyKey)Page.elements)) {
                app.delete((NodeInterface)child);
            }
            app.delete((NodeInterface)page);
        }
    }

    private PropertyMap getPropertiesForPage(String name) {
        Object data = this.pagesConfiguration.get(name);
        if (data != null && data instanceof Map) {
            try {
                return PropertyMap.inputTypeToJavaType((SecurityContext)SecurityContext.getSuperUserInstance(), Page.class, (Map)((Map)data));
            }
            catch (FrameworkException ex) {
                logger.warn("Unable to resolve properties for page: {}", (Object)ex.getMessage());
            }
        }
        return null;
    }

    private <T> T get(PropertyMap src, PropertyKey<T> key, T defaultValue) {
        Object t;
        if (src != null && (t = src.get(key)) != null) {
            return (T)t;
        }
        return defaultValue;
    }

    private void createFolder(Path file) {
        try (Tx tx = this.app.tx(true, false, false);){
            FileHelper.createFolderPath(this.securityContext, this.basePath.relativize(file).toString());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    private void createPage(Path file, String fileName) throws IOException, FrameworkException {
        String name = StringUtils.substringBeforeLast((String)fileName, (String)".html");
        try (Tx tx = this.app.tx(true, false, false);){
            PropertyMap properties = this.getPropertiesForPage(name);
            Page existingPage = this.getExistingPage(name);
            if (existingPage != null) {
                this.deletePage(this.app, name);
            }
            String src = new String(Files.readAllBytes(file), Charset.forName("UTF-8"));
            String contentType = this.get(properties, (PropertyKey)Page.contentType, (Object)"text/html");
            boolean visibleToPublic = this.get(properties, (PropertyKey)GraphObject.visibleToPublicUsers, false);
            boolean visibleToAuth = this.get(properties, (PropertyKey)GraphObject.visibleToAuthenticatedUsers, false);
            Importer importer = new Importer(this.securityContext, src, null, name, visibleToPublic, visibleToAuth);
            importer.setIsDeployment(true);
            if (StringUtils.startsWithIgnoreCase((CharSequence)src, (CharSequence)DoctypeString) && "text/html".equals(contentType)) {
                boolean parseOk = importer.parse();
                if (parseOk) {
                    logger.info("Importing page {} from {}..", new Object[]{name, fileName});
                    importer.setCommentHandler(new DeploymentCommentHandler());
                    Page newPage = importer.readPage();
                    this.fixDocumentElements(newPage);
                    if (properties != null) {
                        newPage.setProperties(this.securityContext, properties);
                    }
                }
            } else {
                boolean parseOk = importer.parse(true);
                if (parseOk) {
                    logger.info("Importing page {} from {}..", new Object[]{name, fileName});
                    importer.setCommentHandler(new DeploymentCommentHandler());
                    Page newPage = (Page)this.app.create(Page.class, name);
                    if (properties != null) {
                        newPage.setProperties(this.securityContext, properties);
                    }
                    importer.createChildNodes(newPage, newPage);
                }
            }
            tx.success();
        }
    }

    private void fixDocumentElements(Page page) {
        NodeList heads = page.getElementsByTagName("head");
        if (heads.getLength() > 1) {
            Node head1 = heads.item(0);
            Node head2 = heads.item(1);
            Node parent = head1.getParentNode();
            boolean h1 = head1.hasChildNodes();
            boolean h2 = head2.hasChildNodes();
            if (h1 && h2) {
                for (Node child = head2.getFirstChild(); child != null; child = child.getNextSibling()) {
                    head2.removeChild(child);
                    head1.appendChild(child);
                }
                parent.removeChild(head2);
            } else if (h1 && !h2) {
                parent.removeChild(head2);
            } else if (!h1 && h2) {
                parent.removeChild(head1);
            } else {
                parent.removeChild(head1);
            }
        }
    }
}

