/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.migration;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.GenericRelationship;
import org.structr.core.entity.Security;
import org.structr.core.entity.relationship.PrincipalOwnsNode;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.resource.MaintenanceParameterResource;
import org.structr.web.entity.dom.relationship.DOMChildren;
import org.structr.web.entity.dom.relationship.DOMSiblings;
import org.structr.web.entity.html.relation.ResourceLink;
import org.structr.web.entity.relation.PageLink;
import org.structr.web.entity.relation.Sync;

public class BulkMigrateRelationships
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkMigrateRelationships.class.getName());

    public void execute(Map<String, Object> map) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        RelationshipFactory relFactory = new RelationshipFactory(this.securityContext);
        if (graphDb != null) {
            Iterator relIterator = Iterables.map((Function)relFactory, (Iterable)relFactory.bulkInstantiate(graphDb.getAllRelationships())).iterator();
            long counter = this.bulkGraphOperation(this.securityContext, relIterator, 1000L, "MigrateRelationships", (BulkGraphOperation)new BulkGraphOperation<AbstractRelationship>(){

                public void handleGraphObject(SecurityContext securityContext, AbstractRelationship rel) {
                    if (rel.getProperty((PropertyKey)GraphObject.id) != null) {
                        Class<?> type = rel.getClass();
                        if (!type.equals(GenericRelationship.class)) {
                            return;
                        }
                        try {
                            String relType = rel.getType();
                            rel.getRelationship().removeProperty("combinedType");
                            rel.unlockSystemPropertiesOnce();
                            if ("CONTAINS".equals(relType)) {
                                rel.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractRelationship.type, (Object)DOMChildren.class.getSimpleName()));
                            } else if ("CONTAINS_NEXT_SIBLING".equals(relType)) {
                                rel.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractRelationship.type, (Object)DOMSiblings.class.getSimpleName()));
                            } else if ("OWNS".equals(relType)) {
                                rel.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractRelationship.type, (Object)PrincipalOwnsNode.class.getSimpleName()));
                            } else if ("SECURITY".equals(relType)) {
                                rel.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractRelationship.type, (Object)Security.class.getSimpleName()));
                            } else if ("PAGE".equals(relType)) {
                                rel.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractRelationship.type, (Object)PageLink.class.getSimpleName()));
                            } else if ("LINK".equals(relType)) {
                                rel.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractRelationship.type, (Object)ResourceLink.class.getSimpleName()));
                            } else if ("SYNC".equals(relType)) {
                                rel.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractRelationship.type, (Object)Sync.class.getSimpleName()));
                            }
                        }
                        catch (FrameworkException fex) {
                            logger.warn("Unable to migrate relationship {}: {}", new Object[]{rel.getUuid(), fex.getMessage()});
                        }
                    }
                }

                public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractRelationship rel) {
                    logger.warn("Unable to migrate relationship {}: {}", new Object[]{rel.getUuid(), t.getMessage()});
                }

                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to migrate relationship: {}", (Object)t.getMessage());
                }
            });
            logger.info("Finished setting properties on {} nodes", (Object)counter);
        }
    }

    public boolean requiresEnclosingTransaction() {
        return false;
    }

    public boolean requiresFlushingOfCaches() {
        return false;
    }

    static {
        MaintenanceParameterResource.registerMaintenanceCommand((String)"migrateRelationships", BulkMigrateRelationships.class);
    }
}

