/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailAttachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.MailHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.Authenticator;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.MailTemplate;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeFactory;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.RestMethodResult;
import org.structr.rest.auth.AuthHelper;
import org.structr.rest.exception.NotAllowedException;
import org.structr.rest.resource.Resource;
import org.structr.web.entity.User;

public class RegistrationResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger((String)RegistrationResource.class.getName());

    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        return this.getUriPart().equals(part);
    }

    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        throw new NotAllowedException("GET not allowed on " + this.getResourceSignature());
    }

    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        throw new NotAllowedException("PUT not allowed on " + this.getResourceSignature());
    }

    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        boolean existingUser = false;
        if (propertySet.containsKey(User.eMail.jsonName())) {
            Principal user;
            String emailString = (String)propertySet.get(User.eMail.jsonName());
            if (StringUtils.isEmpty((CharSequence)emailString)) {
                return new RestMethodResult(400);
            }
            String localeString = (String)propertySet.get(MailTemplate.locale.jsonName());
            String confKey = UUID.randomUUID().toString();
            Result result = StructrApp.getInstance().nodeQuery(User.class).and((PropertyKey)User.eMail, (Object)emailString).getResult();
            if (!result.isEmpty()) {
                user = (Principal)result.get(0);
                user.setProperties(this.securityContext, new PropertyMap(User.confirmationKey, (Object)confKey));
                existingUser = true;
            } else {
                Authenticator auth = this.securityContext.getAuthenticator();
                user = RegistrationResource.createUser(this.securityContext, (PropertyKey)User.eMail, emailString, propertySet, (Boolean)Settings.RestUserAutocreate.getValue(), auth.getUserClass(), confKey);
            }
            if (user != null) {
                if (!this.sendInvitationLink(user, propertySet, confKey, localeString)) {
                    return new RestMethodResult(400);
                }
                if (existingUser) {
                    return new RestMethodResult(200);
                }
                return new RestMethodResult(201);
            }
            return new RestMethodResult(400);
        }
        return new RestMethodResult(400);
    }

    public RestMethodResult doOptions() throws FrameworkException {
        throw new NotAllowedException("OPTIONS not allowed on " + this.getResourceSignature());
    }

    public Resource tryCombineWith(Resource next) throws FrameworkException {
        return null;
    }

    private boolean sendInvitationLink(Principal user, Map<String, Object> propertySetFromUserPOST, String confKey, String localeString) {
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        RegistrationResource.populateReplacementMap(replacementMap, propertySetFromUserPOST);
        String userEmail = (String)user.getProperty((PropertyKey)User.eMail);
        String appHost = (String)Settings.ApplicationHost.getValue();
        Integer httpPort = (Integer)Settings.HttpPort.getValue();
        replacementMap.put(RegistrationResource.toPlaceholder(User.eMail.jsonName()), userEmail);
        replacementMap.put(RegistrationResource.toPlaceholder("link"), this.getTemplateText(TemplateKey.BASE_URL, "http://" + appHost + ":" + httpPort, localeString) + this.getTemplateText(TemplateKey.CONFIRM_REGISTRATION_PAGE, "/confirm_registration", localeString) + "?" + this.getTemplateText(TemplateKey.CONFIRM_KEY_KEY, "key", localeString) + "=" + confKey + "&" + this.getTemplateText(TemplateKey.TARGET_PAGE_KEY, "target", localeString) + "=" + this.getTemplateText(TemplateKey.TARGET_PAGE, "register_thanks", localeString) + "&" + this.getTemplateText(TemplateKey.ERROR_PAGE_KEY, "onerror", localeString) + "=" + this.getTemplateText(TemplateKey.ERROR_PAGE, "register_error", localeString));
        String textMailTemplate = this.getTemplateText(TemplateKey.TEXT_BODY, "Go to ${link} to finalize registration.", localeString);
        String htmlMailTemplate = this.getTemplateText(TemplateKey.HTML_BODY, "<div>Click <a href='${link}'>here</a> to finalize registration.</div>", localeString);
        String textMailContent = MailHelper.replacePlaceHoldersInTemplate((String)textMailTemplate, replacementMap);
        String htmlMailContent = MailHelper.replacePlaceHoldersInTemplate((String)htmlMailTemplate, replacementMap);
        try {
            MailHelper.sendHtmlMail((String)this.getTemplateText(TemplateKey.SENDER_ADDRESS, "structr-mail-daemon@localhost", localeString), (String)this.getTemplateText(TemplateKey.SENDER_NAME, "Structr Mail Daemon", localeString), (String)userEmail, (String)"", null, null, null, (String)this.getTemplateText(TemplateKey.SUBJECT, "Welcome to Structr, please finalize registration", localeString), (String)htmlMailContent, (String)textMailContent, (EmailAttachment[])new EmailAttachment[0]);
        }
        catch (Exception e) {
            logger.error("Unable to send registration e-mail", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getTemplateText(TemplateKey key, String defaultValue, String localeString) {
        try {
            MailTemplate template;
            Query query = StructrApp.getInstance().nodeQuery(MailTemplate.class).andName(key.name());
            if (localeString != null) {
                query.and((PropertyKey)MailTemplate.locale, (Object)localeString);
            }
            if ((template = (MailTemplate)query.getFirst()) != null) {
                String text = (String)template.getProperty((PropertyKey)MailTemplate.text);
                return text != null ? text : defaultValue;
            }
            return defaultValue;
        }
        catch (FrameworkException ex) {
            LoggerFactory.getLogger((String)RegistrationResource.class.getName()).warn("Could not get mail template for key " + (Object)((Object)key), (Throwable)ex);
            return null;
        }
    }

    private static void populateReplacementMap(Map<String, String> replacementMap, Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            replacementMap.put(RegistrationResource.toPlaceholder(entry.getKey()), entry.getValue().toString());
        }
    }

    private static String toPlaceholder(String key) {
        return "${".concat(key).concat("}");
    }

    public Principal createUser(SecurityContext securityContext, PropertyKey credentialKey, String credentialValue, String confKey) {
        return this.createUser(securityContext, credentialKey, credentialValue, Collections.EMPTY_MAP, confKey);
    }

    public Principal createUser(SecurityContext securityContext, PropertyKey credentialKey, String credentialValue, Map<String, Object> propertySet, String confKey) {
        return this.createUser(securityContext, credentialKey, credentialValue, propertySet, false, confKey);
    }

    public Principal createUser(SecurityContext securityContext, PropertyKey credentialKey, String credentialValue, boolean autoCreate, String confKey) {
        return this.createUser(securityContext, credentialKey, credentialValue, Collections.EMPTY_MAP, autoCreate, confKey);
    }

    public static Principal createUser(SecurityContext securityContext, PropertyKey credentialKey, String credentialValue, boolean autoCreate, Class userClass, String confKey) {
        return RegistrationResource.createUser(securityContext, credentialKey, credentialValue, Collections.EMPTY_MAP, autoCreate, userClass, confKey);
    }

    public Principal createUser(SecurityContext securityContext, PropertyKey credentialKey, String credentialValue, Map<String, Object> propertySet, boolean autoCreate, String confKey) {
        return RegistrationResource.createUser(securityContext, credentialKey, credentialValue, propertySet, autoCreate, User.class, confKey);
    }

    public static Principal createUser(SecurityContext securityContext, PropertyKey credentialKey, String credentialValue, Map<String, Object> propertySet, boolean autoCreate, Class userClass, String confKey) {
        Principal user = null;
        try {
            user = AuthHelper.getPrincipalForCredential((PropertyKey)credentialKey, (Object)credentialValue);
            if (user != null) {
                user = (Principal)new NodeFactory(securityContext).instantiate(user.getNode());
                user.unlockSystemPropertiesOnce();
                PropertyMap changedProperties = new PropertyMap();
                changedProperties.put((PropertyKey)AbstractNode.type, (Object)User.class.getSimpleName());
                changedProperties.put(User.confirmationKey, (Object)confKey);
                user.setProperties(securityContext, changedProperties);
            } else if (autoCreate) {
                App app = StructrApp.getInstance((SecurityContext)securityContext);
                propertySet.remove(credentialKey.jsonName());
                propertySet.remove(User.confirmationKey.jsonName());
                PropertyMap props = PropertyMap.inputTypeToJavaType((SecurityContext)securityContext, Principal.class, propertySet);
                String customAttributesString = User.eMail.jsonName() + "," + (String)Settings.RegistrationCustomAttributes.getValue();
                List<String> customAttributes = Arrays.asList(customAttributesString.split("[ ,]+"));
                HashSet<PropertyKey> propsToRemove = new HashSet<PropertyKey>();
                for (PropertyKey key : props.keySet()) {
                    if (customAttributes.contains(key.jsonName())) continue;
                    propsToRemove.add(key);
                }
                for (PropertyKey propToRemove : propsToRemove) {
                    props.remove(propToRemove);
                }
                props.put(credentialKey, (Object)credentialValue);
                props.put(User.confirmationKey, (Object)confKey);
                user = (Principal)app.create(userClass, props);
            } else {
                logger.info("User self-registration is not configured yet, cannot create new user.");
            }
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
        }
        return user;
    }

    public Class getEntityClass() {
        return null;
    }

    public String getUriPart() {
        return "registration";
    }

    public String getResourceSignature() {
        return "_registration";
    }

    public boolean isCollectionResource() {
        return false;
    }

    private static enum TemplateKey {
        SENDER_NAME,
        SENDER_ADDRESS,
        SUBJECT,
        TEXT_BODY,
        HTML_BODY,
        BASE_URL,
        TARGET_PAGE,
        ERROR_PAGE,
        CONFIRM_REGISTRATION_PAGE,
        CONFIRM_KEY_KEY,
        TARGET_PAGE_KEY,
        ERROR_PAGE_KEY;

    }
}

