/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructrWriteListener
implements WriteListener {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrWriteListener.class.getName());
    private static final int COPY_BUFFER_SIZE = 4096;
    private byte[] buffer = new byte[4096];
    private final InputStream content;
    private final AsyncContext async;
    private final ServletOutputStream out;

    public StructrWriteListener(InputStream content, AsyncContext async, ServletOutputStream out) {
        this.content = content;
        this.async = async;
        this.out = out;
    }

    public void onWritePossible() throws IOException {
        while (this.out.isReady()) {
            int len = this.content.read(this.buffer);
            if (len < 0) {
                this.async.complete();
                return;
            }
            this.out.write(this.buffer, 0, len);
        }
    }

    public void onError(Throwable t) {
        logger.error("Async error", t);
        this.async.complete();
    }
}

