/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.structr.core.entity.AbstractNode;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class AppendChildCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String id = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        if (id == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node, no id is given").build(), true);
            return;
        }
        if (parentId == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot add node without parentId").build(), true);
            return;
        }
        AbstractNode parentNode = this.getNode(parentId);
        if (parentNode == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
            return;
        }
        if (parentNode instanceof DOMNode) {
            DOMNode parentDOMNode = this.getDOMNode(parentId);
            if (parentDOMNode == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Parent node is no DOM node").build(), true);
                return;
            }
            DOMNode node = this.getDOMNode(id);
            if (node != null) {
                parentDOMNode.appendChild(node);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot use given node, not instance of DOMNode").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "APPEND_CHILD";
    }

    static {
        StructrWebSocket.addCommand(AppendChildCommand.class);
    }
}

