/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.ContentContainer;
import org.structr.web.entity.ContentItem;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class AppendContentItemCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)AppendContentItemCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String id = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        if (id == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node, no id is given").build(), true);
            return;
        }
        if (parentId == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node without parentId").build(), true);
            return;
        }
        if (parentId.equals(id)) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node as its own child.").build(), true);
            return;
        }
        AbstractNode parentNode = this.getNode(parentId);
        if (parentNode == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
            return;
        }
        if (parentNode instanceof ContentContainer) {
            ContentContainer container = (ContentContainer)parentNode;
            ContentItem item = (ContentItem)this.getNode(id);
            if (item != null) {
                try {
                    List items = (List)container.getProperty((PropertyKey)ContentContainer.items);
                    items.add(item);
                    container.setProperties(container.getSecurityContext(), new PropertyMap(ContentContainer.items, (Object)items));
                    TransactionCommand.registerNodeCallback((NodeInterface)item, (String)this.callback);
                }
                catch (FrameworkException ex) {
                    logger.error("", (Throwable)ex);
                    this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append content item").build(), true);
                }
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Parent node is not instance of ContentContainer").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "APPEND_CONTENT_ITEM";
    }

    static {
        StructrWebSocket.addCommand(AppendContentItemCommand.class);
    }
}

