/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.Widget;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class CreateLocalWidgetCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)CreateLocalWidgetCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        App app = StructrApp.getInstance((SecurityContext)this.getWebSocket().getSecurityContext());
        String id = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String source = (String)nodeData.get("source");
        String name = (String)nodeData.get("name");
        if (id == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot create widget without id").build(), true);
            return;
        }
        DOMNode node = this.getDOMNode(id);
        if (node == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Node not found").build(), true);
            return;
        }
        try {
            PropertyMap properties = new PropertyMap();
            properties.put((PropertyKey)AbstractNode.type, (Object)Widget.class.getSimpleName());
            properties.put((PropertyKey)AbstractNode.name, (Object)name);
            properties.put(Widget.source, (Object)source);
            Widget widget = (Widget)app.create(Widget.class, properties);
            TransactionCommand.registerNodeCallback((NodeInterface)widget, (String)this.callback);
        }
        catch (Throwable t) {
            logger.warn(t.toString());
            this.getWebSocket().send(MessageBuilder.status().code(422).message(t.toString()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CREATE_LOCAL_WIDGET";
    }

    static {
        StructrWebSocket.addCommand(CreateLocalWidgetCommand.class);
    }
}

