/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.LinkedTreeNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class DeleteNodeCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)DeleteNodeCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        Boolean recursive = (Boolean)webSocketData.getNodeData().get("recursive");
        AbstractNode obj = this.getNode(webSocketData.getId());
        if (obj != null) {
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            try {
                Tx tx = app.tx();
                Object object = null;
                try {
                    if (!obj.isGranted(Permission.delete, this.getWebSocket().getSecurityContext())) {
                        logger.warn("No delete permission for {} on {}", new Object[]{this.getWebSocket().getCurrentUser().toString(), obj.toString()});
                        this.getWebSocket().send(MessageBuilder.status().message("No delete permission").code(400).build(), true);
                        tx.success();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (object != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (FrameworkException ex) {
                logger.warn("", (Throwable)ex);
            }
            if (Boolean.TRUE.equals(recursive)) {
                try {
                    DOMNode node;
                    LinkedList<DOMNode> filteredResults = new LinkedList<DOMNode>();
                    if (obj instanceof DOMNode) {
                        node = (DOMNode)obj;
                        filteredResults.addAll(DOMNode.getAllChildNodes(node));
                    } else if (obj instanceof LinkedTreeNode) {
                        node = (LinkedTreeNode)obj;
                        filteredResults.addAll(node.getAllChildNodes());
                    }
                    for (NodeInterface nodeInterface : filteredResults) {
                        app.delete(nodeInterface);
                    }
                }
                catch (FrameworkException fex) {
                    logger.warn("Exception occured", (Throwable)fex);
                    this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
                }
                catch (DOMException dex) {
                    logger.warn("DOMException occured.", (Throwable)dex);
                    this.getWebSocket().send(MessageBuilder.status().code(422).message(dex.getMessage()).build(), true);
                }
            }
            try {
                app.delete((NodeInterface)obj);
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to delete node(s)", (Throwable)fex);
            }
        }
    }

    @Override
    public String getCommand() {
        return "DELETE";
    }

    static {
        StructrWebSocket.addCommand(DeleteNodeCommand.class);
    }
}

