/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.WebSocketMessage;

public class GetCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)GetCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        GraphObject graphObject;
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        String properties = (String)webSocketData.getNodeData().get("properties");
        if (properties != null) {
            securityContext.setCustomView(StringUtils.split((String)properties, (String)","));
        }
        if ((graphObject = this.getGraphObject(webSocketData.getId())) != null) {
            webSocketData.setResult(Arrays.asList(graphObject));
            this.getWebSocket().send(webSocketData, true);
        }
    }

    @Override
    public String getCommand() {
        return "GET";
    }

    static {
        StructrWebSocket.addCommand(GetCommand.class);
    }
}

