/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.io.IOException;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyKey;
import org.structr.web.common.ImageHelper;
import org.structr.web.entity.Image;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ImageConverterCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String originalImageId = webSocketData.getId();
        Map<String, Object> properties = webSocketData.getNodeData();
        Image originalImage = (Image)this.getNode(originalImageId);
        String format = (String)properties.get("format");
        int width = (int)((Long)properties.get("width")).longValue();
        int height = (int)((Long)properties.get("height")).longValue();
        int offsetX = (int)((Long)properties.get("offsetX")).longValue();
        int offsetY = (int)((Long)properties.get("offsetY")).longValue();
        if (originalImage != null) {
            ImageHelper.Thumbnail thumbnailData = ImageHelper.createCroppedImage(originalImage, width, height, offsetX, offsetY, format);
            if (thumbnailData != null) {
                Integer tnWidth = thumbnailData.getWidth();
                Integer tnHeight = thumbnailData.getHeight();
                try {
                    byte[] data = thumbnailData.getBytes();
                    String thumbnailName = ImageHelper.getVariantName(originalImage.getName(), tnWidth, tnHeight, "_cropped_");
                    Image imageVariant = ImageHelper.createImageNode(originalImage.getSecurityContext(), data, "image/" + (Object)((Object)ImageHelper.Thumbnail.Format.png), Image.class, thumbnailName, false);
                    imageVariant.setProperty((PropertyKey)Image.parent, originalImage.getProperty((PropertyKey)Image.parent));
                }
                catch (IOException | FrameworkException ex) {
                    this.getWebSocket().send(MessageBuilder.status().code(400).message("Could not create converted image for " + originalImageId).build(), true);
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(400).message("Could not create converted image for " + originalImageId).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(400).message("No id of the original image given").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CONVERT_IMAGE";
    }

    static {
        StructrWebSocket.addCommand(ImageConverterCommand.class);
    }
}

