/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.property.PropertyKey;
import org.structr.schema.SchemaHelper;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.Image;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ListCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ListCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String rawType = (String)nodeData.get("type");
        String properties = (String)webSocketData.getNodeData().get("properties");
        boolean rootOnly = Boolean.TRUE.equals((Boolean)nodeData.get("rootOnly"));
        Class type = SchemaHelper.getEntityClassForRawType((String)rawType);
        if (type == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Type " + rawType + " not found").build(), true);
            return;
        }
        if (properties != null) {
            securityContext.setCustomView(StringUtils.split((String)properties, (String)","));
        }
        String sortOrder = webSocketData.getSortOrder();
        String sortKey = webSocketData.getSortKey();
        int pageSize = webSocketData.getPageSize();
        int page = webSocketData.getPage();
        PropertyKey sortProperty = StructrApp.getConfiguration().getPropertyKeyForJSONName(type, sortKey);
        Query query = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(type).sort(sortProperty).order("desc".equals(sortOrder)).page(page).pageSize(pageSize);
        if (FileBase.class.isAssignableFrom(type)) {
            if (rootOnly) {
                query.and((PropertyKey)FileBase.hasParent, (Object)false);
            }
            query.not().and(Image.isThumbnail, (Object)true);
        }
        if (Folder.class.isAssignableFrom(type) && rootOnly) {
            query.and((PropertyKey)Folder.hasParent, (Object)false);
        }
        try {
            Result result = query.getResult();
            int resultCountBeforePaging = result.getRawResultCount();
            webSocketData.setResult(result.getResults());
            webSocketData.setRawResultCount(resultCountBeforePaging);
            this.getWebSocket().send(webSocketData, true);
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "LIST";
    }

    static {
        StructrWebSocket.addCommand(ListCommand.class);
    }
}

