/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.PagingHelper;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.relationship.DOMChildren;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.command.CreateComponentCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ListComponentsCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ListComponentsCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        int pageSize = webSocketData.getPageSize();
        int page = webSocketData.getPage();
        try {
            ShadowDocument hiddenDoc = CreateComponentCommand.getOrCreateHiddenDocument();
            LinkedList<DOMNode> filteredResults = new LinkedList<DOMNode>();
            List resultList = (List)hiddenDoc.getProperty((PropertyKey)Page.elements);
            for (DOMNode node : resultList) {
                if (!Boolean.FALSE.equals(node.hasIncomingRelationships(DOMChildren.class))) continue;
                filteredResults.add(node);
            }
            Collections.sort(filteredResults, new Comparator<DOMNode>(){

                @Override
                public int compare(DOMNode node1, DOMNode node2) {
                    String nameNode1 = (String)node1.getProperty((PropertyKey)DOMNode.name);
                    String nameNode2 = (String)node2.getProperty((PropertyKey)DOMNode.name);
                    if (nameNode1 != null && nameNode2 != null) {
                        return nameNode1.compareTo(nameNode2);
                    }
                    if (nameNode1 == null && nameNode2 == null) {
                        return 0;
                    }
                    if (nameNode1 == null) {
                        return -1;
                    }
                    return 1;
                }
            });
            int resultCountBeforePaging = filteredResults.size();
            webSocketData.setResult(PagingHelper.subList(filteredResults, (int)pageSize, (int)page, null));
            webSocketData.setRawResultCount(resultCountBeforePaging);
            this.getWebSocket().send(webSocketData, true);
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "LIST_COMPONENTS";
    }

    static {
        StructrWebSocket.addCommand(ListComponentsCommand.class);
    }
}

