/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.schema.SchemaHelper;
import org.structr.web.entity.Image;
import org.structr.web.entity.relation.FileChildren;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.WebSocketMessage;

public class ListFilesCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ListFilesCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        String rawType = (String)webSocketData.getNodeData().get("type");
        Class type = SchemaHelper.getEntityClassForRawType((String)rawType);
        String sortOrder = webSocketData.getSortOrder();
        String sortKey = webSocketData.getSortKey();
        int pageSize = webSocketData.getPageSize();
        int page = webSocketData.getPage();
        PropertyKey sortProperty = StructrApp.getConfiguration().getPropertyKeyForJSONName(type, sortKey);
        Query query = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(type).includeDeletedAndHidden().sort(sortProperty).order("desc".equals(sortOrder));
        if (type.equals(Image.class)) {
            query.and(Image.isThumbnail, (Object)false);
        }
        try {
            LinkedList<AbstractNode> filteredResults = new LinkedList<AbstractNode>();
            List resultList = query.getAsList();
            for (GraphObject obj : resultList) {
                AbstractNode node;
                if (!(obj instanceof AbstractNode) || (node = (AbstractNode)obj).hasIncomingRelationships(FileChildren.class)) continue;
                filteredResults.add(node);
            }
            int resultCountBeforePaging = filteredResults.size();
            webSocketData.setResult(PagingHelper.subList(filteredResults, (int)pageSize, (int)page, null));
            webSocketData.setRawResultCount(resultCountBeforePaging);
            this.getWebSocket().send(webSocketData, true);
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public String getCommand() {
        return "LIST_FILES";
    }

    static {
        StructrWebSocket.addCommand(ListFilesCommand.class);
    }
}

