/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.auth.Authenticator;
import org.structr.core.auth.exception.AuthenticationException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.property.PropertyKey;
import org.structr.rest.auth.SessionHelper;
import org.structr.schema.action.Actions;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class LoginCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)LoginCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        block7: {
            String username = (String)webSocketData.getNodeData().get("username");
            String password = (String)webSocketData.getNodeData().get("password");
            if (username != null && password != null) {
                try {
                    StructrWebSocket socket = this.getWebSocket();
                    Authenticator auth = socket.getAuthenticator();
                    Principal user = auth.doLogin(socket.getRequest(), username, password);
                    if (user == null) break block7;
                    String sessionId = webSocketData.getSessionId();
                    if (sessionId == null) {
                        logger.info("Unable to login {}: No sessionId found", new Object[]{username, password});
                        this.getWebSocket().send(MessageBuilder.status().code(403).build(), true);
                        return;
                    }
                    try {
                        Actions.call((String)"onStructrLogin", (Principal)user);
                    }
                    catch (UnlicensedException ex) {
                        ex.log(logger);
                    }
                    SessionHelper.clearSession((String)sessionId);
                    user.addSessionId(sessionId);
                    webSocketData.getNodeData().clear();
                    webSocketData.setSessionId(sessionId);
                    webSocketData.getNodeData().put("username", user.getProperty((PropertyKey)AbstractNode.name));
                    socket.setAuthenticated(sessionId, user);
                    socket.send(webSocketData, false);
                }
                catch (AuthenticationException e) {
                    logger.info("Unable to login {}, probably wrong password", (Object)username);
                    this.getWebSocket().send(MessageBuilder.status().code(403).build(), true);
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to execute command", (Throwable)fex);
                }
            }
        }
    }

    @Override
    public String getCommand() {
        return "LOGIN";
    }

    static {
        StructrWebSocket.addCommand(LoginCommand.class);
    }
}

