/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.schema.SchemaHelper;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class QueryCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)QueryCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String rawType = (String)nodeData.get("type");
        String properties = (String)nodeData.get("properties");
        Boolean exact = (Boolean)nodeData.get("exact");
        Class type = SchemaHelper.getEntityClassForRawType((String)rawType);
        if (type == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Type " + rawType + " not found").build(), true);
            return;
        }
        String sortOrder = webSocketData.getSortOrder();
        String sortKey = webSocketData.getSortKey();
        int pageSize = webSocketData.getPageSize();
        int page = webSocketData.getPage();
        PropertyKey sortProperty = StructrApp.getConfiguration().getPropertyKeyForJSONName(type, sortKey);
        Query query = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(type).sort(sortProperty).order("desc".equals(sortOrder)).page(page).pageSize(pageSize);
        if (properties != null) {
            try {
                Gson gson = new GsonBuilder().create();
                Map querySource = (Map)gson.fromJson(properties, new TypeToken<Map<String, Object>>(){}.getType());
                PropertyMap queryMap = PropertyMap.inputTypeToJavaType((SecurityContext)securityContext, (Class)type, (Map)querySource);
                boolean inexactQuery = exact != null && exact == false;
                for (Map.Entry entry : queryMap.entrySet()) {
                    query.and((PropertyKey)entry.getKey(), entry.getValue(), !inexactQuery);
                }
            }
            catch (FrameworkException fex) {
                logger.warn("Exception occured", (Throwable)fex);
                this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
                return;
            }
        }
        try {
            Result result = query.getResult();
            int resultCountBeforePaging = result.getRawResultCount();
            webSocketData.setResult(result.getResults());
            webSocketData.setRawResultCount(resultCountBeforePaging);
            this.getWebSocket().send(webSocketData, true);
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "QUERY";
    }

    static {
        StructrWebSocket.addCommand(QueryCommand.class);
    }
}

