/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class RemoveCommand
extends AbstractCommand {
    private static final Logger logger;

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        String id = webSocketData.getId();
        if (id != null) {
            AbstractNode node = this.getNode(id);
            if (node != null) {
                if (node instanceof DOMNode) {
                    DOMNode domNode = (DOMNode)node;
                    try {
                        domNode.getParentNode().removeChild(domNode);
                        this.recursivelyRemoveNodesFromPage(domNode, securityContext);
                    }
                    catch (FrameworkException | DOMException ex) {
                        logger.error("Could not remove node from page " + domNode, ex);
                        this.getWebSocket().send(MessageBuilder.status().code(422).message(ex.getMessage()).build(), true);
                    }
                } else {
                    logger.warn("Deprecated use of RemoveCommand, please report this error and the following stack trace to the Structr team on https://github.com/structr/structr. Thanks!");
                    Thread.dumpStack();
                    App app = StructrApp.getInstance((SecurityContext)securityContext);
                    try {
                        for (AbstractRelationship rel : node.getIncomingRelationships()) {
                            if (!"CONTAINS".equals(rel.getType())) continue;
                            app.delete((RelationshipInterface)rel);
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Could not delete relationship", t);
                        this.getWebSocket().send(MessageBuilder.status().code(400).message("Error in RemoveCommand: " + t.getMessage()).build(), true);
                    }
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(404).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(400).message("RemoveCommand called with empty id").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "REMOVE";
    }

    private void recursivelyRemoveNodesFromPage(DOMNode parent, SecurityContext securityContext) throws FrameworkException {
        PropertyMap changedProperties = new PropertyMap();
        changedProperties.put(DOMNode.syncedNodes, (Object)Collections.EMPTY_LIST);
        changedProperties.put(DOMNode.pageId, null);
        parent.setProperties(securityContext, changedProperties);
        for (DOMNode child : (List)parent.getProperty((PropertyKey)DOMNode.children)) {
            this.recursivelyRemoveNodesFromPage(child, securityContext);
        }
    }

    static {
        StructrWebSocket.addCommand(RemoveCommand.class);
        logger = LoggerFactory.getLogger((String)RemoveCommand.class.getName());
    }
}

