/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.Permissions;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.StaticValue;
import org.structr.core.Value;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.LinkedTreeNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class SetPermissionCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)SetPermissionCommand.class.getName());
    private int sum = 0;
    private int count = 0;

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Principal principal;
        AbstractNode obj = this.getNode(webSocketData.getId());
        boolean rec = (Boolean)webSocketData.getNodeData().get("recursive");
        String principalId = (String)webSocketData.getNodeData().get("principalId");
        String permission = (String)webSocketData.getNodeData().get("permission");
        String action = (String)webSocketData.getNodeData().get("action");
        if (principalId == null) {
            logger.error("This command needs a principalId");
            this.getWebSocket().send(MessageBuilder.status().code(400).build(), true);
        }
        if ((principal = (Principal)this.getNode(principalId)) == null) {
            logger.error("No principal found with id {}", new Object[]{principalId});
            this.getWebSocket().send(MessageBuilder.status().code(400).build(), true);
        }
        webSocketData.getNodeData().remove("recursive");
        if (obj != null) {
            App app = StructrApp.getInstance((SecurityContext)this.getWebSocket().getSecurityContext());
            try (Tx nestedTx = app.tx();){
                if (!obj.isGranted(Permission.accessControl, this.getWebSocket().getSecurityContext())) {
                    logger.warn("No access control permission for {} on {}", new Object[]{this.getWebSocket().getCurrentUser().toString(), obj.toString()});
                    this.getWebSocket().send(MessageBuilder.status().message("No access control permission").code(400).build(), true);
                    nestedTx.success();
                    return;
                }
                nestedTx.success();
            }
            catch (FrameworkException ex) {
                logger.warn("", (Throwable)ex);
            }
            try {
                StaticValue value = new StaticValue(null);
                this.setPermission((Value<Tx>)value, app, obj, principal, action, Permissions.valueOf((String)permission), rec);
                Tx tx = (Tx)value.get(null);
                if (tx != null) {
                    tx.success();
                    tx.close();
                    value.set(null, null);
                }
                webSocketData.setResult(Arrays.asList(principal));
                this.getWebSocket().send(webSocketData, true);
            }
            catch (FrameworkException ex) {
                logger.error("Unable to set permissions: {}", (Object)ex.toString());
                this.getWebSocket().send(MessageBuilder.status().code(400).build(), true);
            }
        } else {
            logger.warn("Graph object with uuid {} not found.", (Object)webSocketData.getId());
            this.getWebSocket().send(MessageBuilder.status().code(404).build(), true);
        }
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public String getCommand() {
        return "SET_PERMISSION";
    }

    private void setPermission(Value<Tx> transaction, App app, AbstractNode obj, Principal principal, String action, Permission permission, boolean rec) throws FrameworkException {
        Tx tx = (Tx)transaction.get(null);
        if (tx == null) {
            tx = app.tx();
            transaction.set(null, (Object)tx);
        }
        switch (action) {
            case "grant": {
                obj.grant(permission, principal);
                break;
            }
            case "revoke": {
                obj.revoke(permission, principal);
            }
        }
        ++this.sum;
        if (++this.count == 100) {
            logger.info("Committing transaction after {} objects..", (Object)this.sum);
            this.count = 0;
            tx.success();
            tx.close();
            tx = app.tx(true, true, false);
        }
        if (rec && obj instanceof LinkedTreeNode) {
            for (Object t : ((LinkedTreeNode)obj).treeGetChildren()) {
                this.setPermission(transaction, app, (AbstractNode)t, principal, action, permission, rec);
            }
        }
    }

    static {
        StructrWebSocket.addCommand(SetPermissionCommand.class);
    }
}

