/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.PathHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.web.common.FileHelper;
import org.structr.web.common.ImageHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.Image;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class UnarchiveCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)UnarchiveCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        HashSet<String> supportedByArchiveStreamFactory = new HashSet<String>(Arrays.asList("ar", "arj", "cpio", "dump", "jar", "tar", "zip"));
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        try {
            FileBase file;
            String id = webSocketData.getId();
            String parentFolderId = (String)webSocketData.getNodeData().get("parentFolderId");
            try (Tx tx = app.tx();){
                file = (FileBase)app.get(FileBase.class, id);
                if (file == null) {
                    this.getWebSocket().send(MessageBuilder.status().code(400).message("File not found: ".concat(id)).build(), true);
                    return;
                }
                String fileExtension = StringUtils.substringAfterLast((String)file.getName(), (String)".");
                if (!supportedByArchiveStreamFactory.contains(fileExtension)) {
                    this.getWebSocket().send(MessageBuilder.status().code(400).message("Unsupported archive format: ".concat(fileExtension)).build(), true);
                    return;
                }
                tx.success();
            }
            this.unarchive(securityContext, file, parentFolderId);
        }
        catch (Throwable t) {
            logger.warn("", t);
            String msg = t.toString();
            try (Tx tx = app.tx();){
                this.getWebSocket().send(MessageBuilder.status().code(400).message("Could not unarchive file: ".concat(msg != null ? msg : "")).build(), true);
                this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).data("success", false).build(), true);
                tx.success();
            }
            catch (FrameworkException frameworkException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    private void unarchive(SecurityContext securityContext, FileBase file, String parentFolderId) throws ArchiveException, IOException, FrameworkException {
        InputStream is;
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        Folder existingParentFolder = null;
        String fileName = file.getName();
        try (Tx tx = app.tx();){
            existingParentFolder = (Folder)app.get(Folder.class, parentFolderId);
            String parentFolderName = null;
            String msgString = "Unarchiving file {}";
            if (existingParentFolder != null) {
                parentFolderName = existingParentFolder.getName();
                msgString = msgString + " into existing folder {}.";
            }
            logger.info(msgString, new Object[]{fileName, parentFolderName});
            is = file.getInputStream();
            tx.success();
            if (is == null) {
                this.getWebSocket().send(MessageBuilder.status().code(400).message("Could not get input stream from file ".concat(fileName)).build(), true);
                return;
            }
            tx.success();
        }
        var9_8 = null;
        try (ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));){
            ArchiveEntry entry = in.getNextEntry();
            int overallCount = 0;
            while (entry != null) {
                Tx tx = app.tx(true, true, false);
                Throwable throwable = null;
                try {
                    int count = 0;
                    while (entry != null && count++ < 50) {
                        String entryPath = "/" + PathHelper.clean((String)entry.getName());
                        logger.info("Entry path: {}", (Object)entryPath);
                        if (entry.isDirectory()) {
                            String folderPath = (existingParentFolder != null ? existingParentFolder.getPath() : "") + "/" + entryPath;
                            Folder newFolder = FileHelper.createFolderPath(securityContext, folderPath);
                            logger.info("Created folder {} with path {}", new Object[]{newFolder, FileHelper.getFolderPath(newFolder)});
                        } else {
                            String filePath = (existingParentFolder != null ? existingParentFolder.getPath() : "") + "/" + entryPath;
                            String name = PathHelper.getName((String)entryPath);
                            File newFile = ImageHelper.isImageType(name) ? ImageHelper.createImage(securityContext, (InputStream)in, null, Image.class, name, false) : FileHelper.createFile(securityContext, (InputStream)in, null, File.class, name);
                            String folderPath = StringUtils.substringBeforeLast((String)filePath, (String)"/");
                            Folder parentFolder = FileHelper.createFolderPath(securityContext, folderPath);
                            if (parentFolder != null) {
                                newFile.setProperties(securityContext, new PropertyMap(AbstractFile.parent, (Object)parentFolder));
                            }
                            logger.info("Created {} file {} with path {}", new Object[]{newFile.getType(), newFile, FileHelper.getFolderPath(newFile)});
                        }
                        entry = in.getNextEntry();
                        ++overallCount;
                    }
                    logger.info("Committing transaction after {} files.", (Object)overallCount);
                    tx.success();
                    logger.info("Unarchived {} files.", (Object)overallCount);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).data("success", true).data("filename", fileName).build(), true);
    }

    @Override
    public String getCommand() {
        return "UNARCHIVE";
    }

    static {
        StructrWebSocket.addCommand(UnarchiveCommand.class);
    }
}

