/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.common.FileHelper;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class UploadCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)UploadCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        try {
            String name = (String)webSocketData.getNodeData().get("name");
            String rawData = (String)webSocketData.getNodeData().get("fileData");
            Object newFile = FileHelper.createFileBase64(securityContext, rawData, null);
            newFile.setProperties(securityContext, new PropertyMap((PropertyKey)AbstractNode.name, (Object)name));
        }
        catch (Throwable t) {
            String msg = t.toString();
            this.getWebSocket().send(MessageBuilder.status().code(400).message("Could not upload file: ".concat(msg != null ? msg : "")).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "UPLOAD";
    }

    static {
        StructrWebSocket.addCommand(UploadCommand.class);
    }
}

