/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.StaticValue;
import org.structr.core.Value;
import org.structr.rest.ResourceProvider;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.resource.Resource;
import org.structr.rest.servlet.ResourceHelper;
import org.structr.web.common.UiResourceProvider;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.command.WrapContentCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class WrappedRestCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)WrapContentCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) throws FrameworkException {
        Resource resource;
        ResourceProvider resourceProvider;
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String method = (String)nodeData.get("method");
        if (method == null || !method.equals("POST") && !method.equals("PUT")) {
            logger.warn("Method not supported: {}", (Object)method);
            this.getWebSocket().send(MessageBuilder.wrappedRest().code(422).message("Method not supported: " + method).build(), true);
            return;
        }
        try {
            resourceProvider = (ResourceProvider)UiResourceProvider.class.newInstance();
        }
        catch (Throwable t) {
            logger.error("Couldn't establish a resource provider", t);
            this.getWebSocket().send(MessageBuilder.wrappedRest().code(422).message("Couldn't establish a resource provider").build(), true);
            return;
        }
        LinkedHashMap resourceMap = new LinkedHashMap();
        resourceMap.putAll(resourceProvider.getResources());
        StructrWebSocket socket = this.getWebSocket();
        final String url = (String)nodeData.get("url");
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(socket.getRequest()){

            public Enumeration<String> getParameterNames() {
                return new IteratorEnumeration(this.getParameterMap().keySet().iterator());
            }

            public String getParameter(String key) {
                String[] p = this.getParameterMap().get(key);
                return p != null ? p[0] : null;
            }

            public Map<String, String[]> getParameterMap() {
                String[] parts = StringUtils.split((String)this.getQueryString(), (String)"&");
                HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
                for (String p : parts) {
                    String[] kv = StringUtils.split((String)p, (String)"=");
                    if (kv.length <= 1) continue;
                    parameterMap.put(kv[0], new String[]{kv[1]});
                }
                return parameterMap;
            }

            public String getQueryString() {
                return StringUtils.substringAfter((String)url, (String)"?");
            }

            public String getPathInfo() {
                return StringUtils.substringBefore((String)url, (String)"?");
            }

            public StringBuffer getRequestURL() {
                return new StringBuffer(url);
            }
        };
        StaticValue fakePropertyView = new StaticValue((Object)"public");
        try {
            resource = ResourceHelper.applyViewTransformation((HttpServletRequest)wrappedRequest, (SecurityContext)socket.getSecurityContext(), (Resource)ResourceHelper.optimizeNestedResourceChain((SecurityContext)socket.getSecurityContext(), (HttpServletRequest)wrappedRequest, resourceMap, (Value)fakePropertyView), (Value)fakePropertyView);
        }
        catch (IllegalPathException | NotFoundException e) {
            logger.warn("Illegal path for REST query");
            this.getWebSocket().send(MessageBuilder.wrappedRest().code(422).message("Illegal path for REST query").build(), true);
            return;
        }
        String data = (String)nodeData.get("data");
        Gson gson = new GsonBuilder().create();
        Map jsonData = (Map)gson.fromJson(data, Map.class);
        RestMethodResult result = null;
        switch (method) {
            case "PUT": {
                result = resource.doPut(jsonData);
                break;
            }
            case "POST": {
                result = resource.doPost(jsonData);
            }
        }
        if (result != null) {
            // empty if block
        }
    }

    @Override
    public String getCommand() {
        return "WRAPPED_REST";
    }

    static {
        StructrWebSocket.addCommand(WrappedRestCommand.class);
    }
}

