/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command.dom;

import java.util.List;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class CloneNodeCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String id = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        boolean deep = (Boolean)nodeData.get("deep");
        if (id != null) {
            DOMNode parent = null;
            DOMNode node = this.getDOMNode(id);
            if (parentId != null && (parent = this.getDOMNode(parentId)) == null) {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
                return;
            }
            Page ownerPage = null;
            ownerPage = parent != null ? (parent instanceof Page ? (Page)parent : (Page)parent.getProperty((PropertyKey)DOMNode.ownerDocument)) : (Page)node.getProperty((PropertyKey)DOMNode.ownerDocument);
            if (ownerPage == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot clone node without a target page").build(), true);
                return;
            }
            try {
                DOMNode clonedNode = (DOMNode)node.cloneNode(deep);
                if (parent != null) {
                    parent.appendChild(clonedNode);
                }
                this.setOwnerPageRecursively(clonedNode, clonedNode.getSecurityContext(), new PropertyMap(DOMNode.ownerDocument, (Object)ownerPage));
            }
            catch (FrameworkException | DOMException ex) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message(ex.getMessage()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node without id").build(), true);
        }
    }

    public void setOwnerPageRecursively(DOMNode node, SecurityContext securityContext, PropertyMap properties) throws FrameworkException {
        node.setProperties(securityContext, properties);
        for (DOMNode child : (List)((Object)node.getChildNodes())) {
            this.setOwnerPageRecursively(child, securityContext, properties);
        }
    }

    @Override
    public String getCommand() {
        return "CLONE_NODE";
    }

    static {
        StructrWebSocket.addCommand(CloneNodeCommand.class);
    }
}

